/* rfIoctl.h - ioctl header file for vxWorks rimfire 3200 SMD driver */

/* Copyright 1986, 1988 Ciprico, Inc. */

/*
modification history
--------------------
01b,01may89,del  documentation.
01a,29nov88,del  written.
*/


#define	DKC_RF3200	8	/* another controller type */
#define	DKC_RF3400	9	/* another controller type */

/* structure used to return info from ioctl calls */
typedef struct
    {
    long	flags;		/* you name it */
    long	count;		/* transfer count */
    int 	error;		/* error status */
    int		device;		/* device number */
    long	blkNo;		/* block/sector number */
    long	resid;		/* residual error info */
    dword	data;		/* rimfire error specific data*/
    } IOCTL_INFO;


/* structures used by ioctl calls */
						/* disk format/verify  request */
typedef struct 
    {
    long	startBlock;			/* starting block number */
    long	blockCount;			/* # of blocks */
    UTINY  	error;
    long 	badBlock;
    } FMT_VER_REQ;

						/* disk re-map request */
typedef struct 
    {
    long	startBlock;			/* from block */
    long	destBlock;			/* to block */
    long	nBlocks;			/* # of blocks */
    UTINY  	recover;
    UTINY  	error;
    int		mapType;			/* cmd executed by ioctl*/
    } MAP_REQ;


						/* disk slip request */
typedef struct 
    {
    long 	startBlock;
    UTINY  	recover;
    UTINY  	error;
    } SLIP_REQ;

						/* board statistics request */
typedef struct 
    {
    BOOL	clear;		/* TRUE, ctlr clears  existin */
    int		error;		/* ctlr error code */
    BOARDST	*pBoardStats	/* where to put stats when done */
    } STAT_REQ;

typedef struct
    {
    int		error;		/* ctlr error code */
    DEFECTMAP	*pDefectMap;	/* user's defect map */
    } READ_MAP_REQ;

						/* SMD parameters */
typedef struct 
    {
    UTINY 	interleave;
    UTINY 	headskew;
    UTINY 	cylskew;
    UTINY 	hgskew;
    UINT  	recovery;
    UTINY 	idpre;
    UTINY 	datapre;
    } DEFSMD_REQ;

typedef struct
    {
    int		error;
    RETCONF 	*pConfParams;
    } CONFIG_GET_REQ;
						/* Defect list request */
typedef struct 
    { 
    UTINY 	error;
    DEFECTSMD 	smd;
    } RDDEFDATA_REQ; 

						/* read ID of sector */
typedef struct  
    {
    int		error;			/* returned error code */
    int    	cyl;			/* cylinder number */
    int    	secOffset;		/* sec offset within track */
    int		head;			/* head number */
    TRAKID	*pSecID;		/* place to put ID of given track */
    } READSECIDREQ;

#ifndef	RFSTATS
typedef char	*IORQS;
#endif

/* -------------------------------------------------------------------------
 here are the defines for ioctl commands not currently defined in vxWorks
 */
#define FIOCONFIG 	50		/* configure disk */
#define FIOCONFIGGET	51		/* return configuration of disk */
#define FIODEFECTDATAREAD 52		/* read disk defect data */
#define FIOIDGET	54		/* read ID of disk/ctlr */
#define FIOCTLGRPSET 	55		/* set an ioctl group */
#define FIOINTERROGATE	56		/* interrogate the drive */
#define FIOSECIDREAD	57		/* read the ID of a sector */
#define FIOSECTORSLIP	58		/* slip a sector */
#define FIOSMDDEFINE 	59		/* define SMD parameters */
#define FIOSTATGET	60		/* get board statistics */
#define FIOTRKSECMAP	61		/* map a track or sector */
#define FIOTUNE		62		/* ??? */
#define FIOVERIFY	63		/* verify the format of a drive */
#define FIOGEOMGET	64		/* get the disk geometry */
#define FIOGEOMSET	65		/* set the disk geometry */


