/* param.h - parameter header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)param.h	7.1 (Berkeley) 6/4/86
 */

/*
modification history
--------------------
01e,28aug87,dnw  removed unnecessary stuff.
01d,03apr87,ecs  added header and copyright.
01c,02feb87,dnw  removed unnecessary reference to signal.h and ISSIG.
01b,22dec86,dnw  removed redundant definition of NULL
*/

#include "types.h"

/*
 * Clustering of hardware pages on machines with ridiculously small
 * page sizes is done here.  The paging subsystem deals with units of
 * CLSIZE pte's describing NBPG (from vm.h) pages each.
 *
 * NOTE: SSIZE, SINCR and UPAGES must be multiples of CLSIZE
 */
#define	CLBYTES		1024	/* (CLSIZE*NBPG) */

/*
 * Macros for fast min/max.
 */
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))
