/* fga002.h - Force Computers FGA-002 fancy gate array */

/*
modification history
--------------------
01a,14feb89,jcf  written.
*/

/* This header file contains the resisters of the FGA-002 which users may
 * wish to change.  This is not a complete list of registers.
 */

#ifndef	INCfga002h
#define	INCfga002h

/* register definitions */
						  
    /* interrupt control registers */
#define	FGA_ICRMBOX0(base)	((char *)((base) + 0x000))  /* mailbox 0 */
#define	FGA_ICRMBOX1(base)	((char *)((base) + 0x004))  /* mailbox 1 */
#define	FGA_ICRMBOX2(base)	((char *)((base) + 0x008))  /* mailbox 2 */
#define	FGA_ICRMBOX3(base)	((char *)((base) + 0x00C))  /* mailbox 3 */
#define	FGA_ICRMBOX4(base)	((char *)((base) + 0x010))  /* mailbox 4 */
#define	FGA_ICRMBOX5(base)	((char *)((base) + 0x014))  /* mailbox 5 */
#define	FGA_ICRMBOX6(base)	((char *)((base) + 0x018))  /* mailbox 6 */
#define	FGA_ICRMBOX7(base)	((char *)((base) + 0x01C))  /* mailbox 7 */

#define	FGA_ICRTIM0(base)	((char *)((base) + 0x220))  /* timer */

#define	FGA_ICRFMB0REF(base)	((char *)((base) + 0x240))  /* fmb0 refused */
#define	FGA_ICRFMB1REF(base)	((char *)((base) + 0x244))  /* fmb1 refused */
#define	FGA_ICRFMB0MES(base)	((char *)((base) + 0x248))  /* fmb0 message */
#define	FGA_ICRFMB1MES(base)	((char *)((base) + 0x24C))  /* fmb1 message */

#define	FGA_ICRDMANORM(base)	((char *)((base) + 0x230))  /* dma normal */
#define	FGA_ICRDMAERR(base)	((char *)((base) + 0x234))  /* dma error */

#define	FGA_ICRPARITY(base)	((char *)((base) + 0x258))  /* parity */

#define	FGA_ICRVME1(base)	((char *)((base) + 0x204))  /* VMEIRQ 1 */
#define	FGA_ICRVME2(base)	((char *)((base) + 0x208))  /* VMEIRQ 2 */
#define	FGA_ICRVME3(base)	((char *)((base) + 0x20C))  /* VMEIRQ 3 */
#define	FGA_ICRVME4(base)	((char *)((base) + 0x210))  /* VMEIRQ 4 */
#define	FGA_ICRVME5(base)	((char *)((base) + 0x214))  /* VMEIRQ 5 */
#define	FGA_ICRVME6(base)	((char *)((base) + 0x218))  /* VMEIRQ 6 */
#define	FGA_ICRVME7(base)	((char *)((base) + 0x21C))  /* VMEIRQ 7 */

    /* extended interrupt control registers */
#define	FGA_ICRABORT(base)	((char *)((base) + 0x280))  /* abort */
#define	FGA_ICRACFAIL(base)	((char *)((base) + 0x284))  /* acfail */
#define	FGA_ICRSYSFAIL(base)	((char *)((base) + 0x288))  /* sysfail */

#define	FGA_ICRLOCAL0(base)	((char *)((base) + 0x28C))  /* local 0 */
#define	FGA_ICRLOCAL1(base)	((char *)((base) + 0x290))  /* local 1 */
#define	FGA_ICRLOCAL2(base)	((char *)((base) + 0x294))  /* local 2 */
#define	FGA_ICRLOCAL3(base)	((char *)((base) + 0x298))  /* local 3 */
#define	FGA_ICRLOCAL4(base)	((char *)((base) + 0x29C))  /* local 4 */
#define	FGA_ICRLOCAL5(base)	((char *)((base) + 0x2A0))  /* local 5 */
#define	FGA_ICRLOCAL6(base)	((char *)((base) + 0x2A4))  /* local 6 */
#define	FGA_ICRLOCAL7(base)	((char *)((base) + 0x2A8))  /* local 7 */


    /* control registers */
#define	FGA_CTL1(base)		((char *)((base) + 0x238))  /* arbitration */
#define	FGA_CTL2(base)		((char *)((base) + 0x23C))  /* parity */
#define	FGA_CTL3(base)		((char *)((base) + 0x250))  /* bus width,int */
#define	FGA_CTL5(base)		((char *)((base) + 0x264))  /* mbox vme acc */
#define	FGA_CTL7(base)		((char *)((base) + 0x274))  /* vme timeout */
#define	FGA_CTL8(base)		((char *)((base) + 0x278))  /* arb, acfail */
#define	FGA_CTL9(base)		((char *)((base) + 0x27C))  /* sysReset */
#define	FGA_CTL15(base)		((char *)((base) + 0x358))  /* slave rmw */

#define	FGA_LOCALIACK(base)	((char *)((base) + 0x334))  /* IACK for L5-L8 */

#define	FGA_ENAMCODE(base)	((char *)((base) + 0x2B4))  /* dual port AM */

#define	FGA_MAINUM(base)	((char *)((base) + 0x2C8))  /* A23-A16 LOCAL */
#define	FGA_MAINUU(base)	((char *)((base) + 0x2CC))  /* A31-A24 LOCAL */

#define	FGA_VMEPAGE(base)	((char *)((base) + 0x200))  /* A31-A28 VME */
#define	FGA_BOTTOMPAGEU(base)	((char *)((base) + 0x2D0))  /* A27-A20 VME */
#define	FGA_BOTTOMPAGEL(base)	((char *)((base) + 0x2D4))  /* A19-A12 VME */
#define	FGA_TOPPAGEU(base)	((char *)((base) + 0x2D8))  /* A27-A20 VME */
#define	FGA_TOPPAGEL(base)	((char *)((base) + 0x2DC))  /* A19-A12 VME */

#define	FGA_MYVMEPAGE(base)	((char *)((base) + 0x2FC))  /* A15-A8 VME */

#define	FGA_FMBCTL(base)	((char *)((base) + 0x338))  /* FMB control */
#define	FGA_FMBAREA(base)	((char *)((base) + 0x33C))  /* A31-A24 VME */

#define	FGA_ISABORT(base)	((char *)((base) + 0x4c8))  /* abort status */
#define	FGA_ISACFAIL(base)	((char *)((base) + 0x4cc))  /* acfail status */
#define	FGA_ISSYSFAIL(base)	((char *)((base) + 0x4d0))  /* sysfail status */

#define FGA_MBOX0(base)		((char *)((base) + 0x80000))  /* Mailbox 0 */
#define FGA_MBOX1(base)		((char *)((base) + 0x80004))  /* Mailbox 1 */
#define FGA_MBOX2(base)		((char *)((base) + 0x80008))  /* Mailbox 2 */
#define FGA_MBOX3(base)		((char *)((base) + 0x8000c))  /* Mailbox 3 */
#define FGA_MBOX4(base)		((char *)((base) + 0x80010))  /* Mailbox 4 */
#define FGA_MBOX5(base)		((char *)((base) + 0x80014))  /* Mailbox 5 */
#define FGA_MBOX6(base)		((char *)((base) + 0x80018))  /* Mailbox 6 */
#define FGA_MBOX7(base)		((char *)((base) + 0x8001c))  /* Mailbox 7 */

/* Interrupt Vector Offsets */

#define FGA_INT_MBOX0		0x00
#define FGA_INT_MBOX1		0x01
#define FGA_INT_MBOX2		0x02
#define FGA_INT_MBOX3		0x03
#define FGA_INT_MBOX4		0x04
#define FGA_INT_MBOX5		0x05
#define FGA_INT_MBOX6		0x06
#define FGA_INT_MBOX7		0x07
#define FGA_INT_TIMER		0x20
#define FGA_INT_FMB1REF		0x24
#define FGA_INT_FMB0REF		0x25
#define FGA_INT_FMB1		0x26
#define FGA_INT_FMB0		0x27
#define FGA_INT_ABORT		0x28
#define FGA_INT_ACFAIL		0x29
#define FGA_INT_SYSFAIL		0x2a
#define FGA_INT_DMAERR		0x2b
#define FGA_INT_DMANORM		0x2c
#define FGA_INT_PARITY		0x2d
#define FGA_INT_LOCAL0		0x30
#define FGA_INT_LOCAL1		0x31
#define FGA_INT_LOCAL2		0x32
#define FGA_INT_LOCAL3		0x33
#define FGA_INT_LOCAL4		0x34		/* or external */
#define FGA_INT_LOCAL5		0x35		/* or external */
#define FGA_INT_LOCAL6		0x36		/* or external */
#define FGA_INT_LOCAL7		0x37		/* or external */


/* Register Masks */

    /* ICR */
#define	FGA_ICR_ENABLE		0x8	/* enable interrupt */
#define	FGA_ICR_LEVEL_MASK	0x7	/* interrupt level mask */

    /* following defines are only for extended interrupt control registers */
#define	FGA_ICR_AUTOCLEAR	0x10	/* autoclear interrupt */
#define	FGA_ICR_ACTIVITY	0x20	/* active high = 1 */
#define	FGA_ICR_EDGE		0x40	/* 1 = edge sensitive */

    /* CTL1 */
#define	FGA_CTL1_COPROC_ASYNC	0x0	/* asynchronous */
#define	FGA_CTL1_COPROC_0WAIT	0x1	/* zero wait states */
#define	FGA_CTL1_COPROC_1WAIT	0x2	/* one wait states */
#define	FGA_CTL1_COPROC_2WAIT	0x3	/* two wait states */
#define	FGA_CTL1_SCON		0x4	/* internal arbiter select */
#define	FGA_CTL1_SUPERVISOR	0x8	/* supervisor access only */

    /* CTL2 */
#define	FGA_CTL2_BYTESTROBE	0x1	/* all bytestrobe lines asserted on R */
#define	FGA_CTL2_CSDROPTION	0x2	/* CSDRP active in R/W cycles */
#define	FGA_CTL2_VMERESCALLENA	0x4	/* VME ResetCall enable */
#define	FGA_CTL2_PARITYOUTENA	0x8	/* parity enable */

    /* CTL3 */
#define	FGA_CTL3_VMEBUS16	0x1	/* VME bus 16 bit wide */
#define	FGA_CTL3_VSBENA		0x2	/* VSB bus decoding enable */
#define	FGA_CTL3_VEC_MASK	0xc	/* bit 7,6 of interrupt vec number */

    /* CTL5 */
#define	FGA_CTL5_AUXOPTIONA	0x1	/* AUXOPTIONA enabled */
#define	FGA_CTL5_AUXOPTIONB	0x2	/* AUXOPTIONB enabled */
#define	FGA_CTL5_VME_A16_USER	0x4	/* VME access for mailbox int. */
#define	FGA_CTL5_VME_A16_SUP	0x8	/* VME access for mailbox int. */
#define	FGA_CTL5_VME_A16_BOTH	0xc	/* VME access for mailbox int. */

    /* CTL7 */
#define	FGA_CTL7_RAT_1US	0x1	/* VME release timeout */
#define	FGA_CTL7_RAT_2US	0x2	/* VME release timeout */
#define	FGA_CTL7_RAT_4US	0x3	/* VME release timeout */
#define	FGA_CTL7_RAT_8US	0x4	/* VME release timeout */
#define	FGA_CTL7_RAT_16US	0x5	/* VME release timeout */
#define	FGA_CTL7_RAT_32US	0x6	/* VME release timeout */
#define	FGA_CTL7_RAT_64US	0x7	/* VME release timeout */
#define	FGA_CTL7_NO_RELEASE_ON_BCLR 0x8	/* don't release bus on BCLR* */

    /* CTL 8 */
#define	FGA_CTL8_ACFAIL		0x1	/* ACFAIL handler */
#define	FGA_CTL8_FAIR_ARB	0x2	/* VME bus fair arbitration */
#define	FGA_CTL8_SOFTSYSFAILINIT 0x4	/* Asserts SYSFLTOVME-pin to 0 */
#define	FGA_CTL8_BOOTSYSFAILINIT 0x8	/* INACTIVE */

    /* CTL 9 */
#define	FGA_CTL9_0WAIT		0x1	/* EPROM wait states */
#define	FGA_CTL9_1WAIT		0x2	/* EPROM wait states */
#define	FGA_CTL9_2WAIT		0x3	/* EPROM wait states */
#define	FGA_CTL9_3WAIT		0x4	/* EPROM wait states */
#define	FGA_CTL9_4WAIT		0x5	/* EPROM wait states */
#define	FGA_CTL9_5WAIT		0x6	/* EPROM wait states */
#define	FGA_CTL9_6WAIT		0x7	/* EPROM wait states */
#define	FGA_CTL9_RESET_BUS	0x8	/* SYSRESET propagates to VMEBUS */

    /* CTL 15 */
#define	FGA_CTL15_SHAREDRMW	0x1	/* slave RMW cycles are supported */
#define	FGA_CTL15_CINHLIO	0x2	/* no cache 0xff800000 - 0xfff00000 */
#define	FGA_CTL15_CINH16	0x4	/* no cache 0xfcxxxxxx, 0xfexxxxxx */
#define	FGA_CTL15_CINHOFFBOARD	0x8	/* no cache off board */
#define	FGA_CTL15_BURST_1WAIT	0x10	/* one waitstate burst cycles */
#define	FGA_CTL15_BURST_TWO	0x20	/* two transfers per burst */
#define	FGA_CTL15_VSB_TOUT_DIS	0x60	/* VSB bus error timeout disabled */
#define	FGA_CTL15_VSB_TOUT_16	0x80	/* VSB bus error timeout : 16 us */
#define	FGA_CTL15_VSB_TOUT_1000	0x40	/* VSB bus error timeout : 1000 us */
#define	FGA_CTL15_VSB_TOUT_64000 0x00	/* VSB bus error timeout : 64000 us */

    /* LOCALIACK */
#define FGA_LOCALIACK_INTERNAL	0x00	/* FGA responds with internal vector */
#define FGA_LOCALIACK_NONE	0x01	/* FGA ignores interrupt */
#define FGA_LOCALIACK_EXT_1US	0x02	/* FGA passes ext. vec., 1us response */
#define FGA_LOCALIACK_EXT_500NS	0x03	/* FGA passes ext. vec.,.5us response */
#define FGA_LOCALIACK_LOCAL5	0x03	/* LOCAL 5 MASK */
#define FGA_LOCALIACK_LOCAL6	0x0c	/* LOCAL 6 MASK */
#define FGA_LOCALIACK_LOCAL7	0x30	/* LOCAL 7 MASK */
#define FGA_LOCALIACK_LOCAL8	0xc0	/* LOCAL 8 MASK */

    /* ENAMCODE */
#define	FGA_ENAMCODE_EXTUSRDAT_R	0x2	/* DPR R  access with AM 0x09 */
#define	FGA_ENAMCODE_EXTUSRDAT_RW	0x3	/* DPR RW access with AM 0x09 */
#define	FGA_ENAMCODE_EXTUSRPGM_R	0x8	/* DPR R  access with AM 0x0a */
#define	FGA_ENAMCODE_EXTUSRPGM_RW	0xc	/* DPR RW access with AM 0x0a */
#define	FGA_ENAMCODE_EXTSUPDAT_R	0x20	/* DPR R  access with AM 0x0d */
#define	FGA_ENAMCODE_EXTSUPDAT_RW	0x30	/* DPR RW access with AM 0x0d */
#define	FGA_ENAMCODE_EXTSUPPGM_R	0x80	/* DPR R  access with AM 0x0e */
#define	FGA_ENAMCODE_EXTSUPPGM_RW	0xc0	/* DPR RW access with AM 0x0e */

    /* FMBCTL */
#define	FGA_FMBCTL_SLOT_MASK		0x1f	/* slot # mask */
#define	FGA_FMBCTL_CHANNEL0		0x20	/* channel 0 enabled */
#define	FGA_FMBCTL_CHANNEL1		0x40	/* channel 1 enabled */
#define	FGA_FMBCTL_BOTH			0x80	/* FMB access w/ AM 0x0d/0x09 */

#endif INCfga002h
