/* simpleSprite.c - VxWorks RPC demonstration client */ 

#ifndef	LINT
static char *copyright = "Copyright 1988-1989, Wind River Systems, Inc.";
#endif	LINT

/*
modification history
--------------------
01e,19apr89,gae  used rpc error reporting routines; UNIX version; lint.
01d,07jun88,gae  more name changes.
01c,30may88,dnw  changed to v4 names.
01b,17apr88,gae  made simpleSprite not loop forever, sends final
		   DELETE_SPRITE message, close sockets, destroys client.
01a,10feb88,rdc  written.
*/
 
/*
DESCRIPTION
This is a VxWorks demonstration program that
connects to the RPC server `ramaServer', and calculates
sprite positions to be displayed ultimately on a SUN host.
*/


#include "vxWorks.h"
#include "rpc.h"
#include "rama.h"
#include "in.h"
#include "socket.h"
#include "utime.h"

BOOL spriteLives = TRUE;

#ifdef  UNIX

#include "types.h"
#include "netdb.h"

IMPORT int errno;

char progname [100];
char hostname [100];          /* our host name */

/********************************************************************************
* main -
*/

VOID main (argc, argv)
    int argc;
    char *argv [];

    {
    BOOL send;
    int xvel;
    int yvel;
 
    strncpy (progname, argv [0], sizeof (progname));

    if (argc == 3)                                   
	gethostname (hostname, sizeof (hostname));
    else if (argc == 4)
	strncpy (hostname, argv [1], sizeof (hostname));
    else
        {
        printf ("usage: %s [host] xvel yvel\n", progname);
        return;
        }

    xvel = atoi (argv [argc - 2]);
    yvel = atoi (argv [argc - 1]);

    simpleSprite (hostname, xvel, yvel);
    }
/********************************************************************************
* taskDelay -
*/
 
VOID taskDelay (ticks)
    int ticks;

    {
    int yy;
    int ix;

    for (ix = 0; ix < ticks * 10000; ix++)
        yy += ix;
    }
/********************************************************************************
* hostGetByName - VxWorks compatible function to return inet address as long
*/
 
long hostGetByName (hostname)
    char *hostname;
 
    {
    struct hostent *destHost;

    /* get the internet address for the given host */
 
    if ((destHost = (struct hostent *) gethostbyname (hostname)) == NULL)
        return ((u_long)ERROR);
 
    return (*(u_long *)destHost->h_addr);
    }
/********************************************************************************
* errnoGet - VxWorks compatible function to return errno
*/

int errnoGet ()

    {
    return (errno);
    }
/********************************************************************************
* printErrno - VxWorks compatible function to print errno
*/

int printErrno (no)
    int no;

    {
    printf ("errno = %d\n", (no == 0) ? errno : no);
    }
#endif	UNIX

/*******************************************************************************
*
* simpleSprite - sprite demo task
*
* simpleSprite connects to the RPC server `ramaServer', and calculates
* sprite positions to be displayed ultimately on a SUN host.
*/

VOID simpleSprite (ramaHost, initXVel, initYVel)
    char *ramaHost; 	/* name of vxWorks host on which ramaServer resides */
    int initXVel;	/* initial x velocity */
    int initYVel;	/* initial y velocity */

    {
    /* number of seconds to wait before timing out on rpc call */
    static struct timeval rpcTimeout = { 10, 0 };
    RAMA_REQUEST ramaRequest;
    RAMA_REPLY ramaReply;
    int status;
    int mySpriteId;
    int myXPos;
    int myYPos;
    int myXVelocity;
    int myYVelocity;
    CLIENT *pClient;
    struct sockaddr_in destAddr;
    int sock = -1;

#ifndef	UNIX
    char *progname = "simpleSprite";
    rpcTaskInit ();
#endif	UNIX

    ramaRequest.command = ADD_SPRITE;
    ramaRequest.RAMA_REQUEST_u.addSprite.initialXPos      = 100;
    ramaRequest.RAMA_REQUEST_u.addSprite.initialYPos      = 100;
    ramaRequest.RAMA_REQUEST_u.addSprite.initialXVelocity = initXVel;
    ramaRequest.RAMA_REQUEST_u.addSprite.initialYVelocity = initYVel;

    bzero (&destAddr, sizeof (destAddr));

    destAddr.sin_addr.s_addr = hostGetByName (ramaHost); 
    destAddr.sin_family      = AF_INET; 
    destAddr.sin_port        = 0;

    if (destAddr.sin_addr.s_addr == (u_long)ERROR)
	{
        printf ("%s:non existant host <%s>\n", progname, ramaHost);
	exit (-1);
	}

    /* create a tcp client transport on which to issue calls to rama */

    pClient = clnttcp_create (&destAddr, RAMA, 0, &sock, 512, 512);

    if (pClient == NULL)
	{
	clnt_pcreateerror ("simpleSprite: tcp_create");
	return;
	}

    /* issue the add sprite request */

    status = (int) clnt_call (pClient, 0, xdr_RAMA_REQUEST, &ramaRequest,
			      xdr_RAMA_REPLY, &ramaReply, rpcTimeout);

    if (status != (int) RPC_SUCCESS)
	{
	clnt_perror (pClient, "simpleSprite: clnt_call");
	goto goodbye;
	}
    
    mySpriteId = ramaReply.status;

    myXVelocity = initXVel;
    myYVelocity = initYVel;
    myXPos      = 100;
    myYPos      = 100;

    ramaRequest.command = UPDATE_SPRITE;
    ramaRequest.RAMA_REQUEST_u.updateSprite.spriteId = mySpriteId;

    while (spriteLives)
	{
	taskDelay (1);	/* go to sleep for a clock tick */

	ramaRequest.RAMA_REQUEST_u.updateSprite.newXVelocity = myXVelocity;
	ramaRequest.RAMA_REQUEST_u.updateSprite.newYVelocity = myYVelocity;
	ramaRequest.RAMA_REQUEST_u.updateSprite.newXPos      = myXPos;
	ramaRequest.RAMA_REQUEST_u.updateSprite.newYPos      = myYPos;

	status = (int) clnt_call (pClient, 0, xdr_RAMA_REQUEST, &ramaRequest,
				  xdr_RAMA_REPLY, &ramaReply, rpcTimeout);

	if (status != (int) RPC_SUCCESS)
	    {
	    clnt_perror (pClient, "simpleSprite: clnt_call");
	    goto goodbye;
	    }
    
	myXVelocity = ramaReply.xVelocity;
	myYVelocity = ramaReply.yVelocity;
	myXPos     += myXVelocity;
	myYPos     += myYVelocity;
	}

    /* send death notice */

    ramaRequest.command = DELETE_SPRITE;

    status = (int) clnt_call (pClient, 0, xdr_RAMA_REQUEST, &ramaRequest,
			    xdr_RAMA_REPLY, &ramaReply, rpcTimeout);

    if (status != (int) RPC_SUCCESS)
	{
	clnt_perror (pClient, "simpleSprite: clnt_call");
	}

goodbye:
    clnt_destroy (pClient);
    close (sock);
    }
