/* ramaServer.c - VxWorks RPC demonstration rama server */ 

#ifndef LINT
static char *copyright = "Copyright 1988-1989, Wind River Systems, Inc.";
#endif  LINT

/*
modification history
--------------------
01c,19apr89,gae  used rpc error reporting routines; destroyed xprt; now exits
		 when unable to talk to drawServer; UNIX version; lint.
01b,19apr88,gae  fixed-up.
01a,10feb88,rdc  written.
*/

/*
DESCRIPTION
See README.
*/


#include "vxWorks.h"
#include "lstLib.h"
#include "rpc.h"
#include "sprite.h"
#include "draw.h"
#include "rama.h"

/* local variables */

LOCAL int nextSpriteId = 1;
LOCAL LIST spriteList;
LOCAL int windowHeight;
LOCAL int windowWidth;
LOCAL char *drawServerHost;

/* forward declarations */

int rama ();
LOCAL SPRITE *findSprite ();

#ifdef  UNIX
char progname [100];

/********************************************************************************
* main -
*/
 
VOID main (argc, argv)
    int argc;
    char *argv [];

    {              
    char *hostname [100];

    strncpy (progname, argv[0], sizeof (progname));

    if (argc == 1)
	gethostname (hostname, sizeof (hostname));
    else if (argc == 2)
	strcpy (hostname, argv [1], sizeof (hostname));
    else
	{
	printf ("%s: invalid parameter <%s>\n", progname, argv [argc]);
	exit (-1);
	}

    ramaServer (hostname);
    }
#endif  UNIX

/*******************************************************************************
*
* ramaServer - service sprite update requests
*
* ramaServer keeps track of the position of all active sprites.  When
* a sprite updates its position, ramaServer checks to see if this results
* in a collision with any other sprite, or a wall.  If a collision occurs
* between two sprites, their velocities are swapped.  If a collision occurs
* with a wall, the sprite's velocity in the direction of the wall is 
* negated.
*/

VOID ramaServer (hostName)
    char *hostName; 	/* name of UNIX host on which drawServer resides */

    {
    SVCXPRT *xprt;
    DRAW_UPDATE drawUpdate;
    DRAW_REPLY drawReply;
    int status;

#ifndef	UNIX
    rpcTaskInit (); 
#endif	!UNIX

    drawServerHost = hostName;

    /* initialize the list of active sprites */

    lstInit (&spriteList);

    /* ask the drawServer how big our window is */
    drawUpdate.drawType = DR_GET_WINDOW_SIZE;

    status = callrpc (drawServerHost, DRAWSRVR, 0, 0, xdr_DRAW_UPDATE, 
	     &drawUpdate, xdr_DRAW_REPLY, &drawReply);

    if (status == 0)
	printf ("ramaServer: rpc connected.\n");
    else
	{
	printf ("ramaServer: rpc failed: ");
	clnt_perrno (status);
	printf ("\n");
	return;
	}

    windowHeight = drawReply.height;
    windowWidth = drawReply.width;


    /* create a tcp transport to service sprite update requests */

    if ((xprt = svctcp_create (RPC_ANYSOCK, 0, 0)) == (SVCXPRT *)NULL) 
	{
	clnt_pcreateerror ("udp_create");
	return;
	}

    /* un-register any previous incarnations in the local portmap daemon */

    pmap_unset (RAMA, 0);

    /* register the service with the transport we created */

    status = svc_register (xprt, RAMA, 0, rama, IPPROTO_TCP);

    if (status == FALSE)
	{
	printf ("ramaServer: register failed\n");
	svc_destroy (xprt);
	return;
	}

    svc_run ();
    }
/*******************************************************************************
*
* rama - handle a sprite's update request.
*
* ARGSUSED0
*/

LOCAL VOID rama (rqstp, xprt)
    struct svc_req *rqstp;
    SVCXPRT *xprt;

    {
    FAST SPRITE *pSprite;
    DRAW_UPDATE drawUpdate;
    RAMA_REPLY ramaReply;
    DRAW_REPLY drawReply;
    RAMA_REQUEST ramaRequest;
    int status;

    /* get the request */

    if (!svc_getargs(xprt, xdr_RAMA_REQUEST, &ramaRequest))
	{
	svcerr_decode (xprt);
	printf ("svc_getargs trouble!\n");
	return;
	}

    ramaReply.status = ERROR;

    switch (ramaRequest.command)
	{
	case ADD_SPRITE:
	    pSprite = (SPRITE *) malloc (sizeof (SPRITE));
	    pSprite->spriteId = nextSpriteId++;
	    pSprite->xPos = 
		 ramaRequest.RAMA_REQUEST_u.addSprite.initialXPos;
	    pSprite->yPos = 
		 ramaRequest.RAMA_REQUEST_u.addSprite.initialYPos;
	    pSprite->xVelocity = 
		  ramaRequest.RAMA_REQUEST_u.addSprite.initialXVelocity;
	    pSprite->yVelocity = 
		  ramaRequest.RAMA_REQUEST_u.addSprite.initialYVelocity;
	    pSprite->collided = FALSE;
	    lstAdd (&spriteList, (NODE *) pSprite);

	    ramaReply.status = pSprite->spriteId;

	    /* draw the sprite */
	    drawUpdate.oldx = 0;
	    drawUpdate.oldy = 0;
	    drawUpdate.newx = pSprite->xPos;
	    drawUpdate.newy = pSprite->yPos;
	    drawUpdate.drawType = DR_INITIAL;

	    status = callrpc (drawServerHost, DRAWSRVR, 0, 0, xdr_DRAW_UPDATE, 
	                       &drawUpdate, xdr_DRAW_REPLY, &drawReply);

	    if (status != 0)
		{
		printf ("ramaServer: rpc failed: ");
		clnt_perrno (status);
		printf ("\n");
		goto bad;
		}

	    if (drawReply.height != windowHeight ||
		drawReply.width  != windowWidth)
		{
		windowHeight = drawReply.height;
		windowWidth  = drawReply.width;
		}
	    break;

	case UPDATE_SPRITE:

	    pSprite = 
		findSprite (ramaRequest.RAMA_REQUEST_u.updateSprite.spriteId);

	    if (pSprite == NULL)
		break;

	    /* redraw the sprite */

	    drawUpdate.oldx = pSprite->xPos;
	    drawUpdate.oldy = pSprite->yPos;
	    drawUpdate.newx = ramaRequest.RAMA_REQUEST_u.updateSprite.newXPos;
	    drawUpdate.newy = ramaRequest.RAMA_REQUEST_u.updateSprite.newYPos;
	    drawUpdate.drawType = DR_UPDATE;

	    status = callrpc (drawServerHost, DRAWSRVR, 0, 0, xdr_DRAW_UPDATE, 
	                       &drawUpdate, xdr_DRAW_REPLY, &drawReply);

	    if (status != 0)
		{
		printf ("ramaServer: rpc failed: ");
		clnt_perrno (status);
		printf ("\n");
		goto bad;
		}

	    if (drawReply.height != windowHeight ||
		drawReply.width  != windowWidth)
		{
		windowHeight = drawReply.height;
		windowWidth = drawReply.width;
		}

	    pSprite->xPos = ramaRequest.RAMA_REQUEST_u.updateSprite.newXPos;
	    pSprite->yPos = ramaRequest.RAMA_REQUEST_u.updateSprite.newYPos;

	    /* has someone else collided with us ? */

	    if (pSprite->collided)
		{
		pSprite->collided = FALSE;
		(void) checkForBoundry (pSprite);
		}
	    else
		{
		pSprite->xVelocity = 
		      ramaRequest.RAMA_REQUEST_u.updateSprite.newXVelocity;
		pSprite->yVelocity = 
		      ramaRequest.RAMA_REQUEST_u.updateSprite.newYVelocity;

		/* have we collided with anything ? */
		if (!checkForBoundry (pSprite))
		    (void)checkForCollision (pSprite);
		}

	    ramaReply.status = OK;
	    ramaReply.xVelocity = pSprite->xVelocity;
	    ramaReply.yVelocity = pSprite->yVelocity;
	    break;

	case DELETE_SPRITE:
	    pSprite = 
		findSprite (ramaRequest.RAMA_REQUEST_u.deleteSprite.spriteId);
	    if (pSprite == NULL)
		printf ("ramaServer: no sprite?\n");
	    else
		{
		lstDelete (&spriteList, (NODE *)pSprite);

		drawUpdate.oldx = pSprite->xPos;
		drawUpdate.oldy = pSprite->yPos;
		drawUpdate.drawType = DR_FINAL;

		status = callrpc (drawServerHost, DRAWSRVR, 0, 0,
				    xdr_DRAW_UPDATE, &drawUpdate,
				    xdr_DRAW_REPLY, &drawReply);
		free ((char *)pSprite);
		if (status != 0)
		    {
		    printf ("ramaServer: rpc failed: ");
		    clnt_perrno (status);
		    printf ("\n");
		    goto bad;
		    }
		}
	    break;

	default:
	    printf ("ramaServer: huh?");
	    break;
	}

    if (svc_sendreply (xprt, (xdrproc_t) xdr_RAMA_REPLY, (caddr_t) &ramaReply)) 
	return;

    printf ("ramaServer: couldn't reply to RPC call\n");

bad:

    svc_unregister (RAMA, 0);
    svc_destroy (xprt);

    exit (-1);
    }
/*******************************************************************************
*
* checkForCollision - check for collision with other sprites
*
* RETURNS: TRUE collision, or FALSE no collision
*/

LOCAL BOOL checkForCollision (pMySprite)
    FAST SPRITE *pMySprite;

    {
    FAST SPRITE *pSprite;
    FAST int xVelBuf;
    FAST int yVelBuf;
    int relXVel;
    int relYVel;
    int relXPos;
    int relYPos;

    for (pSprite = (SPRITE *) lstFirst (&spriteList);
	 pSprite != NULL;
	 pSprite = (SPRITE *) lstNext ((NODE *) pSprite))
	{
	if (pMySprite->spriteId == pSprite->spriteId)
	    continue;

	if ((abs (pMySprite->xPos - pSprite->xPos) < SPRITE_SIZE) &&
	    (abs (pMySprite->yPos - pSprite->yPos) < SPRITE_SIZE))
	    {
	    /* collision */

	    /* check to see if our relative velocities are opposite */

	    relXPos = pSprite->xPos - pMySprite->xPos;
	    relXVel = pSprite->xVelocity - pMySprite->xVelocity;
	    relYPos = pSprite->yPos - pMySprite->yPos;
	    relYVel = pSprite->yVelocity - pMySprite->yVelocity;

	    if ((((relXVel > 0) && (relXPos >= 0)) ||
		((relXVel < 0) && (relXPos <= 0))) &&

		(((relYVel > 0) && (relYPos >= 0)) ||
		((relYVel < 0) && (relYPos <= 0))) )
		continue;		/* receding, no collision */

	    /* exchange the sprites' velocities (elastic collision) */

	    xVelBuf = pMySprite->xVelocity;
	    yVelBuf = pMySprite->yVelocity;
	    pMySprite->xVelocity = pSprite->xVelocity;
	    pMySprite->yVelocity = pSprite->yVelocity;
	    pSprite->xVelocity = xVelBuf;
	    pSprite->yVelocity = yVelBuf;

	    /* mark the two sprites as collided */
	    pMySprite->collided = TRUE;
	    pSprite->collided = TRUE;
	    return (TRUE);
	    }
	}

    return (FALSE);
    }
/*******************************************************************************
*
* checkForBoundry - check for collision with a wall 
*
* RETURNS: TRUE hit wall, or FALSE didn't
*/

LOCAL BOOL checkForBoundry (pMySprite)
    FAST SPRITE *pMySprite;

    {
    /* left wall */

    if ((pMySprite->xPos <= 0) && (pMySprite->xVelocity < 0))
	{
	pMySprite->xVelocity = -pMySprite->xVelocity;
	return (TRUE);
	}

    /* right wall */

    if ((pMySprite->xPos >= windowWidth - SPRITE_SIZE) && 
	(pMySprite->xVelocity > 0))
	{
	pMySprite->xVelocity = -pMySprite->xVelocity;
	return (TRUE);
	}

    /* bottom wall */

    if ((pMySprite->yPos >= windowHeight - SPRITE_SIZE) && 
	(pMySprite->yVelocity > 0))
	{
	pMySprite->yVelocity = -pMySprite->yVelocity;
	return (TRUE);
	}

    /* top wall */

    if ((pMySprite->yPos <= 0) && (pMySprite->yVelocity < 0))
	{
	pMySprite->yVelocity = -pMySprite->yVelocity;
	return (TRUE);
	}
    
    return (FALSE);
    }
/****************************************************************************
*
* findSprite - find a sprite in the active sprite list given its sprite id.
*
* RETURNS: sprite, or NULL
*/

LOCAL SPRITE *findSprite (spriteId)
    int spriteId;

    {
    FAST SPRITE *pMySprite;

    for (pMySprite = (SPRITE *) lstFirst (&spriteList);
	 pMySprite != NULL;
	 pMySprite = (SPRITE *) lstNext ((NODE *) pMySprite))
	{
	if (pMySprite->spriteId == spriteId)
	    return (pMySprite);
	}

    return (NULL);
    }
