/* drawServer.c - VxWorks/UNIX RPC demonstration draw server */

#ifndef LINT
static char *copyright = "Copyright 1988-1989, Wind River Systems, Inc.";
#endif  LINT

/*
modification history
--------------------
01e,10may89,gae  checked for macro svc_fds for SunOS3.5 backward compatibility.
01d,14apr89,gae  used new RPC conventions (fd_set's); extra debugging.
		   used rpc error reporting routines; lint.
01c,04jun88,gae  removed alternate sprites (face and box).
01b,12apr88,gae  rewritten to use sunview stuff better.
01a,10feb88,rdc  written.
*/

/*
DESCRIPTION
See README.
*/

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <rpc/rpc.h>
#include <errno.h>
#include <signal.h>
#include "vxWorks.h"
#include "sprite.h"
#include "rama.h"
#include "draw.h"

#ifndef	svc_fds
#define	SUNOS35		/* is SunOS 3.5 */
#endif	svc_fds

LOCAL short icon_image[] = {
#include "draw.icon"
};
DEFINE_ICON_FROM_IMAGE(draw_icon, icon_image);

LOCAL short ball_dat[] = {
#include "ball.pr"
};
mpr_static(ball,     16, 16, 1, ball_dat);


#define	XOR	(PIX_SRC^PIX_DST)

#define draw_sprite(x, y) 	\
    pw_rop(pixwin, x, y, 16, 16, XOR, &ball, 0, 0)


extern int errno;
extern Notify_error notify_dispatch ();


LOCAL Pixwin *pixwin;		/* screen pixwin */
LOCAL Panel_item MainPanel;
LOCAL Panel_item QuitPanel;
LOCAL Pixfont *small_font;

LOCAL int Xsize;
LOCAL int Ysize;
LOCAL BOOL Quit;
LOCAL char progname [100];

/* forward declarations */

LOCAL VOID drawServer ();

LOCAL int winResize ();
LOCAL int winChange ();
LOCAL Notify_value my_notice_destroy ();


/*******************************************************************************
*
* main -
*
* drawServer accepts rpc requests to draw "sprites" in a window.
* RamaServer (running on vxWorks) issues draw requests each
* time a sprite updates its position. 
*
* NOTE: must be invoked from suntools!
*/

main (argc, argv)
    int argc;
    char **argv;

    {
    Canvas MainCanvas;
    Frame frame;

    strncpy (progname, argv [0], sizeof (progname));

    frame = window_create (NULL, FRAME,
			   FRAME_LABEL, argv[0],
			   FRAME_ARGC_PTR_ARGV, &argc, argv,
			   FRAME_ICON, &draw_icon,
			   WIN_ERROR_MSG, "Can't create frame",
			   0);


    /* get width of the frame to scale panel items by */
    Xsize = ((Rect *) window_get (frame, WIN_RECT))->r_width;
    Ysize = ((Rect *) window_get (frame, WIN_RECT))->r_height;


    MainPanel = window_create (frame, PANEL,
				PANEL_LABEL_BOLD, TRUE,
				0);


    QuitPanel = panel_create_item (MainPanel, PANEL_TOGGLE,
				PANEL_LABEL_STRING, "Quit",
				PANEL_CHOICE_STRINGS, "", 0,
				PANEL_NOTIFY_PROC, winChange,
				PANEL_TOGGLE_VALUE, 0, FALSE,
				0);

    window_fit_height (MainPanel); /* squeeze everything together */

    MainCanvas = 
    window_create (frame, CANVAS,
	CANVAS_WIDTH,		Xsize,
	CANVAS_HEIGHT,		Ysize,
	CANVAS_RESIZE_PROC,	winResize,
	WIN_ERROR_MSG, "Can't create canvas",
	0);

    if (MainCanvas == NULL)
	{
	printf ("%s: couldn't create canvas\n", progname);
	exit (0);
	}

    pixwin = canvas_pixwin (MainCanvas);

    if (pixwin == NULL)
	{
	printf ("%s: couldn't create pixwin\n", progname);
	exit (0);
	}


    if (!(small_font = pf_default()))
	{
	perror("can't open default font");
	exit (1);
	}


    (void) notify_interpose_destroy_func (frame, my_notice_destroy);

    /* initialize defaults */

    Quit = FALSE;

    /* initialize graphics */

    window_set (frame, WIN_SHOW, TRUE, 0);

    pw_use_fast_monochrome (pixwin);
    pw_writebackground (pixwin, 0, 0, Xsize, Ysize, (PIX_SRC));

    svc_stuff ();
    }
/*******************************************************************************
*
* svc_stuff - startup rpc service
*/

LOCAL VOID svc_stuff ()

    {
    struct sockaddr_in addr;
    SVCXPRT *xprt;
    bool_t status;

    /* create a udp transport to receive requests */

    if ((xprt = svcudp_create (RPC_ANYSOCK)) == (SVCXPRT *)NULL) 
	{
	printf ("%s: udp_create failed\n", progname);
	exit (1);
	}

    /* un-register any previous incarnations in the local portmap daemon */

    pmap_unset (DRAWSRVR, DRAWSRVRVERS);

    /* register the service with the transport we created */

    status =svc_register(xprt, DRAWSRVR, DRAWSRVRVERS, drawServer, IPPROTO_UDP);

    if (status == FALSE)
	{
	printf ("%s: svc_register failed... %#x\n", progname, errno);
	exit (-1);
	}

    get_myaddress (&addr);
    printf ("%s: host address %#x\n", progname, addr.sin_addr);

    svc_doit ();	/* away we go */

    svc_unregister (DRAWSRVR, DRAWSRVRVERS);
    }
/*******************************************************************************
*
* drawServer - handle rpc requests to draw a sprite
*
* drawServer is the routine registered with rpc to handle incoming
* requests.
*
* ARGSUSED0
*/

LOCAL VOID drawServer (rqstp, xprt)
    struct svc_req *rqstp;
    SVCXPRT *xprt;

    {
    struct sockaddr_in *caller;
    DRAW_UPDATE thisUpdate;
    DRAW_REPLY thisReply;

    caller = svc_getcaller (xprt);

    thisReply.width  = Xsize;
    thisReply.height = Ysize;

    /* get the update request */

    if (!svc_getargs (xprt, xdr_DRAW_UPDATE, &thisUpdate))
	svcerr_decode (xprt);

    else if (thisUpdate.drawType == DR_GET_WINDOW_SIZE)
	{
	/* return the size of the window we're running in */

	if (!svc_sendreply(xprt, (xdrproc_t) xdr_DRAW_REPLY, 
			   (caddr_t) &thisReply)) 
	    {
	    printf ("%s: couldn't reply to RPC call\n", progname);
	    exit (1);
	    }

	printf ("\n%s: client from %#x has connected\n",
		progname, caller->sin_addr);
	}

    else	/* DR_INITIAL, DR_UPDATE, DR_FINAL */
	{
	/* return the size of the window we're running in */

	if (!svc_sendreply(xprt, (xdrproc_t) xdr_DRAW_REPLY, 
			   (caddr_t) &thisReply)) 
	    {
	    printf ("%s: couldn't reply to RPC call\n", progname);
	    exit (1);
	    }

	switch (thisUpdate.drawType)
	    {
	    case DR_FINAL:	/* erase a dead sprite */
	    case DR_INITIAL:	/* draw a new sprite */
		{
		struct sockaddr_in *caller;
		caller = svc_getcaller (xprt);
		printf ("\n%s: client from %#x has %s\n",
			progname, caller->sin_addr,
			thisUpdate.drawType == DR_FINAL ? "left" : "joined");
		}
	    }
	redrawSprite (thisUpdate.drawType,
		      thisUpdate.oldx, thisUpdate.oldy,
		      thisUpdate.newx, thisUpdate.newy);
	}
    }
/*******************************************************************************
*
* redrawSprite - redraw a sprite
*/

LOCAL VOID redrawSprite (drawType, oldx, oldy, newx, newy)
    DRAW_TYPE drawType;
    int oldx;
    int oldy;
    int newx;
    int newy;

    {
    switch (drawType)
	{
	case DR_UPDATE:	/* erase the old sprite, draw a new one */
	    draw_sprite (oldx, oldy);
	    draw_sprite (newx, newy);
	    break;

	case DR_INITIAL:	/* draw a new sprite */
	    draw_sprite (newx, newy);
	    break;

	case DR_FINAL:	/* erase a dead sprite */
	    draw_sprite (oldx, oldy);
	    break;

	default:
	    fprintf (stderr, "%s: huh?\n", progname);
	    break;
	}
    }

/*******************************************************************************
*
* winChange -
*
* ARGSUSED0
*/

LOCAL VOID winChange (item, value, event)
    Panel_item item;
    int value;
    Event *event;

    {
    if (item == QuitPanel)
	Quit = value;
    else
	{
	fprintf (stderr, "%s: winChange???\n", progname);
	pw_vector (pixwin, 0, 0, Xsize, Ysize, PIX_SRC^PIX_DST, 1);
	}
    }
/*******************************************************************************
*
* winResize -
*
* ARGSUSED0
*/

LOCAL VOID winResize (canvas, w, h)
    Canvas canvas;
    int w;
    int h;

    {
    Xsize = w;
    Ysize = h;
    }
/*******************************************************************************
*
* my_notice_destroy -
*/

LOCAL Notify_value my_notice_destroy (frame, status)
    Frame frame;
    Destroy_status status;

    {
    if (status != DESTROY_CHECKING)
	{
	Quit = TRUE;
	fprintf (stderr, "%s: game over!\n", progname);
	(void) notify_stop ();
	}

    return (notify_next_destroy_func (frame, status));
    }

/*******************************************************************************
*
* svc_doit - basically svc_run with timeout to update sunwindow
*
* This is the rpc server side idle loop
* Wait for input, call server program.
*/

VOID svc_doit ()

    {
#ifdef	SUNOS35
extern int svc_fds;
#define	svc_fdset svc_fds
#define	fd_set int
#endif	SUNOS35

    static struct timeval tt = { 0L, 10000L};
    fd_set readFds;
    int nFds;

    while (!Quit)
	{
	(void) notify_dispatch ();	/* any window shit */

	readFds = svc_fdset;

	nFds = select (32, &readFds, (int *)NULL, (int *)NULL,
			(struct timeval *)&tt);

	switch (nFds)
	    {
	    case -1:
		if (errno != EINTR)
		    {
		    perror ("svc_doit: select failed");
		    return;
		    }

	    case 0:
		break;

	    default:
#ifdef	SUNOS35
		svc_getreq (readFds);
#else
		svc_getreqset (&readFds);
#endif	SUNOS35
		break;
	    }
	}
    }
