/* ubar/config.h - Microbar DBC68K2 configuration header */

/*
modification history
--------------------
02b,08jun88,gae  fixed BOOT_LINE_ADRS (ubar non-standard).
		 added INT_VEC_CLOCK1.
02a,29apr88,gae  relocated bulk to configAll.h.
01i,27apr88,ecs  added EXC_MSG_ADRS.
01h,20nov87,dnw  changed definitions to new naming conventions.
01g,05jun87,dnw  removed obsolete MAIL_BOX_SIZE, BP_POLL,
		   LOW_BYTE_{BUS,LOCAL}_ADRS definitions.
		 moved ISR_STACK_SIZE to usrConfig.h.
		 added CPU, BP_INT_TYPE, BP_INT_ARG[123].
		 added trap definitions.
		 added defines for optional floating point support.
01f,26mar87,rdc  additional constants for backplane network driver 
01e,26feb87,rdc  moved ISR_STACK_SIZE from usrConfig.c
01d,14feb87,dnw  added IL_EX, LOW_BYTE_{LOCAL,BUS}_ADRS
01c,20dec86,dnw  changed DEFAULT_BOOT_LINE
01b,04dec86,dnw  added DEFAULT_BOOT_LINE
01a,30nov86,dnw  created
*/

/*
This module contains the parameters that define the configuration
for VxWorks on the Microbar DBC68K2.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "dbc68k.h"

#define CONSOLE_DEVICE	"/tyCo/1"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"ex(0,0)host:/usr/vw/config/ubar/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/* Device controller I/O addresses: only the EXOS 201 ported to MULTIBUS I */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0xef0100)	/* Excelan Ethernet controller*/


/* interrupt vectors */

#define INT_VEC_CLOCK0		68	/* on-board timer, 8259 lvl 4 */
#define INT_VEC_CLOCK1		70	/* on-board timer, 8259 lvl 4 */

#undef	INT_VEC_EX
#define INT_VEC_EX		66	/* Excelan Ethernet controller
					 *  = Multibus int level 2 */

/* Backplane? are you kidding */

#undef	INCLUDE_BP

/* memory addresses */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0		/* jumpers */

#undef	BOOT_LINE_ADRS
#define	BOOT_LINE_ADRS		((char *) 0x400)

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0x00ee8000

#endif	INCconfigh
