/* pic_cpu.c - SUN3/E jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01b,01apr89,gae  labeled jumpers.
01a,05aug88,pht  written.
*/

/*
This module contains the jumpering of the SUN 3/E.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"

#define	J500_RESET	1	/* 0 can be reset by other boards */
#define	J501_IACK	1	/* 0 don't drive IACK daisy chain */

#define	J800_UNUSED	1	/* 0 who cares? */
#define	J800_ARBITER	2	/* 0 if not system controller */
#define	J800_VIDEO	4	/* 0 no video - can leave in */
#define	J800_SLAVE	8	/* 0 if no slave response on low megabyte */

#define	J801_SYSCLK	1	/* 0 don't drive system clock */
#define	J801_UNUSED	2	/* 0 never! */

int J800 = J800_UNUSED | J800_ARBITER | J800_VIDEO | J800_SLAVE;
int J801 = J801_UNUSED | J801_SYSCLK;


/*******************************************************************************
* drawBoard - draw CPU jumper configuration
*
* ARGSUSED1
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    int int_lvl = 0;

    printAt (pic, 35, 1, "SUN 3/E");

    printAt (pic, 3, 14, "-------------");
    printAt (pic, 3, 15, "|  SUN ROM  |");
    printAt (pic, 3, 16, ">           |");
    printAt (pic, 3, 17, "|   U300    |");
    printAt (pic, 3, 18, "-------------");

    /* XXX should test J500 and J501 */
    printAt (pic, 20, 3, "reset J500  . ");
    printAt (pic, 20, 4, "           .X ");
    printAt (pic, 20, 5, " iack J501 X  ");

    /* calculate interrupt levels */
    int_lvl |= inc_ex  ? (0x80 >> il_ex)  : 0;
    int_lvl |= inc_enp ? (0x80 >> il_enp) : 0;
    int_lvl |= inc_ie  ? (0x80 >> il_ie)  : 0;
    int_lvl |= inc_nw  ? (0x80 >> il_nw)  : 0;
    int_lvl |= inc_pn  ? (0x80 >> il_pn)  : 0;

    jumperAt (pic, 36,  3, 7, HORIZONTAL, VERTICAL, int_lvl);
    jumperAt (pic, 44,  3, 2, HORIZONTAL, VERTICAL, J801);
    printAt  (pic, 36, 4, "INT LVL J801 clock");
    printAt  (pic, 36, 5, "J300");

    printAt  (pic, 38, 15, "J800");
    jumperAt (pic, 39, 16, 4, VERTICAL, HORIZONTAL, J800);
    printAt  (pic, 41, 16, "unused");
    printAt  (pic, 41, 17, "arbiter");
    printAt  (pic, 41, 18, "video");
    printAt  (pic, 41, 19, "slave");
    }
