/* mz7122/config.h - Mizar mz7122 and mz7124 configuration header */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
01e,25jul88,gae  updated to 4.0. Fixed Excelan definition. Added !BP_OFF_BOARD.
01d,22jun88,mcl  cleanup and release.
01c,01jun88,mcl  modified to also include mz7124; changes backplane to mailbox.
01b,19may88,mcl  modified for revision ax5 boards.
01a,28jan88,sah  written.
*/

/*
This module contains the parameters that define the configuration for
VxWorks on the Mizar mz7122 and mz7124.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "mz7122.h"


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define	WHICH	0	/* 0=WRS,1=MIZAR,2=MIZARBP,3=MIZARAA */

#if (WHICH == 0)
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mz7122/vxWorks h=90.0.0.3 e=90.0.0.50 u=target"
#endif	WHICH_WRS
#if (WHICH == 1)
#define DEFAULT_BOOT_LINE \
"enp(0,0)mizar:/usr/vw/config/mz7122/vxWorks e=192.33.35.122 h=192.33.35.10 b=122.1 u=vw"
#endif	WHICH_MIZAR
#if (WHICH == 2)
#define DEFAULT_BOOT_LINE \
"bp(0,1)mizar:/usr/vw/config/mz7122/vxWorks b=122.2 g=122.1 h=192.33.35.10 u=vw"
#endif	WHICH_MIZARBP
#if (WHICH == 3)
#define DEFAULT_BOOT_LINE \
"enp(0,0)aaec1:/usr/gray/vw/config/mz7122/vxWorks e=192.9.200.4 h=192.9.200.1 u=mmw"
#endif	WHICH_MIZARAA


#if	FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			/* optional facilities */

#define	INCLUDE_MZ7810			/* support for Mizar daughter card with
					   2 serial/1 parallel port */
#define	INCLUDE_MZ7830			/* support for Mizar daughter card with
					   SCSI interface */

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif


/* Device controller I/O addresses:
 * MZ7122/4 board requires the top bits 0xff000000 to be set.
 * Also, the Excelan cannot appear at 0x00ff0000.
 */

#undef	IO_ADRS_EX
#define	IO_ADRS_EX	((char *) 0xff7f0000)	/* 24A,32D Excelan Ethernet */
#undef	IO_ADRS_ENP
#define	IO_ADRS_ENP	((char *) 0xffde0000)	/* 24A,32D CMC Ethernet */
#undef	IO_ADRS_IE
#define	IO_ADRS_IE	((char *) 0xff300000)	/* 24A,32D Sun Ethernet */
#undef	IO_ADRS_NW
#define	IO_ADRS_NW	((char *) 0xfff80000)	/* 24A,32D ISI Ethernet */
#undef	IO_ADRS_PN
#define	IO_ADRS_PN	((char *) 0xff100000)	/* 24A,32D Proteon ProNet */


/* interrupt and system trap vectors */

#define INT_VEC_MISC		(IV_AUTOVEC_7)
#define INT_VEC_SIRQ		(IV_AUTOVEC_6)
#define INT_VEC_MBOX		(IV_AUTOVEC_5)
#define INT_VEC_DCARD		(IV_AUTOVEC_4)
#define INT_VEC_HBTIMER		(IV_AUTOVEC_3)
#define INT_VEC_SOFT_INT2	(IV_AUTOVEC_2)
#define INT_VEC_SOFT_INT1	(IV_AUTOVEC_1)


/* backplane network parameters */
/*
 * Mailbox addresses for Mizar boards are defined by 8 bits in the bus latch.
 * We set the high order 3 bits to one and use the five low order bits to
 * define the address based on the processor number:
 *
 * processor #:       VME short I/O address:
 *     0                   0x8000
 *     1                   0x8001
 *     2                   0x8002
 *     etc ...
 */

#define	BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0xff800000))	/* off-board anchor adrs */
						/* mz7122/24 does dual port
						 * on-board memory */
						/* note this is in A24 space */
#else
#define	BP_ANCHOR_ADRS	((char *) (0x00000600))	/* on-board anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_2	/* mailbox interrupt:
						 * 16 bit write */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO	/* bus address space */
#define BP_INT_ARG2	(sysMailboxAddressSet())/* define and return
						 * bus address */
#define BP_INT_ARG3	0			/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate from memory pool */
#define BP_MEM_SIZE	0x10000		/* 64K */
#endif	BP_OFF_BOARD

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The mz7122/24 local memory always appears at 0x00000000 locally.
 */

#define LOCAL_MEM_LOCAL_ADRS		MZ_RAM_BASE_ADRS
#define LOCAL_MEM_BUS_ADRS		0x00400000	/* arbitrary */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS			MZ_ROM_BASE_ADRS

#endif	INCconfigh
