/* mv147.h - Motorola MVME-147 CPU board header file */

/*
modification history
--------------------
01c,25jan89,jcf  added lance memory pool defines for frc37 compatibility.
01b,08aug88,gae  cleaned up.
01a,29apr88,dfm	 written using names similar to those
		   in the user's manual for the 147
*/

/*
This file contains I/O addresses and related constants
for the Motorola MVME-147.
*/

#ifndef	INCmv147h
#define	INCmv147h

#include "z8530.h"

#define BUS		VME_BUS
#define CPU		MC68020

#define	TARGET_MV147

#define N_SIO_CHANNELS	4		/* Number of serial I/O channels */

/* Local I/O address map */

#define	BBRAM		((char *) 0xfffe0000)	/* MK48T02 battery backup ram */
#define	BB_ENET		((char *) 0xfffe0778)	/* factory ethernet address */
#define	TOD_CLOCK 	((char *) 0xfffe07f8)	/* MK48T02 bb time of day clk */
#define	PCC_BASE_ADRS	((char *) 0xfffe1000)	/* PCC registers base address */
#define	LANCE_AM7990	((char *) 0xfffe1800)	/* AM7990 LANCE ethernet chip */
#define	VME_CHIP_LCSR	((char *) 0xfffe2000)	/* VMEchip LCSR registers */
#define	PRINTER		((char *) 0xfffe2800)	/* Centronics if data/status */
#define	SERIAL_Z8530_A	((char *) 0xfffe3000)	/* first Z8530 dual uart */
#define	SERIAL_Z8530_B	((char *) 0xfffe3800)	/* second Z8530 dual uart */
#define	SCSI_WD33C93	((char *) 0xfffe4000)	/* WD33C93 SCSI registers */

/* interrupt vector locations */

#define PCC_INT_VEC_BASE	0x40	/* PCC interrupt vector base number */
					/* any multiple of 0x10 */
#define UTIL_INT_VEC_BASE	0x50	/* VMEchip utility interrupt */
					/* vector base number */
					/* any multiple of 0x8 */

#define INT_VEC_Z8530_A		0x80	/* int vec for 1st scc  */
#define INT_VEC_Z8530_B		0x90	/* int vec for 2nd scc  */

/* LANCE defines */

#define LANCE_RAP	((short *)(LANCE_AM7990 + 0x02))
#define LANCE_RDP	((short *)(LANCE_AM7990 + 0x00))
#define LN_POOL_ADRS 		NONE	/* malloc the pool */
#define LN_POOL_SIZE 		NONE	/* pool will be default size */
#define LN_DATA_WIDTH 		NONE	/* all data widths supported */


/* PCC addresses */

#define	SCSI_DMA_TABLE_ADRS	((long *) (PCC_BASE_ADRS + 0x00))
#define	SCSI_PCC_DMA_ADRS	((long *) (PCC_BASE_ADRS + 0x04))
#define	SCSI_DMA_BYTE_COUNT	((long *) (PCC_BASE_ADRS + 0x08))
#define SCSI_DMA_TABLE_FC	((char *) (PCC_BASE_ADRS + 0x25))

#define TIC_1_PRELOAD		((short *)(PCC_BASE_ADRS + 0x10))
#define TIC_2_PRELOAD		((short *)(PCC_BASE_ADRS + 0x14))

#define TIC_1_INT_CTL		((char *) (PCC_BASE_ADRS + 0x18))
#define TIC_1_CSR		((char *) (PCC_BASE_ADRS + 0x19))
#define TIC_2_INT_CTL		((char *) (PCC_BASE_ADRS + 0x1a))
#define TIC_2_CSR		((char *) (PCC_BASE_ADRS + 0x1b))

#define ACFAIL_INT_CTL		((char *) (PCC_BASE_ADRS + 0x1c))
#define WDOG_CSR		((char *) (PCC_BASE_ADRS + 0x1d))
#define BERR_INT_CTL		((char *) (PCC_BASE_ADRS + 0x22))
#define ABORT_INT_CTL		((char *) (PCC_BASE_ADRS + 0x24))

#define PRINTER_INT_CTL		((char *) (PCC_BASE_ADRS + 0x1e))
#define PRINTER_CSR		((char *) (PCC_BASE_ADRS + 0x1f))
#define PRINTER_DATA		((char *) (PRINTER + 0x00))
#define PRINTER_STATUS		((char *) (PRINTER + 0x00))

#define SCSI_DMA_INT_CTL	((char *) (PCC_BASE_ADRS + 0x20))
#define SCSI_DMA_CSR		((char *) (PCC_BASE_ADRS + 0x21))
#define SCSI_INT_CTL		((char *) (PCC_BASE_ADRS + 0x2a))

#define SERIAL_INT_CTL		((char *) (PCC_BASE_ADRS + 0x26))

#define LAN_INT_CTL		((char *) (PCC_BASE_ADRS + 0x28))

#define SOFT_1_INT_CTL		((char *) (PCC_BASE_ADRS + 0x2c))
#define SOFT_2_INT_CTL		((char *) (PCC_BASE_ADRS + 0x2e))

#define GP_CTL			((char *) (PCC_BASE_ADRS + 0x27))
#define GP_STATUS		((char *) (PCC_BASE_ADRS + 0x29))
#define INT_BASE_CTL		((char *) (PCC_BASE_ADRS + 0x2d))
#define SLAVE_BASE_CTL		((char *) (PCC_BASE_ADRS + 0x2b))

#define PCC_REVISION		((char *) (PCC_BASE_ADRS + 0x2f))


/* VMEchip addresses */

#define LCSR_SYS_CONF		((char *) (VME_CHIP_LCSR + 0x01))
#define LCSR_RQST_CONF		((char *) (VME_CHIP_LCSR + 0x03))
#define LCSR_MASTER_CONF	((char *) (VME_CHIP_LCSR + 0x05))
#define LCSR_SLAVE_CONF		((char *) (VME_CHIP_LCSR + 0x07))
#define LCSR_TMO_CONF		((char *) (VME_CHIP_LCSR + 0x09))
#define LCSR_SLAVE_AM		((char *) (VME_CHIP_LCSR + 0x0b))
#define LCSR_MASTER_AM		((char *) (VME_CHIP_LCSR + 0x0d))
#define LCSR_INT_MASK		((char *) (VME_CHIP_LCSR + 0x0f))
#define LCSR_UTIL_INT_MASK	((char *) (VME_CHIP_LCSR + 0x11))
#define LCSR_UTIL_VEC_BASE	((char *) (VME_CHIP_LCSR + 0x13))
#define LCSR_INT_REQ		((char *) (VME_CHIP_LCSR + 0x15))
#define LCSR_INT_STATUS_ID	((char *) (VME_CHIP_LCSR + 0x17))
#define LCSR_BERR_STATUS	((char *) (VME_CHIP_LCSR + 0x19))
#define LCSR_GCSR_BASE_ADRS	((char *) (VME_CHIP_LCSR + 0x1b))

#define GCSR_GLOBAL_0		((char *) (VME_CHIP_LCSR + 0x21))
#define GCSR_GLOBAL_1		((char *) (VME_CHIP_LCSR + 0x23))
#define GCSR_BOARD_ID		((char *) (VME_CHIP_LCSR + 0x25))
#define GCSR_GP_CSR_0		((char *) (VME_CHIP_LCSR + 0x27))
#define GCSR_GP_CSR_1		((char *) (VME_CHIP_LCSR + 0x29))
#define GCSR_GP_CSR_2		((char *) (VME_CHIP_LCSR + 0x2b))
#define GCSR_GP_CSR_3		((char *) (VME_CHIP_LCSR + 0x2d))
#define GCSR_GP_CSR_4		((char *) (VME_CHIP_LCSR + 0x2f))


/* vector number offsets */

#define	PCC_INT_ACFAIL	0x0	/* ACFAIL interrupt at level 7 */
#define	PCC_INT_BERR	0x1	/* BUS ERROR interrupt at level 7 */
#define	PCC_INT_ABORT	0x2	/* ABORT interrupt at level 7 */
#define PCC_INT_SERIAL	0x3	/* PCC generated serial vector here */
#define	PCC_INT_LANCE	0x4	/* LANCE interrupts at programmable levels */
#define	PCC_INT_SCSI	0x5	/* SCSI port interrupts at selectable levels */
#define	PCC_INT_SCSI_DMA0x6	/* SCSI dma interrupts at programmable levels */
#define	PCC_INT_PRINTER	0x7	/* Printer interrupts at programmable levels */
#define	PCC_INT_TIC_1	0x8	/* Tic Timer 1 interrupt at selectable level */
#define	PCC_INT_TIC_2	0x9	/* Tic Timer 2 interrupt at selectable level */
#define	PCC_INT_SOFT_1	0xa	/* Software interrupt 1 at programmable level */
#define	PCC_INT_SOFT_2	0xb	/* Software interrupt 2 at programmable level */

#define VME_INT_WPBERR	0x7	/* Write Posting BERR interrupt at level 7 */
#define VME_INT_SYSFAIL	0x6	/* SYSFAIL interrupt at level 6 */
#define VME_INT_SIGHP	0x5	/* Signal interrupt at "high" level 5 */
#define VME_INT_LM1	0x4	/* Location monitor 1 interrupt at level 4 */
#define VME_INT_IACK	0x3	/* IACKed interrupt at level 3 */
#define VME_INT_LM0	0x2	/* Location monitor 0 interrupt at level 2 */
#define VME_INT_SIGLP	0x1	/* Signal interrupt at "low" level 1 */

#endif	INCmv147h
