/* mv135/config.h - MVME-135 configuration header */

/*
modification history
--------------------
02b,29aug88,gae  added on-board bp constants.
02a,03may88,gae  relocated bulk to configAll.h.
01c,27apr88,ecs  added EXC_MSG_ADRS.
01b,19apr88,llk  includes RPC and DBX.
01a,09feb88,ak   created by modifying 01e of mv134/config.h 
*/

/*
This module contains the parameters that define the configuration for
for the MVME-135 board.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "mv135.h"


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mv135/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/* backplane network parameters */

#define BP_OFF_BOARD    TRUE

#if     BP_OFF_BOARD
#define BP_ANCHOR_ADRS  ((char *) (0x00800000)) /* off-board bp anchor adrs */
#else
#define BP_ANCHOR_ADRS  ((char *) (0x00000600)) /* on-board bp anchor adrs */
#endif  BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_1 	/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO	/* bus address space */
#define BP_INT_ARG2	MPCSR_SIGHP(MPCSR_BUS_ADRS) /* bus adrs */
#define BP_INT_ARG3	((char) 0x80)		/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */
 
#if     BP_OFF_BOARD
#define BP_MEM_ADRS     BP_ANCHOR_ADRS  /* off-board shared mem adrs */
#define BP_MEM_SIZE     0x80000         /* 512k */
#else
#define BP_MEM_ADRS     NONE            /* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE     0x10000         /* 64k */
#endif  BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the MVME-135 local memory address always appears at 0xffe00000 locally;
 * it will also appear at 0 locally if the right bit in CNT5_OPT0 is set.
 * We set that bit in romInit.s and use memory locally at 0.
 * RAM address on the bus is set by dip switches on the front panel.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x0	   /* fixed */
#define LOCAL_MEM_BUS_ADRS  	sysBusAdrs /* initialized in sysHwInit */

/* Base address of the on-board ROM */

#define ROM_BASE_ADRS		0xfff00000

#endif	configh
