/* mv133/config.h - MVME-133/133A/133XT/134 configuration header */

/*
modification history
--------------------
02b,29aug88,gae  added on-board bp constants.
02a,29apr88,gae  relocated bulk to configAll.h.
01i,04apr88,ecs  added EXC_MSG_ADRS.
	   +gae  changed IO_ADRS_NW address from 0xf80000 to 0x7f0000
01h,19apr88,llk  includes RPC and DBX.
01g,11feb88,gae  added MV133XT & MV134 constants.
01f,09dec87,jcf  change rom address to 0xfff00000 for mv133a combatibility
01e,20nov87,dnw  changed definitions to new naming conventions.
01d,11nov87,dnw  changed to include ENP rather than NW controller.
		 added new backplane parameters (BP_ANCHOR, etc).
01c,27oct87,jcf  cleaned up, changed IL_EX to 2
01b,29sep87,jcf  removed obsolete MAIL_BOX_SIZE, BP+POLL definitions.
		 moved ISR_STACK_SIZE to usrConfig.h.
		 added CPU, BP_INT_TYPE, BP_INT_ARG[123].
		 added trap definitions.
		 added defines for optional floating pt. support
01a,06aug87,jcf  created by modifying 01a of dy4/config.h 
*/

/*
This module contains the parameters that define the configuration
for the MVME-133, MVME-133A, MVME-133XT and the MVME-134 boards.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "mv133.h"

#define NV_RAM_SIZE	RTC_RAM_SIZE	/* has 2040 bytes of non-volatile RAM */

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mv133/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/* Device controller I/O addresses:
*  MVME-133 & MVME-133A can't have 0x00800000 bit set
*/

#undef	IO_ADRS_EX	/* alternative address due to memory map */
#define IO_ADRS_EX	((char *) 0x007f0000)	/* 24A,32D Excelan Ethernet */
#undef	IO_ADRS_NW	/* alternative address due to memory map */
#define IO_ADRS_NW	((char *) 0x00780000)	/* 24A,32D ISI Ethernet */


/* interrupt vectors */

#define INT_VEC_CLOCK		(MFP_INT_VECT_NUM + MFP_INT_TIMER_A)


/* backplane network parameters */

#define	BP_OFF_BOARD	TRUE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0x00800000))	/* off-board bp anchor adrs */
#else
#define BP_ANCHOR_ADRS	((char *) (0x00000600))	/* on-board bp anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_NONE		/* no bp interrupt */
#define BP_INT_ARG1	0			/* unused */
#define BP_INT_ARG2	0			/* unused */
#define BP_INT_ARG3	0			/* unused */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x80000		/* 512k */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE	0x10000		/* 64k */
#endif	BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the MVME-133 local memory address always appears at 0 locally;
 * its address on the bus is set by jumpers.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0		/* jumpers */

/* Base address of the on-board rom */
 
#define ROM_BASE_ADRS		0xfff00000

#endif	INCconfigh
