/* ms100/config.h - Matrix MS-CPU100 configuration header */

/*
modification history
--------------------
01b,25may89,gae  added BP_OFF_BOARD; changed BP_INT_TYPE to NONE;
           +dab  removed undef of INCLUDE_BP.
01a,16aug88,dmp  written by modifying v01a of mz7120/config.h
*/

/*
This module contains the parameters that define the configuration
for VxWorks on the Matrix MS-CPU100.
*/

#ifndef    INCconfigh
#define    INCconfigh

#include "configAll.h"
#include "ms100.h"

#undef	INCLUDE_EX	/* no room in bootroms */

#define CONSOLE_DEVICE    "/tyCo/0"    /* initial console device */

#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/ms100/vxWorks h=90.0.0.3 e=90.0.0.50 u=target"
 
/* Device controller I/O addresses: standard */

/* interrupt vectors */

#define INT_VEC_ABORT        (MS_AVEC_7)
#define INT_VEC_BCSR         (MS_AVEC_6)

/* backplane network parameters */

#define BP_OFF_BOARD	TRUE

#if     BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0x00800000))   /* bp anchor adrs */
#else
#define BP_ANCHOR_ADRS	((char *) (0x00000600))   /* bp anchor adrs */
#endif  BP_OFF_BOARD

#define BP_INT_TYPE    BP_INT_NONE	/* poll */
#define BP_INT_ARG1    0		/* none */
#define BP_INT_ARG2    0		/* none */
#define BP_INT_ARG3    0		/* none */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if     BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS  /* bp shared mem adrs */
#define BP_MEM_SIZE	0x80000         /* 512k */
#else
#define BP_MEM_ADRS	NONE            /* NONE = allocate from memory */
#define BP_MEM_SIZE	0x10000         /* 64k */
#endif  BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The MS-CPU100 local memory can appear any where in the 24 bit address space
 * (in on-board ram size increment). It has been setup for 0x0100000 here.
 */

#define LOCAL_MEM_LOCAL_ADRS    0x00000000 
#define LOCAL_MEM_BUS_ADRS      0x00100000 
#define DUAL_PORT_SET_ADRS      0x01            /* number of Mbyte offset */
                                                /* used by sysSetDualPort */
#define ON_BOARD_RAM_SIZE       0x83            /* 81=512k, 83=1Mbyte */
                                                /* used by sysSetDualPort */

/* mailbox constant */

#define MAILBOX_ADRS        ((ULONG *) (LOCAL_MEM_BUS_ADRS + 0x0100))           

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS        0x00f00000

#endif    INCconfigh
