/* sysALib.s - Ironics IV-1624A system dependent assembly language routines */

/*
modification history
--------------------
01k,09sep88,gae  documentation.
01j,12jul88,gae  fixed name to IV-1624A.
01i,18nov87,dnw  changed TRAP_ names.
01h,16nov87,jcf  changed startType parameter to BOOT_WARM_AUTOBOOT
01g,27mar87,dnw  removed is68020 (now in vxALib.s).
		 removed sysMemProbe (now in vxALib.s).
		 removed sysToMonitor (now in sysLib.c).
		 deleted sysIo...(), sysSupCall(), and sysTrap() (obsolete).
		 added sysKernelTrap() & sysVwTrap().
		 added sysInit().
01f,25mar87,jlf  documentation
01e,17feb87,dnw  added is68020 for ISI 3.07 host.
		 changed negative displacements to be of form (-4) instead
		   of (0xfffc) which ISI 3.07 assembler rejects.
		 removed intEnt() & intExit() from sysTrap for new vrtx.
01d,04jan86,rdc  fixed sysIoWB (was doing movel instead of moveb).
01c,21dec86,dnw  changed to not get include files from default directories.
01b,31oct86,dnw  removed unecessary ":w" on short addresses to make it
		   easier to convert to motorola format.
		 removed defines for short names.
		 changed "mov[bwl]" to "move[bwl]" for compatiblity w/Sun as.
01a,26jun86,jlf	 written, by modifying isi 68010, v01g.
*/

/*
DESCRIPTION
This module contains system-dependent routines which must be written
in assembly language.  They perform functions such as locking and
unlocking interrupts, trapping to the ROM monitor, etc.

The first routine in this module is the system start-up code.
It is the first code executed after booting.

This module MUST be the first specified on the "ld" command that is used
to build the system.  sysInit is the entry point for VxWorks.

INTERNAL
Many routines in this module "link" and "unlk" the "c" frame pointer
a6@ although they don't use it in any way!  This is only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.

*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_sysInit	/* start of system code */
	.globl  _sysKernelTrap
	.globl  _sysVwTrap
	.globl  _sysVwTrapRtn

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

/*******************************************************************************
*
* sysInit - start after boot
*
* This is is the system start-up entry point for VxWorks in ram.
* It is the first code executed after booting.
* It disables the interrupts, sets up the stack,
* and jumps to the C routine usrInit (2) in usrConfig (1).
*
* The initial stack is set to grow down from sysInit.
* Note that this initial stack is used only by usrInit,
* then is never used again.
* Memory for the stack needs to be accounted for when determining the load
* address of the system.  THIS IS NOT A CALLABLE ROUTINE.

* sysInit ()

*/

_sysInit:
	movew	#0x3700,sr		/* disable interrupts, turn on M bit */
	movel	#_sysInit,a7		/* set stack to grow down from code */
	movel	#BOOT_WARM_AUTOBOOT,a7@- /* push start type arg */
	jsr	_usrInit		/* never returns - starts up kernel */

/*******************************************************************************
*
* sysKernelTrap - trap to kernel function
*
* NOMANUAL

* sysKernelTrap ()

*/
_sysKernelTrap:
	trap	#TRAP_KERNEL
	rts

/*******************************************************************************
*
* sysVwTrap - trap to VxWorks function
*
* NOMANUAL

* sysVwTrap ()

*/
_sysVwTrap:
	trap	#TRAP_VXWORKS
	rts

/*
 * This routine calls the routine whose address is in a0.  Since the system
 * is now in supervisor state (since we got here from a trap) this can be
 * used to call a routine in supervisor state.
 * THIS IS NOT A C CALLABLE ROUTINE!!
 */

_sysVwTrapRtn:
	jsr	a0@		/* vector to proper routine. */
	rte			/* return from trap */

