/* iv24/config.h - Ironics IV-1624A configuration header */

/*
modification history
--------------------
02g,29may89,gae  removed undef of INCLUDE_EX.
02f,25may89,gae  added BP_OFF_BOARD.
02e,16apr89,gae  fixed define of SYS_CLK_FREQ.
02d,14apr89,del	 Put SYS_CLK_FREQ back, default for 10MHz board.
02c,22jul88,gae  undef'd INCLUDE_EX for boot roms temporarily!
02b,22jul88,gae  fixed name to IV-1624A.  Got rid of SYS_CLK_FREQ.
02a,29apr88,gae  relocated bulk to configAll.h.
01o,27apr88,ecs  added EXC_MSG_ADRS.
01n,19apr88,llk  includes RPC and DBX.
01m,04dec87,dnw  changed backplane parameters to use mailbox interrupts.
01l,20nov87,dnw  changed definitions to new naming conventions.
01k,13nov87,dnw  added new backplane parameters (BP_ANCHOR, etc).
01j,11nov87,dnw  changed to standard format.
01i,05jun87,dnw  removed obsolete MAIL_BOX_SIZE, BP_POLL, LOW_BYTE_LOCAL_ADRS
		   definitions.
		 moved ISR_STACK_SIZE to usrConfig.h.
		 added CPU, BP_INT_TYPE, BP_INT_ARG[123].
		 added trap definitions.
		 added defines for optional floating point support.
01h,08apr87,llk  set excelan interrupt level to 2 (IL_EX).
01g,01apr87,rdc  changed  LOW_BYTE_BUS_ADDRS to 0xd00000.
01f,26mar87,rdc  additional constants for backplane network driver - 
		 mail box interrupts not yet implemented for iv24.
01e,26feb87,rdc  moved ISR_STACK_SIZE from usrConfig.c
01d,14feb87,dnw  added IL_EX, LOW_BYTE_{LOCAL,BUS}_ADRS
01c,10jan87,dnw  changed DEFAULT_BOOT_LINE
01b,09dec86,rdc  corrected for new network.
01a,30nov86,dnw  created
*/

/*
This file contains the parameters that define the configuration
for the Ironics IV-1624A.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "iv1624.h"


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/iv24/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/* Device controller I/O addresses: can't have 0x0080000 bit set */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0x007f0000)	/* 24A,32D Excelan Ethernet */
#undef	IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0x00780000)	/* 24A,32D ISI nw Ethernet */


/* interrupt vectors */

#define INT_VEC_LOCAL_BASE	64	/* local interrupts start at 64 */
#define INT_VEC_CLOCK		(INT_VEC_LOCAL_BASE + INT_TMRIRQ)
#define INT_VEC_MAILBOX		(INT_VEC_LOCAL_BASE + INT_MAILBOXIRQ)


/* backplane network parameters */
#define BP_OFF_BOARD    TRUE

#if     BP_OFF_BOARD
#define BP_ANCHOR_ADRS  ((char *) (0x00800000))   /* bp anchor adrs */
#else
#define BP_ANCHOR_ADRS  ((char *) (0x00000600))   /* bp anchor adrs */
#endif  BP_OFF_BOARD


#define BP_INT_TYPE	BP_INT_MAILBOX_1		/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_STD_SUP_DATA		/* bus address space */
#define BP_INT_ARG2	(0xf8fffe | (sysProcNum << 16))	/* bus adrs */
#define BP_INT_ARG3	0				/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if     BP_OFF_BOARD
#define BP_MEM_ADRS     BP_ANCHOR_ADRS  /* bp shared mem adrs */
#define BP_MEM_SIZE     0x80000         /* 512k */
#else
#define BP_MEM_ADRS     NONE            /* NONE = allocate from memory */
#define BP_MEM_SIZE     0x10000         /* 64k */
#endif  BP_OFF_BOARD

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the iv24 dram memory always appears at 0 locally;
 * it's address on the bus is set by jumpers.
 * NOTE: the adrs jumpers are set differently for each cpu on a single backplane
 *       so that the mailbox addresses (in SRAM) will be different.
 *       The LOCAL_MEM_BUS_ADRS given below is thus only valid for cpu 0.
 *       Ideally there should be an expression that gives the correct answer
 *       for each cpu.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0x00d00000	/* jumpers */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0x00f00000

/* system clock frequency: default is 10, 12MHz board use SYS_CLOCK_FREQ_12 */

#define	SYS_CLK_FREQ		SYS_CLK_FREQ_10

#endif	INCconfigh
