/* is30/config.h - Integrated Solutions VME68k30 configuration header */

/* 
modification history
--------------------
*/

/*
This file contains the parameters that define the configuration
for the Integrated Solutions VME68k30.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "vme68k30.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"nw(0,0)host:/usr/vw/config/is30/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_CDB		/* CDB source debugger */
#define INCLUDE_DEBUG           /* native debugging */
#define INCLUDE_FLOATING_POINT  /* floating point I/O */
/*#define	INCLUDE_FORTRAN		/* NKR run time Fortran library */
#define INCLUDE_MC68881         /* MC68881/2 float point co-processor */
#define INCLUDE_NETWORK         /* network subsystem code */
#define INCLUDE_NET_INIT        /* network subsystem initialization */
#define INCLUDE_NET_SYM_TBL     /* load symbol table from network */
#define INCLUDE_NFS             /* nfs package */
#define INCLUDE_RAMDRV          /* ram disk driver */
#define INCLUDE_RLOGIN          /* remote login */
#define INCLUDE_RPC             /* rpc package */
#define INCLUDE_RT11            /* RT-11 file system */
#define INCLUDE_SHELL           /* interactive c-expression interpreter */
#define INCLUDE_SPY             /* spyLib for task monitoring */
#define INCLUDE_STDIO           /* standard I/O */
#define INCLUDE_TELNET          /* telnet-style remote login */
#define INCLUDE_TIMEX           /* timexLib for exec timing */

/* included hardware support */

#define	INCLUDE_CP		/* include ISI ICP8/16 interface */
#define	INCLUDE_DR		/* include Ikon DR-11W interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define	INCLUDE_SM		/* include Interphase 3200/4200 SMD interface */
#define	INCLUDE_TS		/* include ISI QIC2-X/TC-50 tape interface */
/*#define	INCLUDE_VB		/* include ISI VB driver */


/* EXCLUDED facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_ADA		/* include Ada support */
#define INCLUDE_DBX             /* dbx package */
#define INCLUDE_STANDALONE_SYM_TBL      /* compiled-in symbol table */
#define INCLUDE_STARTUP_SCRIPT  /* execute start-up script */

#define INCLUDE_IE		/* include Sun Ethernet interface*/
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_BP		/* include backplane net interface */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/*
 * Default NFS parameters - constants may be changed here, variables
 * may be changed in usrConfig.c at the point where NFS is included.
 */

#ifdef	INCLUDE_NFS

#define NFS_USER_ID		2001	/* dummy nfs user id */
#define NFS_GROUP_ID		100	/* dummy nfs user group id */

#endif	INCLUDE_NFS

/******************************************************************************/
/*                                                                            */
/*                           BOARD CONFIGURATION                              */
/*                                                                            */
/******************************************************************************/

/* Device controller I/O addresses: only used if the devices are included. */

#define IO_ADRS_EX	((char *) 0x88ff0000)	/* 24A,32D Excelan Ethernet */
#define IO_ADRS_ENP	((char *) 0x88de0000)	/* 24A,32D CMC Ethernet */
#define IO_ADRS_IE	((char *) 0x88300000)	/* 24A,32D Sun 3e Ethernet */
#define IO_ADRS_NW	((char *) 0x88f80000)	/* 24A,32D ISI Ethernet */

/* interrupt vectors */

#define INT_VEC_CONSOLE		IVEC_TO_INUM (IV_AUTOVEC_4)
#define INT_VEC_CLOCK		IVEC_TO_INUM (IV_AUTOVEC_6)
#define INT_NUM_NMI		IVEC_TO_INUM (IV_AUTOVEC_7)
#define INT_VEC_IPI		(108)

/* backplane network parameters */

/* TODO: BP DEFINES ??? */

/* The ISI VME-68k20 can also be used with ISI vb driver */

#define VB_SHARED_MEM	0x00f00000		/* vb backplane shared memory */
#define	VB_SHMEM_SIZE	0x40000		/* default 256k */

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the VME-68k30 local memory always appears at 0 locally and
 * at 0 on the bus when dual ported.
 */

#define LOCAL_MEM_LOCAL_ADRS    0               /* fixed */
#define LOCAL_MEM_BUS_ADRS      0               /* fixed */

/* The following address is the base address of the on-board rom. */

#define ROM_BASE_ADRS           0x54000000

/* VME Address space offsets: CPU-->BUS mapping */

#ifndef VME_SHORTIO
#define	VME_SHORTIO	0x80000000
#define VME_STANDARD	0x88000000	/* 16 bit transfers */
#define	VME_EXTENDED	0x90000000
#define VME_STANDARD_32 0x98000000 	/* 32 bit transfers */
#endif VME_SHORTIO
#define VME_WINDOW_STD	0
#define	VME_WINDOW_EXT	0

/*
* Mailbox interrupt addresses:
* processor #:       vme short i/o address:
*     0                   0xF000
*     1                   0xF200
*     2                   0xF400
*     3                   0xF600
*     4			  0xF800
*     5			  0xFA00
*     6			  0xFC00
*     7			  0xFE00
*/

#endif	INCconfigh
