/* hkv2f/config.h - Heurikon HK68/V20,V2F,V2FA configuration header */

/*
modification history
--------------------
02b,04may89,dnw+rml  minor cleanups
02a,29apr88,gae  relocated bulk to configAll.h.
01r,11apr88,ecs  added EXC_MSG_ADRS.
01q,19apr88,llk  includes RPC and DBX.
01p,14mar88,gae  added NV_RAM_SIZE.
01o,18feb88,dnw  changed default for backplane memory to be on-board.
01n,20nov87,dnw  changed definitions to new naming conventions.
01m,17nov87,dnw  corrected error in Excelan interrupt vector.
01l,13nov87,dnw  added new backplane parameters (BP_ANCHOR, etc).
01k,11nov87,dnw  added INCLUDE_ENP.
01j,01nov87,jcf  cleaned up.  added mailbox support.
01j,13oct87,rdc  took out INCLUDE_RPC.  sheesh.
01i,13oct87,rdc  added INCLUDE_RPC.
01h,05jun87,dnw  removed obsolete MAIL_BOX_SIZE, BP_POLL definitions.
		 moved ISR_STACK_SIZE to usrConfig.h.
		 added CPU, BP_INT_TYPE, BP_INT_ARG[123].
		 added trap definitions.
		 changed local memory to appear at address 0 on bus.
		 added defines for optional floating pt support.
01g,26mar87,rdc  additional constants for backplane network driver 
01f,26feb87,rdc  moved ISR_STACK_SIZE from usrConfig.c
01e,14feb87,dnw  added IL_EX.
		 fixed excelan io adrs to be standard.
01d,10jan87,dnw  changed DEFAULT_BOOT_LINE
01c,08jan87,rdc  changes to use level 2 interrupts for excelan.
01b,04dec86,dnw  added DEFAULT_BOOT_LINE
01a,30nov86,dnw  created
*/

/*
This file contains the parameters that define the configuration
for the Heurikon HK68/V20 family.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "hkv2f.h"

#define	NV_RAM_SIZE	HK_NVRAM_SIZE	/* has 128 bytes of non-volatile RAM */

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/hkv2f/vxWorks h=90.0.0.3 e=90.0.0.50 u=target"


/*
 * Device controller I/O addresses: the HK68/V20 needs bit 0x0100000 set
 */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0x01ff0000)	/* 24A,32D Excelan Ethernet */
#undef	IO_ADRS_ENP
#define IO_ADRS_ENP	((char *) 0x01de0000)	/* 24A,32D CMC Ethernet */
#undef	IO_ADRS_IE
#define IO_ADRS_IE	((char *) 0x01300000)	/* 24A,32D Sun Ethernet */
#undef	IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0x01f80000)	/* 24A,32D ISI Ethernet */
#undef	IO_ADRS_PN
#define IO_ADRS_PN	((char *) 0x01100000)	/* 24A,32D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_CLOCK		(MFP_INT_VECT_NUM + MFP_INT_TIMER_A)
#define INT_VEC_PARITY_ERROR	(MFP_INT_VECT_NUM + PARITY_ERROR_VEC_NUM)

#undef	INT_VEC_EX
#define INT_VEC_EX	(MFP_INT_VECT_NUM + MFP_INT_VME_2)	/* Excelan */

#define INT_VEC_BP	(MFP_INT_VECT_NUM + MFP_INT_MAILBOX)	/* backplane */


/* backplane network parameters */

/*
 * Mailbox addresses for Heurikon boards are defined by 8 bits in the bus latch.
 * We set the high order 3 bits to one and use the five low order bits to
 * define the address based on the processor number:
 *
 * processor #:       VME short I/O address:
 *     0                   0xe000
 *     1                   0xe008
 *     2                   0xe010
 *     etc...
 */

#define BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0x01800000))	/* off-board anchor adrs */
#else
#define BP_ANCHOR_ADRS	((char *) (0x02000600))	/* on-board anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_1		/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO		/* bus address space */
#define BP_INT_ARG2	(0xe000 | (sysProcNum << 3))	/* bus adrs */
#define BP_INT_ARG3	0				/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE	0x10000		/* 64K */
#endif	BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the HK68/V20 local memory always appears at 0x02000000;
 * its address on the bus is set by bits in the BCL, currently always at 0.
 */

#define LOCAL_MEM_LOCAL_ADRS	HK_RAM_BASE_ADRS	/* fixed */
#define LOCAL_MEM_BUS_ADRS	0			/* set in BCL */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		HK_ROM_BASE_ADRS

#endif	INCconfigh
