/* romInit.s - init module for code in rom for Force 37 */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history
--------------------
01a,07dec88,jcf written by modifying v01a of mv147/romInit.s
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in rom */


/***********************************************************************
*
* romInit1 -
*
* enable cache, clear all memory, copy rom to ram, set stack, go to usrInit
* This routine is position independent.  Note that this processor is a
* 68030.  Both instruction and data caches are enabled and also burst mode
* cache filling if supported.
*
* romInit1 ()
*/

romInit1:
	moveb	0xff800c0b,d0	/* PIT port b determines if burst mode ok */
	andb	#0x06,d0	/*  bits 0,1,2 equal to 0x6 or 0x7 is not ok */
	cmpb	#0x06,d0
	beq	romI1A
				/* burst mode supported */
	movel	#0x1919,d0	/* clear and enable data/instruction caches */
	bra	romI1B
romI1A:				/* burst mode not supported */
	movel	#0x0909,d0	/* clear and enable data/instruction caches */
romI1B:
	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	.word	0x4e7b		/* movec ... 			*/
	.word	0x0002		/* .....	d0,cacr 	*/

	/* clear all of memory;
	 * outer loop counter in d2 = 0x3 =
	 *
	 *   1M bytes to clear
	 *   ------------------  - 1
	 *   64K * 4               ^
	 *    ^    ^               |
	 *    |    |               for dbra at end of outer loop
	 *    |    bytes per inner loop
	 *    inner loops per outer loop
	 */

	movel	#0x3,d2			/* outer loop counter */
	movel	#LOCAL_MEM_LOCAL_ADRS,a0 /* get start of local memory */
	clrl	d0			/* value to fill */


fb1:	movel	#0xffff,d1		/* set to fill 64K */
fb2:	movel	d0,a0@+			/* move 4 bytes */
	dbra	d1,fb2			/* inner loop test */
	dbra	d2,fb1			/* outer loop test */


	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop1:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbra	d1,loop1


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	#BOOT_COLD,a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

/***********************************************************************
*
* romInit2 -
*
* same as romInit but doesn't clear memory.
* This routine is position independent.
*
* romInit2 ()
*
*/

romInit2:
	link	a6,#0		/* no unlk necessary; we change stacks */

	moveb	0xff800c0b,d0	/* PIT port b determines if burst mode ok */
	andb	#0x06,d0	/*  bits 0,1,2 equal to 0x6 or 0x7 is not ok */
	cmpb	#0x06,d0
	beq	romI2A
				/* burst mode supported */
	movel	#0x1919,d0	/* clear and enable data/instruction caches */
	bra	romI2B
romI2A:				/* burst mode not supported */
	movel	#0x0909,d0	/* clear and enable data/instruction caches */
romI2B:
	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	.word	0x4e7b		/* movec ... 			*/
	.word	0x0002		/* .....	d0,cacr 	*/

	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop2:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbra	d1,loop2


	/* set stack to grow down from start of code and call system init */

	movel	a6@(0x08),d7		/* put startType in d7 */
	movel	#_romInit,a7		/* set stack to start of code */
	movel	d7,a7@-			/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

