/* pic_cpu.c - Force CPU-37 jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01b,24may89,shl  added names for B20 and B21.
01a,03mar89,jcc  created
*/

/*
This module contains the jumpering of the Force CPU-37.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw CPU jumper config
*/

VOID drawBoard (pic, interactive)
    char *pic;		/* array holding picture */
    int interactive;

    {
    printAt (pic, 35, 1, "CPU-37");

    /* JUMPERS */

    jumperAt (pic, 3, 2, 2, HORIZONTAL, VERTICAL, 0x2);
    jumperAt (pic, 3, 3, 2, VERTICAL, HORIZONTAL, 0x1);
    jumperAt (pic, 3, 5, 2, HORIZONTAL, VERTICAL, 0x3);
    jumperAt (pic, 3, 6, 4, VERTICAL, HORIZONTAL, 0xd);
    printAt (pic, 3, 10, "B22");
    printAt (pic, 5, 4, "*");
    printAt (pic, 5, 21, "* sys controller only");

    jumperAt (pic, 30, 3, 3, HORIZONTAL, VERTICAL, 0x4);
    printAt (pic, 30, 4, "* (B21) SYSCLK");

    jumperAt (pic, 36, 7, 4, HORIZONTAL, VERTICAL, 0x0);
    jumperAt (pic, 40, 7, 2, VERTICAL, HORIZONTAL, 0x3);
    jumperAt (pic, 41, 7, 1, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic, 38, 6, "(B20) EPROM SIZE");

    /* PROMs */

    printAt (pic, 6,  2, ".. ------------- ");
    printAt (pic, 6,  3, "  |     ROM     |");
    printAt (pic, 6,  4, "  >     J103    |");
    printAt (pic, 6,  5, "  |    UPPER    |");
    printAt (pic, 6,  6, ".. ------------- ");

    printAt (pic, 6,  7, ".. ------------- ");
    printAt (pic, 6,  8, "  |     ROM     |");
    printAt (pic, 6,  9, "  >     J101    |");
    printAt (pic, 6, 10, "  |    LOWER    |");
    printAt (pic, 6, 11, ".. ------------- ");
    }
