/* frc37/config.h - Force SYS68K/CPU-37 configuration header */

/*
modification history
--------------------
01a,28nov88,jcf  written.
*/

/*
This file contains the parameters that define the configuration
for VxWorks on the Force SYS68K/CPU-37.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "frc37.h"

#if FALSE	/* Force SYS68K/CPU-37 are shipped w/o batteries */
#define NV_RAM_SIZE		NV_BOOT_LINE_SPACE
#endif

/* reserve 256 bytes in BBRAM for the bootline */

#define NV_BOOT_LINE            ((char *) (FRC37_BBRAM + 0x1000))
#define NV_BOOT_LINE_SPACE      (0x100)         

/*
 * Console Devices       Connector       Device	   Driver
 * --------------        ---------       ------    ------
 * "/tyCo/0"		     #1		 MFP       tyCoDrv.c
 * "/tyDUSCC/0"	             #2		 DUSCC     tyDUSCCDrv.c
 * "/tyDUSCC/1"		     #3		 DUSCC     tyDUSCCDrv.c
 */

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define DEFAULT_BOOT_LINE \
"ln(0,0)host:/usr/vw/config/frc37/vxWorks h=90.3 e=90.66 u=target"

#define INCLUDE_LN		/* include AMD LANCE Ethernet interface */

#undef INCLUDE_EX
#undef INCLUDE_NW


/*
 * Device controller I/O addresses: the CPU-37 needs top bits 0xfc000000 set
 */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0xfc7f0000)	/* 24A,16D Excelan ethernet */

#undef	IO_ADRS_ENP
#define IO_ADRS_ENP	((char *) 0xfcde0000)	/* 24A,16D ENP ethernet */

#undef	IO_ADRS_IE
#define IO_ADRS_IE	((char *) 0xfc300000)	/* 24A,16D Sun Ethernet */

#define IO_ADRS_LN	(FRC37_LANCE_BASE_ADRS) /* on board LANCE Ethernet */ 

#undef  IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0xfcf80000)	/* 24A,16D ISI Ethernet */

#undef	IO_ADRS_PN
#define IO_ADRS_PN	((char *) 0xfc100000)	/* 24A,16D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_AUX_CLOCK   (INT_VEC_DUSCC + DUSCC_INT_B_EXT) /* DUSCC timer */
#define INT_VEC_CLOCK	    INT_VEC_PIT		   	      /*   PIT timer */
#define INT_VEC_LN          INT_VEC_LANCE	 	      /* LANCE ether */
					 
#define INT_LVL_LN          FRC37_LANCE_INT_LVL  /* Local fixed priority */


/* backplane network parameters */

/*
 * The CPU-37 board does not have mailboxes so the backplane driver polls.
 */

#define BP_ANCHOR_ADRS	((char *) 0xfc800000)	/* backplane shared memory */

#define BP_INT_TYPE	BP_INT_NONE		/* backplane polls */
#define BP_INT_ARG1	0
#define BP_INT_ARG2	0
#define BP_INT_ARG3	0

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The CPU-37 local memory is not dual-ported and hence not accessible
 * from the bus.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x0		/* fixed */
#define LOCAL_BUS_MEM_ADRS	NONE		/* not dual ported */

/* The following address is the base address of the on-board rom monitor */

#define ROM_BASE_ADRS		(0xff000000)

#endif	INCconfigh
