/* sysALib.s - Force SYS68K/CPU-31 system dependent assembly routines */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history
--------------------
01a,17jan89,jcf  written by modifying v01a of frc30 version.
*/

/*
DESCRIPTION
This module contains system-dependent routines which must be written
in assembly language.  They perform functions such as locking and
unlocking interrupts, trapping to the ROM monitor, etc.

The first routine in this module is the system start-up code.
It is the first code executed after booting.

This module MUST be the first specified on the "ld" command that is used
to build the system.  sysInit is the entry point for VxWorks.

INTERNAL
Some routines in this module "link" and "unlk" the "c" frame pointer
a6@ although they don't use it in any way!  This is only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_sysInit	/* start of system code */
	.globl  _sysKernelTrap
	.globl  _sysVwTrap
	.globl  _sysVwTrapRtn
	.globl	_sysCacheEnable
	.globl	_sysCacheInhibit

	/* externals */

	.globl	_usrInit	/* system initialization routine */

	.text
	.even

/*******************************************************************************
*
* sysInit - start after boot
*
* This is the system start-up entry point for VxWorks in ram.
* It is the first code executed after booting.
* It disables the interrupts, sets up the stack,
* and jumps to the C routine usrInit (2) in usrConfig (1).
*
* The initial stack is set to grow down from sysInit.
* Note that this initial stack is used only by usrInit,
* then is never used again.
* Memory for the stack needs to be accounted for when determining the load
* address of the system.  THIS IS NOT A CALLABLE ROUTINE.

* sysInit ()		/* THIS IS NOT A CALLABLE ROUTINE *

*/

_sysInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	movel	#_sysInit,a7	/* set stack to grow down from code */
	movel	#BOOT_WARM_AUTOBOOT,a7@- /* push start type arg = WARM_BOOT */
	jsr	_usrInit	/* never returns - starts up kernel */

/*******************************************************************************
*
* sysKernelTrap - trap to kernel function
*
* NOMANUAL

* sysKernelTrap ()

*/
_sysKernelTrap:
	trap	#TRAP_KERNEL
	rts

/*******************************************************************************
*
* sysVwTrap - trap to VxWorks function
*
* NOMANUAL

* sysVwTrap ()

*/
_sysVwTrap:
	trap	#TRAP_VXWORKS
	rts

/*
 * This routine calls the routine whose address is in a0.  Since the system
 * is now in supervisor state (since we got here from a trap) this can be
 * used to call a routine in supervisor state.
 * THIS IS NOT A C CALLABLE ROUTINE!!
 */

_sysVwTrapRtn:
	jsr	a0@		/* vector to proper routine. */
	rte			/* return from trap */

/*******************************************************************************
*
* sysCacheEnable - enable cache memory
*
* Enable or disable the 68030 on-chip caches.
*
* SEE ALSO: "MC68030 32-Bit Microprocessor User's Manual"
*

* VOID sysCacheEnable (enable)
*     BOOL enable;		/* enable if TRUE, otherwise disable *

*/

_sysCacheEnable:

	link	a6,#0
	movel	a6@(0x08),d1	/* put enable in d1 */

	cmpl	#1,d1		/* does enable == TRUE? */
	bne	sce0		/* if not, disable cache */
	moveb	0xff800e0b,d0	/* PIT2 port b determines if burst mode ok */
	andb	#0x06,d0	/*  if bits 0,1,2 = 0x6 or 0x7 its not ok */
	cmpb	#0x06,d0
	beq	sceNB
				/* burst mode supported */
	movel	#0x1919,d0	/* clear and enable data/instruction caches */
	bra	sce1
sceNB:				/* burst mode not supported */
	movel	#0x0909,d0	/* clear and enable data/instruction caches */
	bra	sce1

sce0:	movel	#0,d0		/* disable caches */

	/* Enable or disable the caches by writing to the cache control
	   register.  Since the assemblers differ on the syntax for this one
	   (if they even have it), it's done with two .word's.  Yucko. */

sce1:
	.word 0x4e7b,0x0002	/* movec d0,cacr */

	unlk	a6
	rts

/*******************************************************************************
*
* sysCacheInhibit - inhibit regions of cacheing
*
* SEE ALSO: "MC68030 32-Bit Microprocessor User's Manual"
*

* VOID sysCacheInhibit ()

*/

_sysCacheInhibit:

	link	a6,#0

	/* Disable the caches for the VME-range 0x01000000 - 0xffffffff by
	 * setting TT0 of on-chip MMU.  Since the assemblers differ on the
	 * syntax for this one (if they even have it), it's done with
	 * two .word's.
	 */

	movel	#LOCAL_MEM_LOCAL_ADRS,a0 /* get start of local memory */
	movel	#0x01fe8514,a0@		 /* store magic TT0 MMU register */
	.word	0xf010			 /* pmove ... 			*/
	.word	0x0800			 /* .....	a0@,TT0  	*/

	unlk	a6
	rts
