/* frc31.h - Force SYS68K/CPU-31 CPU board header file */

/*
modification history
--------------------
01a,17jan89,jcf  written.
*/

/*
This file contains I/O address and related constants for
VxWorks on the SYS68K/CPU-31.
*/

#ifndef	INCfrc31h
#define	INCfrc31h

#include "s62421.h"
#include "m68230.h"
#include "fga002.h"

#define DUSCC_REG_ADDR_INTERVAL	  1  /* address diff of adjacent regs. */
#include "m68562_new.h"

#define	TARGET_FRC_31

#define BUS		VME_BUS
#define CPU		MC68020

/* interrupt vectors */

#define INT_VEC_FGA	0x40	/* FGA base vector may also be 0x80 or 0xc0 */

#define INT_VEC_RTC	INT_VEC_FGA + FGA_INT_LOCAL0	/* RTC */
#define INT_VEC_FDC	INT_VEC_FGA + FGA_INT_LOCAL1	/* FDC */
#define INT_VEC_PIT1	INT_VEC_FGA + FGA_INT_LOCAL2	/* PIT1 interrupt */
#define INT_VEC_PIT2	INT_VEC_FGA + FGA_INT_LOCAL3	/* PIT2 interrupt */
#define INT_VEC_DUSCC1	0x80	  /* DUSCC1 - LOCAL4 may be external */
#define INT_VEC_ABORT	INT_VEC_FGA + FGA_INT_ABORT	/* ABORT */
#define INT_VEC_ACFAIL	INT_VEC_FGA + FGA_INT_ACFAIL	/* ACFAIL */
#define INT_VEC_SYSFAIL	INT_VEC_FGA + FGA_INT_SYSFAIL	/* SYSFAIL */
#define INT_VEC_MBOX	INT_VEC_FGA + FGA_INT_MBOX0	/* mailbox */

/* interrupt levels */

#define INT_LVL_RTC		1	/* RTC real time clock */
#define INT_LVL_FDC		2	/* FDC floppy disc controller */
#define INT_LVL_PIT1		5	/* PIT1 interrupt */
#define INT_LVL_PIT2		5	/* PIT2 interrupt */
#define INT_LVL_DUSCC1		4	/* DUSCC1 - LOCAL5 may be external */
#define INT_LVL_ABORT		7	/* ABORT */
#define INT_LVL_ACFAIL		7	/* ACFAIL */
#define INT_LVL_SYSFAIL		7	/* SYSFAIL */
#define INT_LVL_MBOX		6	/* Mailbox interrupts */
#define INT_LVL_DMA		3	/* DMA interrupts */
#define INT_LVL_FGA_TIMER	2	/* FGA timer interrupts */
#define INT_LVL_PARITY		3	/* Parity Error interrupts */

/* Local I/O addresses */

#define	FRC31_FGA_BASE_ADRS	((char *) 0xffd00000) /* FGA-002 */
#define	FRC31_PIT1_BASE_ADRS	((char *) 0xff800c00) /* m68230 PI/T */
#define	FRC31_PIT2_BASE_ADRS	((char *) 0xff800e00) /* m68230 PI/T */
#define	FRC31_DUSCC1_BASE_ADRS	((char *) 0xff802000) /* m68562 DUSCC */
#define	FRC31_RTC_BASE_ADRS	((char *) 0xff803000) /* s62421 tod clock */
#define	FRC31_FDC_BASE_ADRS	((char *) 0xff803800) /* wd1772 disk controler*/
#define	FRC31_BBRAM		((char *) 0xffc00000) /* battery backed up ram*/



/* PIT Port B defines */

    /* memory size mask */
#define MEM_SIZE_MASK	0x7
#define MEM_SIZE_4M_NB	0x7	/* Memory does not support nibble mode */
#define MEM_SIZE_1M_NB	0x6	/* Memory does not support nibble mode */
#define MEM_SIZE_1M	0x5
#define MEM_SIZE_2M	0x4
#define MEM_SIZE_4M	0x3
#define MEM_SIZE_8M	0x2
#define MEM_SIZE_16M	0x1
#define MEM_SIZE_32M 	0x0

	/* board id mask */
#define BOARD_ID_MASK	0xf8

/* Miscellaneous */
#define CLOCK_FREQ		8064000 	/* freq of PI/T clock input */
#define AUX_CLOCK_FREQ		3686400		/* freq of DUSCC clock input */

#endif	INCfrc31h
