/* frc30.h - Force SYS68K/CPU-30 CPU board header file */

/*
modification history
--------------------
01a,28nov88,jcf  written.
*/

/*
This file contains I/O address and related constants for
VxWorks on the SYS68K/CPU-30.
*/

#ifndef	INCfrc30h
#define	INCfrc30h

#include "s62421.h"
#include "m68230.h"
#include "fga002.h"

#define DUSCC_REG_ADDR_INTERVAL	  1  /* address diff of adjacent regs. */
#include "m68562_new.h"

#define	TARGET_FRC_30

#define BUS		VME_BUS
#define CPU		MC68020

/* interrupt vectors */

#define INT_VEC_FGA	0x40	/* FGA base vector may also be 0x80 or 0xc0 */

#define INT_VEC_RTC	INT_VEC_FGA + FGA_INT_LOCAL0	/* RTC */
#define INT_VEC_FDC	INT_VEC_FGA + FGA_INT_LOCAL1	/* FDC */
#define INT_VEC_PIT1	INT_VEC_FGA + FGA_INT_LOCAL2	/* PIT1 interrupt */
#define INT_VEC_PIT2	INT_VEC_FGA + FGA_INT_LOCAL3	/* PIT2 interrupt */
#define INT_VEC_DUSCC1	0x80	  /* DUSCC1 - LOCAL4 may be external */
#define INT_VEC_DUSCC2	0x88 	  /* DUSCC2 - LOCAL5 may be external */
#define INT_VEC_LANCE	INT_VEC_FGA + FGA_INT_LOCAL6	/* LANCE */
#define INT_VEC_SCSI	INT_VEC_FGA + FGA_INT_LOCAL7	/* SCSI */
#define INT_VEC_ABORT	INT_VEC_FGA + FGA_INT_ABORT	/* ABORT */
#define INT_VEC_ACFAIL	INT_VEC_FGA + FGA_INT_ACFAIL	/* ACFAIL */
#define INT_VEC_SYSFAIL	INT_VEC_FGA + FGA_INT_SYSFAIL	/* SYSFAIL */
#define INT_VEC_MBOX	INT_VEC_FGA + FGA_INT_MBOX0	/* mailbox */

/* interrupt levels */

#define INT_LVL_RTC		1	/* RTC real time clock */
#define INT_LVL_FDC		2	/* FDC floppy disc controller */
#define INT_LVL_PIT1		5	/* PIT1 interrupt */
#define INT_LVL_PIT2		5	/* PIT2 interrupt */
#define INT_LVL_DUSCC1		4	/* DUSCC1 - LOCAL4 may be external */
#define INT_LVL_DUSCC2		4	/* DUSCC2 - LOCAL5 may be external */
#define INT_LVL_LANCE		3	/* LANCE ethernet */
#define INT_LVL_SCSI		2	/* SCSI */
#define INT_LVL_ABORT		7	/* ABORT */
#define INT_LVL_ACFAIL		7	/* ACFAIL */
#define INT_LVL_SYSFAIL		7	/* SYSFAIL */
#define INT_LVL_MBOX		6	/* Mailbox interrupts */
#define INT_LVL_DMA		3	/* DMA interrupts */
#define INT_LVL_FGA_TIMER	2	/* FGA timer interrupts */
#define INT_LVL_PARITY		3	/* Parity Error interrupts */

/* LANCE defines */

#define FRC30_LANCE_INT_LVL	INT_LVL_LANCE
#define LN_POOL_ADRS 		((char *) 0xfef00000)	/* dedicated ln pool */
#define LN_POOL_SIZE 		((ULONG)  0x10000)	/* size of memory pool*/
#define LN_DATA_WIDTH 		2		/* word access only */

/* Local I/O addresses */

#define	FRC30_FGA_BASE_ADRS	((char *) 0xffd00000) /* FGA-002 */
#define	FRC30_PIT1_BASE_ADRS	((char *) 0xff800c00) /* m68230 PI/T */
#define	FRC30_PIT2_BASE_ADRS	((char *) 0xff800e00) /* m68230 PI/T */
#define	FRC30_DUSCC1_BASE_ADRS	((char *) 0xff802000) /* m68562 DUSCC */
#define	FRC30_DUSCC2_BASE_ADRS	((char *) 0xff802200) /* m68562 DUSCC */
#define	FRC30_RTC_BASE_ADRS	((char *) 0xff803000) /* s62421 tod clock */
#define	FRC30_SCSI_BASE_ADRS	((char *) 0xff803400) /* 87031 SCSI */
#define	FRC30_FDC_BASE_ADRS	((char *) 0xff803800) /* wd1772 disk controler*/
#define	FRC30_LANCE_BASE_ADRS	((char *) 0xfef80000) /* Am7990 LANCE */
#define	FRC30_BBRAM		((char *) 0xffc00000) /* battery backed up ram*/



/* PIT Memory Size Defines */

    /* memory size mask */
#define MEM_SIZE_MASK	0x7
#define MEM_SIZE_4M_NB	0x7	/* Memory does not support nibble mode */
#define MEM_SIZE_1M_NB	0x6	/* Memory does not support nibble mode */
#define MEM_SIZE_1M	0x5
#define MEM_SIZE_2M	0x4
#define MEM_SIZE_4M	0x3
#define MEM_SIZE_8M	0x2
#define MEM_SIZE_16M	0x1
#define MEM_SIZE_32M 	0x0

	/* board id mask */
#define BOARD_ID_MASK	0xf8

/* Miscellaneous */
#define CLOCK_FREQ		8064000 	/* freq of PI/T clock input */
#define AUX_CLOCK_FREQ		3686400		/* freq of DUSCC clock input */

#endif	INCfrc30h
