/* frc30/config.h - Force SYS68K/CPU-30 configuration header */

/*
modification history
--------------------
01a,14feb89,jcf  written.
*/

/*
This file contains the parameters that define the configuration
for VxWorks on the Force SYS68K/CPU-30.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "frc30.h"


/* reserve 256 bytes in BBRAM for the bootline */

#define NV_BOOT_LINE            ((char *) (FRC30_BBRAM + 0x1000))
#define NV_BOOT_LINE_SPACE      (0x100)         
#define NV_RAM_SIZE		NV_BOOT_LINE_SPACE

/*
 * Console Devices       Connector       Device	   Driver
 * --------------        ---------       ------    ------
 * "/tyCo/0"	           VME-P2	 DUSCC1    tyCoDrv.c
 * "/tyCo/1"		     #1		 DUSCC1    tyCoDrv.c
 * "/tyCo/2"		     #2		 DUSSC2    tyCoDrv.c
 * "/tyCo/3"		     #3		 DUSSC2    tyCoDrv.c
 */

#define CONSOLE_DEVICE	"/tyCo/1"	/* initial console device */

#define DEFAULT_BOOT_LINE \
"ln(0,0)host:/usr/vw/config/frc30/vxWorks h=90.0.0.3 e=90.0.0.66 u=target"

#define INCLUDE_LN	/* include AMD LANCE Ethernet interface */

#undef INCLUDE_EX

/*
 * Device controller I/O addresses: the CPU-30 needs top bits 0xfc000000 set
 */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0xfc7f0000)	/* 24A,16D Excelan ethernet */

#undef	IO_ADRS_ENP
#define IO_ADRS_ENP	((char *) 0xfcde0000)	/* 24A,16D ENP ethernet */

#undef	IO_ADRS_IE
#define IO_ADRS_IE	((char *) 0xfc300000)	/* 24A,16D Sun Ethernet */

#define IO_ADRS_LN	(FRC30_LANCE_BASE_ADRS) /* on board LANCE Ethernet */ 

#undef  IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0xfcf80000)	/* 24A,16D ISI Ethernet */

#undef	IO_ADRS_PN
#define IO_ADRS_PN	((char *) 0xfc100000)	/* 24A,16D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_AUX_CLOCK   (INT_VEC_DUSCC1 + DUSCC_INT_B_EXT) /* DUSCC timer */
#define INT_VEC_CLOCK	    INT_VEC_PIT1	   	       /*   PIT timer */

#define INT_VEC_LN          INT_VEC_LANCE	 	       /* LANCE ether */
#define INT_LVL_LN          FRC30_LANCE_INT_LVL

#define INT_VEC_BP	    INT_VEC_MBOX	 	       /* mailbox */


/* backplane network parameters */

/*
 * Mailbox addresses for the Force-30 are defined by the selected VME address
 * for the FGA chip.  The #define of FRC30_FGA_VME_ADRS is the VME location
 * of the first mailbox.  This definition depends on which processor number
 * you are.
 */

#define FRC30_FGA_VME_ADRS (0x8000 + (sysProcNum << 8)) /* A16 bus adrs */

#define BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) 0xfb800000)	/* off-board anchor adrs */
#else
#define BP_ANCHOR_ADRS	((char *) 0x600)	/* on-board anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_R1		/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO		/* bus address space */
#define BP_INT_ARG2	(FRC30_FGA_VME_ADRS + 2)	/* bus adrs */
#define BP_INT_ARG3	0			        /* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE	0x10000		/* 64K */
#endif	BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The CPU-30 dual port memory address is under software control and may be
 * changed here.  Only the memory of processor number zero will be dual ported.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x0
#define LOCAL_MEM_BUS_ADRS      (0x1000000)	/* only for processor 0 */

/* The following address is the base address of the on-board rom monitor */

#define ROM_BASE_ADRS		(0xff000000)

#endif	INCconfigh
