/* romInit.s - Force SYS68K/CPU-21/9 ROM initialization module */

/*
modification history
--------------------
01d,18apr89,dnw  fixed long word boundary problem of SunOS 4.0 link editor.
	   +shl  added #ifdef SUN_OS_4.0.
01c,28mar89,gae  changed jeq to beq;
		 added some data after _sdata label for HP/UX.
01b,06jun88,gae  updated to Terry Arden's combined version.
	   +tja  initialized for cpu21 or cpu29.
01a,09mar88,rdc  written by modifying v01c of mv133/romInit.s
*/

/* #define SUN_OS_4.0 */	/* for customer running SunOs 4.O only */

#define ASMLANGUAGE

#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */
	.globl  _sdata		/* start of data segment in ram */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.data
_sdata:				/* symbol for start of data segment in ram */

	.asciz "start of data"

	.text
	.even


/*******************************************************************************
*
* romInit - initial entry points
*
* Cold start starts at romInit which will go to romInit1.
* Warm start starts at romInit + 28 which will go to romInit2.

* NO MANUAL

*/

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	moveb	0xff800c0a,d0	/* read front-panel switches */
	btst	#7,d0		/* cpu20/1 or cpu29 ? */
	beq	romInit1	/* automatic mapping done on cpu29 */
	moveb	#0,0xff800400	/* magic address to remap EPROM area 1 */
	jmp	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	moveb	0xff800c0a,d0	/* read front-panel switches */
	btst	#7,d0		/* cpu20/1 or cpu29 ? */
	beq	romInit2	/* automatic mapping done on cpu29 */
	moveb	#0,0xff800400	/* magic address to remap EPROM area 1 */
	jmp	romInit2	/* subsequent starts in rom */

/*******************************************************************************
*
* romInit1 - cold start initialization
*
* This code is the cold start initialization. It enables the cache,
* copies the data segment from rom to ram, sets the stack to grow
* down from the start of the data segment in ram, and goes to usrInit with
* the arg BOOT_COLD.
*
* This routine is position independent.

* romInit1 ()

*/

romInit1:
	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	movel	#0x09,d0		/* clear and enable cache */
	.word	0x4e7b,0x0002		/* movec d0,cacr */
	
	/* copy the data segment to RAM */

#ifdef SUN_OS_4.0			/* for SunOs 4.0 */
	movel   #_sdata,a0              /* where data segment should go */
	movel   #_etext,d0              /* beginning of data in ROM */
	addl    #7,d0                   /* round off _etext address */
	andl    #0xfffffff8,d0
	movel   d0,a1
	movel   #_edata,d0              /* calculate total data seg length */
	subl    #_sdata,d0
#else					/* for SunOs 3.5 */
	movel	#_sdata,a0		/* where data segment should go */
	movel	#_etext,a1		/* beginning of data in ROM */
	movel	#_edata,d0		/* calculate total data seg length */
	subl	#_sdata,d0
#endif SUN_OS_4.0

loop1:
	moveb	a1@+, a0@+
	dbf	d0, loop1

	/* set stack to grow down from start of data, call system init */

	movel	#_sdata,a7		/* set up stack */
	movel	#BOOT_COLD,a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

/*******************************************************************************
*
* romInit2 - warm start initialization
*
* This code is the warm start initialization. It enables the cache,
* copies the data segment from rom to ram, sets the stack to grow
* down from the start of the data segment in ram, and goes to usrInit with
* the arg that was passed to it.
*
* This routine is position independent.

* romInit2 ()

*/

romInit2:
	link	a6,#0		/* no unlk necessary; we change stacks */

	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	movel	#0x09,d0	/* clear and enable cache */
	.word	0x4e7b,0x0002	/* movec d0,cacr */

	/* copy the data segment to RAM */

#ifdef SUN_OS_4.0			/* for SunOs 4.0 */
	movel   #_sdata,a0		/* where data segment should go */
	movel   #_etext,d0              /* beginning of data in ROM */
	addl    #7,d0                   /* round off _etext address */
	andl    #0xfffffff8,d0
	movel   d0,a1
	movel   #_edata,d0              /* calculate total data seg length */
	subl    #_sdata,d0
#else					/* for SunOs 3.5 */
	movel	#_sdata,a0		/* where data segment should go */
	movel	#_etext,a1		/* beginning of data in ROM */
	movel	#_edata,d0		/* calculate total data seg length */
	subl	#_sdata,d0
#endif SUN_OS_4.0

loop3:
	moveb	a1@+, a0@+
	dbf	d0, loop3


	/* set stack to grow down from start of data and call system init */

	movel	#_sdata,a7		/* set up stack */
	movel	a6@(0x08),a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */
