/* pic_cpu.c - Force SYS68K/CPU-21/9 jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01f,24may89,shl  fixed jumpering info for eprom size.
01e,28feb89,shl  added jumpering info for fast eprom.
01d,02aug88,gae  included frc32 differences.
01b,27jul88,gae  fixed interrupt levels in frc29
01b,22jul88,gae  added frc29.
01a,22mar88,dnw  created
*/

/*
This module contains the jumpering of the Force SYS68K/CPU-21/9.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include <stdio.h>

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    char input[90];
    int n = NONE;

    if (interactive)
	{
	printf ("Which CPU (0=FRC21, 1=FRC29) ?");

	if (gets (input) == NULL)
	    return;

	sscanf (input, "%d", &n);

	switch (n)
	    {
	    case 0:
		drawFrc21 (pic);
		break;
	    case 1:
		drawFrc29 (pic);
		break;

	    default:
		return;
	    }
	}
    else
	{
	/* XXX really need to draw them all */
	drawFrc29 (pic);
	}
    }
/*******************************************************************************
*
* drawFrc21 - draw cpu jumper config
*/

VOID drawFrc21 (pic)
    char *pic;

    {
    int int_lvl = 0;

    printAt (pic, 35, 1, "FORCE 21");

    /* Draw PROMS */

    printAt (pic, 45,  7, " _____   _____   _____   _____ ");
    printAt (pic, 45,  8, "|  3  | |  1  | |  2  | |  0  |");
    printAt (pic, 45,  9, "| L/L | |  U  | |  L  | | U/U |");
    printAt (pic, 45, 10, "| ROM | | ROM | | ROM | | ROM |");
    printAt (pic, 45, 11, "|     | |     | |     | |     |");
    printAt (pic, 45, 12, "|__^__| |__^__| |__^__| |__^__|");

    /* Prom size = 27512 */

    jumperAt (pic, 75, 4, 3, VERTICAL, HORIZONTAL_3, 0);
    printAt (pic, 65, 4, "ROM=27512");
    printAt (pic, 65, 5, "     (B7)");

    /* interrupt enables */

    int_lvl |= (inc_ex)  ? (1 << (il_ex - 1))  : 0;
    int_lvl |= (inc_enp) ? (1 << (il_enp - 1)) : 0;
    int_lvl |= (inc_ie)  ? (1 << (il_ie - 1))  : 0;
    int_lvl |= (inc_nw)  ? (1 << (il_nw - 1))  : 0;
    int_lvl |= (inc_pn)  ? (1 << (il_pn - 1))  : 0;

    jumperAt (pic, 28, 3, 7, VERTICAL, HORIZONTAL, int_lvl);
    printAt (pic, 25, 10, "INT LVL");
    printAt (pic, 25, 11, " (B11)");

    /* system controller */

    jumperAt (pic, 8, 2, 1, VERTICAL, VERTICAL, 1);
    printAt (pic, 5, 3, "SYS CTL");
    printAt (pic, 5, 4, " (B21)");

    /* dip switch (frc21: bit 7 = on) */

    printAt (pic,  43, 20, "SW1 ON");
    printAt (pic,  43, 22, "DXXXXXXX");
    }
/*******************************************************************************
*
* drawFrc29 - draw cpu jumper config for 29 or 32
*/

VOID drawFrc29 (pic)
    char *pic;

    {
    int int_lvl = 0;

    printAt (pic, 34, 1, "FORCE 29/32");

    /* Draw PROMS */

    printAt (pic, 11,  3, "_ _________  _ _________ ");
    printAt (pic, 11,  4, " |  L/L J21|  |   U  J25|");
    printAt (pic, 11,  5, " >  ROM    |  >  ROM    |");
    printAt (pic, 11,  6, " |   3     |  |   1     |");
    printAt (pic, 11,  7, "= =========  = ========= ");
    printAt (pic, 11,  8, " |   L  J23|  |  U/U J27|");
    printAt (pic, 11,  9, " >  ROM    |  >  ROM    |");
    printAt (pic, 11, 10, " |   2     |  |   0     |");
    printAt (pic, 11, 11, "- ---------  - --------- ");

    /* PROM size = 27512 */

    jumperAt (pic, 12, 13, 8, HORIZONTAL, VERTICAL, 0xe1);
    printAt (pic,  21, 13, "CPU-29/32 - ROM=27512 (B7)");

    /* interrupt enables */

    int_lvl |= (inc_ex)  ? (0x80 >> il_ex)  : 0;
    int_lvl |= (inc_enp) ? (0x80 >> il_enp) : 0;
    int_lvl |= (inc_ie)  ? (0x80 >> il_ie)  : 0;
    int_lvl |= (inc_nw)  ? (0x80 >> il_nw)  : 0;
    int_lvl |= (inc_pn)  ? (0x80 >> il_pn)  : 0;

    jumperAt (pic, 58, 12, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic,  58, 13, "INT LVL (B12)");

    /* system controller */

    jumperAt (pic, 3, 4, 1, VERTICAL, HORIZONTAL, 1);
    printAt (pic,  3, 5, "SYS CTL");
    printAt (pic,  3, 6, " (B16)");

    /* rotary switch (frc29: bit 7 = off) */

    printAt (pic,  33, 20, "SW2 < 8");
    printAt (pic,  33, 22, "(2) (1)");

   /* EPROM access time selection */
    printAt (pic,  10, 16, "-");
    printAt (pic,  10, 17, "-");
    printAt (pic,  10, 18, "*");
    printAt (pic,  10, 19, "\"");
    printAt (pic,  4, 20, "EPROM SPEED (B4)");
    printAt (pic,  48, 20, "[*] jumper this field ");
    printAt (pic,  52, 21, "when using fast eprom");
    }
