/* frc21/config.h - Force SYS68K/CPU-21/9 configuration header */

/*
modification history
--------------------
02e,25aug88,gae  changed IO_ADRS_EX to please tja.
02d,26jul88,gae  made HALF_MEG (frc21) version not be default configuration.
		 got rid of FORCEBUG stuff.
02c,22jul88,gae  changed excluding of spyLib only for HALF_MEG/CPU-21 version.
02b,10jun88,gae  #undef'd some INCLUDE_s 'cuz it won't all fit in .5 Meg.
02a,29apr88,gae  relocated bulk to configAll.h.
01c,27apr88,ecs  added EXC_MSG_ADRS.
01b,19apr88,llk  includes RPC and DBX.
01a,22feb88,dnw  adapted from stuff from Terry Arden
*/

/*
This file contains the parameters that define the configuration
for VxWorks on the Force SYS68K/CPU-21/9.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "frc21.h"

#undef	INCLUDE_EX		/* doesn't work with board(s) 'cuz DMA */


#define	HALF_MEG	FALSE	/* TRUE = CPU-21, FALSE = CPU-29 */
#if	HALF_MEG
/* if only .5 Meg is available the following modules should be excluded. */
#undef	INCLUDE_DBX
#undef	INCLUDE_NFS
#undef	INCLUDE_TELNET
#undef	INCLUDE_RT11
#undef	INCLUDE_RAMDRV
#undef	INCLUDE_SPY	/* can't use - no auxiliary clock on CPU-21 */
#endif	HALF_MEG


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/frc21/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/*
 * Device controller I/O addresses: the CPU-21/9 needs top bits 0xfc000000 set
 */

#undef	IO_ADRS_EX
						/* impossible!!! */
#define IO_ADRS_EX	((char *) 0xfc000000)	/* 24A,16D Excelan ethernet */
#undef	IO_ADRS_ENP
#define IO_ADRS_ENP	((char *) 0xfcde0000)	/* 24A,16D ENP ethernet */
#undef	IO_ADRS_IE
#define IO_ADRS_IE	((char *) 0xfc300000)	/* 24A,16D Sun Ethernet */
#undef	IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0xfcf80000)	/* 24A,16D ISI Ethernet */
#undef	IO_ADRS_PN
#define IO_ADRS_PN	((char *) 0xfc100000)	/* 24A,16D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_CLOCK		INT_VEC_PIT1_TIMER	/* PIT timer 1 */


/* backplane network parameters */

/*
 * The CPU-21/9 board does not have mailboxes so the backplane driver polls.
 */

#define BP_ANCHOR_ADRS	((char *) 0xfb800000)	/* backplane shared memory */

#define BP_INT_TYPE	BP_INT_NONE		/* backplane polls */
#define BP_INT_ARG1	0
#define BP_INT_ARG2	0
#define BP_INT_ARG3	0

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The CPU-21/9 local memory is not dual-ported and hence not accessible
 * from the bus.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x0		/* fixed */
#define LOCAL_BUS_MEM_ADRS	NONE		/* not dual ported */

/* The following address is the base address of the on-board rom monitor */

#define ROM_BASE_ADRS	((char *) 0xff000000)	/* without forcebug */

#endif	INCconfigh
