/* usrConfig.c - user defined system configuration module */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
10z,23may89,dnw  added test for SYSFLG_NO_STARTUP_SCRIPT.
10y,02may89,dnw  added INCLUDE_{NETWORK,NET_INIT,NET_SYM_TBL,SHELL}
		 added usrDemo() if INCLUDE_SHELL not defined.
		 changed to execute startup script from
		  <host>:<bootDir>/startup.cmd (only if INCLUDE_STARTUP_SCRIPT)
10x,13feb89,jcf  changed the calling sequence of lnattach.
10w,20dec88,gae  moved BP_TAS to configAll.h.
10v,28nov88,gae  added test-and-set parameter to bpInit.
10u,04nov88,dnw  made startupScript be LOCAL.
		 added INCLUDE_ADA, removed DBX_DEBUG_ADA.
		 improved error checking/reporting.
		 added usrNvRamSet().
10t,31oct88,gae  removed ie ethernet address to sun3e/sysLib.c.
	   +rdc	 added shell startup script example.  Added parm to dbxInit.
10s,09sep88,llk  documentation for tuning NFS variables.
		 prints message while nfs mounting.
10r,20aug88,gae  documentation.
10q,09aug88,gae  cleaned up lnattach() and LANCE/NFS problems.
10p,26jul88,rdc+ added mv147 LANCE ethernet chip support. 
	    dfm  fixed reference to INT_VEC_PARITY_ERROR from number to offset.
10o,29jun88,jcf  made kernel independent.
		 signals are not optional, so removed INCLUDE_SIGNALS.
10n,22jun88,dnw  name tweaks.
		 added "localhost" == "127.0.0.1".
10m,07jun88,gae  added call to sysClkEnable().
10l,16jun88,llk  changed to automatically mount an nfs disk (disk name is
		   extracted from the boot file's name) and set the current
		   directory to the nfs disk.  Used when NFS is compiled in,
		   and the boot file starts with a '/'.
10k,05jun88,dnw  changed timLib to timexLib.
		 added INCLUDE_{SIGNALS,DEBUG,RLOGIN,TELNET}.
		 changed ldLib to loadLib.
		 changed taskSpawn/taskCreate args.
10j,04jun88,llk  changed usage of setAuthUnixUser to nfsAuthUnixSet.
10i,30may88,dnw  changed to v4 names.
10h,29may88,jcf  added tickSet (0) to initiallize time.
10g,29may88,dnw  changed to spawn idle task unbreakable.
10f,28may88,dnw  moved printLogo() to usrLib.
		 renamed netInit() to usrNetInit().
		 changed fioSet...() to ioSetGlobalStd (...).
		 changed call to ldLoadAt() to ldLoadModule().
10e,26may88,gae  added sigInit() call.
10d,29apr88,gae  added INCLUDE_{RT11,RAMDRV,STDIO,SPY,TIMLIB}.
10c,24mar88,ecs  added conditional include of configVrtx32.h.
		 changed printLogo to include vxWorks version.
10b,19apr88,llk  starts up nfs driver if RPC is compiled in.
		   nfs user permissions are hardwired at the setAuthUnixUser()
		   call.  Change these if they are not adequate.
10a,22feb88,jcf  made kernel independent (phase 1).
09u,19feb88,dnw  added subnet mask options to boot parameters.
09t,12feb88,rdc  added call to clnt_tcpInit to pull in RPC tcp client module.
09s,22jan88,gae  added remLibInit().
*/

/*
DESCRIPTION
This is the WRS-supplied configuration module for VxWorks.
It contains the root task, the primary system
initialization routine, the network initialization routine, and the clock
interrupt routine.

The include file "config.h" includes a number of system-dependent paramters
used in this file.

INCLUDE FILE: config.h

SEE ALSO: "Cross-Development", "Getting Started"
*/

/* LINTLIBRARY */

#include "vxWorks.h"
#include "ctype.h"
#include "inetLib.h"
#include "ioLib.h"
#include "iv68k.h"
#include "loadLib.h"
#include "strLib.h"
#include "sysLib.h"
#include "sysSymTbl.h"
#include "taskLib.h"
#include "version.h"

#include "config.h"

IMPORT VOID sysVwTrapRtn ();	/* vxWorks trap handler entry */
IMPORT VOID sysMemParityError();/* memory parity err handling routine */
IMPORT char *bootStringToParams ();/* interpret boot line */
IMPORT char *sysModel ();	/* model name of system CPU */
IMPORT char *kernelVersion ();	/* get kernel version string */
IMPORT VOID logMsg ();		/* log error message */
IMPORT ULONG tickGet ();	/* get current time in ticks */

IMPORT char edata;		/* automatically defined by the loader */
IMPORT char end;		/* automatically defined by the loader */
IMPORT int  remLastResvPort;	/* last port num used (from bootroms) */
IMPORT SYMTAB_ID standAloneSymTbl;	/* ptr to linked in symbol table -
					 * STANDALONE versions only */
IMPORT int shellTaskOptions;    /* shell task options for NKR Fortran */

/* IMPORT task priorities so that they are user configurable */

IMPORT int cdbDaemonTaskPriority;	/* CDB daemon task priority */
IMPORT int cdbServerTaskPriority;	/* CDB server task priority */
IMPORT int dbxTaskPriority;     /* DBX task priority */
IMPORT int excTaskPriority;     /* Exception task priority */
IMPORT int logTaskPriority;     /* log task priority */
IMPORT int netTaskPriority;     /* net daemon task priority */
IMPORT int portmapdPriority;	/* portmapd priority */
IMPORT int rlogTaskPriority;    /* rlogind task priority */
IMPORT int shellTaskPriority;   /* shell task priority */
IMPORT int spyTaskPriority;     /* spy task priority */
IMPORT int telnetTaskPriority;	/* telnet daemon task priority */

/* global variables */

SYMTAB_ID sysSymTbl;		/* system symbol table id */

int idleTaskId;			/* task id of idle task */
int idleTaskPriority     = PRIORITY_IDLE;
int idleTaskOptions      = VX_SUPERVISOR_MODE | VX_UNBREAKABLE;
int idleTaskStackSize    = 1000;

#if defined(INCLUDE_ADA)
BOOL sysAdaEnable = TRUE;	/* TRUE = enable Ada support options */
#else
BOOL sysAdaEnable = FALSE;
#endif

/* forward declarations */

VOID usrClock ();
VOID usrRoot ();
LOCAL STATUS loadSymTbl ();
LOCAL VOID usrDemo ();


/* check include dependencies */
 
#if defined(INCLUDE_DBX) || defined(INCLUDE_NFS)
#define INCLUDE_RPC             /* rpc required by dbx and nfs */
#endif
 
#if defined(INCLUDE_RPC) || defined(INCLUDE_NET_SYM_TBL)
#define INCLUDE_NET_INIT	/* net init required by rpc and net sym tbl */
#endif
 
#if defined(INCLUDE_NET_INIT)
#define INCLUDE_NETWORK		/* network required for net init */
#endif
 
#if defined(INCLUDE_DBX)
#define INCLUDE_DEBUG           /* native debugging required by dbx */
#endif

#if defined(INCLUDE_RAMDRV)
#define INCLUDE_RT11            /* RT-11 required by ramDrv */
#endif
 
#if defined(INCLUDE_DBX)
#define INCLUDE_MC68881         /* gets dragged in by DBX */
#endif
 

/* traditional STANDALONE configuration has network included but not
 * initialized, and standalone symbol table
 */
 
#if defined(STANDALONE)

#define INCLUDE_STANDALONE_SYM_TBL
#define INCLUDE_NETWORK
#undef INCLUDE_NET_SYM_TBL
#undef INCLUDE_NET_INIT

#endif STANDALONE
 
/*******************************************************************************
*
* usrInit - user defined system initialization routine
*
* THIS IS THE FIRST C CODE EXECUTED AFTER BOOT UP. This routine is
* called by the assembly language start-up routine sysInit which is
* in the sysALib module of the target specific directory.
* It is called in supervisor mode with the interrupts locked out.
* The kernel is not multi-tasking at this point.
*
* This routine starts by clearing BSS, so all variables are initialized
* to 0 as per the C specification.  Then it initializes the hardware by
* calling sysHwInit, sets up the 68K interrupt/exception vectors, 
* and starts the kernel multi-tasking with usrRoot(1) as the root task.
*
* SEE ALSO: kernelLib (1)
*/

VOID usrInit ()

    {

#if (CPU==MC68020)
    sysCacheEnable (TRUE);		/* enable cache memory */
#endif

    bzero (&edata, &end - &edata);	/* clear bss */

    /* set the vector base register (except on 68000);
     * initialize exception/interrupt vectors */

#if ((CPU==MC68010) || (CPU==MC68020))
    intVecBaseSet ((FUNCPTR *) VEC_BASE_ADRS);
#endif

    excVecInit ();
    intVecSet (TRAPNUM_TO_IVEC (TRAP_VXWORKS), sysVwTrapRtn);  /* vxWks trap */


    /* do system dependent hardware initialization */

    sysHwInit ();

    /* start the kernel specifying usrRoot as the root task */

    kernelInit (TRAP_KERNEL, usrRoot, ROOT_STACK_SIZE,
		FREE_RAM_ADRS, sysMemTop (), ISR_STACK_SIZE, INT_LOCK_LEVEL);
    }
/*******************************************************************************
*
* usrRoot - root task
*
* This task is the first task to be run under the multi-tasking kernel.
* It performs all final initialization and then starts other tasks.
*
* It initializes the I/O system, install drivers, create devices,
* sets up the network, etc., as necessary for the particular configuration.
* It may also create and load the system symbol table if one is to be included.
* It may then load and/or spawn additional tasks as needed.
* In the default configuration, it simply initializes the VxWorks shell.
*/

VOID usrRoot ()
    {
    int fd;

    /* reset task priorities; other task priorities are set under INCLUDES */

    excTaskPriority = PRIORITY_EXC;     /* Exception task priority */
    logTaskPriority = PRIORITY_LOG;     /* log task priority */

    /* set up parity error interrupt routine, if interrupt vector is defined */

#ifdef	INT_VEC_PARITY_ERROR
    intConnect (INUM_TO_IVEC (INT_VEC_PARITY_ERROR), sysMemParityError, 0);
#endif	INT_VEC_PARITY_ERROR

    /* set up system timer */

    wdLibInit ();			/* init watchdog lib */

    sysClkConnect (usrClock, 0);	/* connect clock interrupt routine */
    sysClkRateSet (60);			/* set sys clock rate */
    sysClkEnable ();			/* start it */

    tickSet ((ULONG) 0);		/* set initial time to zero */

    /* initialize i/o system */

    iosInit (NUM_DRIVERS, NUM_FILES, "/null");	/* init i/o system */

    /* install driver for on-board ports and make devices */

    tyCoDrv ();

    tyCoDevCreate ("/tyCo/0", 0, 512, 512);
    tyCoDevCreate ("/tyCo/1", 1, 512, 512);    /* connect second serial port *
						* if there is one. */

    /* make specified console device be standard in/out */

    fd = open (CONSOLE_DEVICE, UPDATE, 0);	/* open console device */
    ioctl (fd, FIOBAUDRATE, 9600);		/* set to 9600 baud */
    ioctl (fd, FIOOPTIONS, OPT_TERMINAL);	/* set normal terminal opts */
    ioGlobalStdSet (STD_IN, fd);		/* set as std in */
    ioGlobalStdSet (STD_OUT, fd);		/* set as std out */
    ioGlobalStdSet (STD_ERR, fd);		/* set as std error */

    /* initialize idle task */

    idleTaskId = taskSpawn ("idle", idleTaskPriority, idleTaskOptions,
			    idleTaskStackSize, idle);


    /* install pipe driver, exception reporting, logging, and debugging */


    pipeDrv ();			/* init pipe driver */
    excInit ();			/* init exception reporting/handling */
    logInit (fd, 500);		/* init logging */
    sigInit ();			/* initialize signals */

#ifdef	INCLUDE_DEBUG
    dbgInit (TRAP_DEBUG);	/* init debugging */
#endif	INCLUDE_DEBUG

    /* initialize standard I/O package */

#ifdef	INCLUDE_STDIO
    stdioInit ();		/* initialize standard I/O library */
#endif	INCLUDE_STDIO


    /* create RT-11 disk devices */

#ifdef	INCLUDE_RT11
    rt11Init (NUM_RT_FILES);	/* init RT-11 file system */
#endif	INCLUDE_RT11

#ifdef	INCLUDE_RAMDRV
    ramDrv ();			/* initialize ram disk driver */
#endif	INCLUDE_RAMDRV


    /* initialize floating point facilities */

#ifdef	INCLUDE_FLOATING_POINT
    floatInit ();		/* initialize floating point i/o support */
#endif	INCLUDE_FLOATING_POINT

#ifdef	INCLUDE_MC68881
    fppInit ();			/* initialize 68881 support */
    mathInit ();		/* get 68881 math functions (trig, log, etc) */
#endif	INCLUDE_MC68881

    /* initialize performance monitoring tools */

#ifdef	INCLUDE_SPY
    spyTaskPriority = PRIORITY_SPY;     /* spy task priority */
    spyStop ();			/* harmless call to drag in spyLib */
#endif	INCLUDE_SPY

#ifdef	INCLUDE_TIMEX
    timexInit ();		/* harmless call to drag in timexLib */
#endif	INCLUDE_TIMEX

#ifdef	INCLUDE_FORTRAN
    ftnInit ();			/* initialize NKR Fortran */
    ftnGlue ();			/* force loading of NKR interfaces */
    shellTaskOptions |= VX_FORTRAN; /* add Fortran option to shell options */
#endif	INCLUDE_FORTRAN

    /* initialize network */
 
#ifdef  INCLUDE_NET_INIT
    usrNetInit (BOOT_LINE_ADRS);
#endif  INCLUDE_NET_INIT
 
    /* initialize symbol table - either standalone or from network */
 
#ifdef  INCLUDE_STANDALONE_SYM_TBL
    sysSymTbl = standAloneSymTbl;
#endif  INCLUDE_STANDALONE_SYM_TBL
 
#ifdef  INCLUDE_NET_SYM_TBL
    sysSymTbl = symTblCreate (MAX_SYS_SYMBOLS, MAX_SYS_SYM_LEN);
    netLoadSymTbl ();
#endif  INCLUDE_NET_SYM_TBL

    /* run startup script, unless boot flag says not to */

#ifdef  INCLUDE_STARTUP_SCRIPT
    if ((sysFlags & SYSFLG_NO_STARTUP_SCRIPT) == 0)
	netStartupScript ();
#endif  INCLUDE_STARTUP_SCRIPT

    /* print the logo */

#ifdef	INCLUDE_SHELL
    printLogo ();
#endif	INCLUDE_SHELL

    /* ISI Drivers */
  
#ifdef	INCLUDE_SM
    smDrv ();			/* Interphase 3200 SMD driver */
#endif	INCLUDE_SM

#ifdef	INCLUDE_DR
    drDrv ();			/* Ikon DR-11W driver */
#endif	INCLUDE_DR

#ifdef	INCLUDE_CP
    cpDrv ();			/* ISI ICP8/16 driver */
#endif	INCLUDE_CP

#ifdef	INCLUDE_TS
    tsDrv ();			/* TC50/QIC2-X tape driver */
#endif	INCLUDE_TS

    /* initialize shell (or demo if shell not included) */

#ifdef  INCLUDE_SHELL
    shellTaskPriority = PRIORITY_SHELL; /* set shell task priority */
    shellInit (SHELL_STACK_SIZE, TRUE);
#else   INCLUDE_SHELL
    taskSpawn ("demo", 20, 0, 2000, usrDemo);
#endif  INCLUDE_SHELL
/* ************  Put any startup scripts here ******** */
/*    cd ("host:/directory/dir"); */
    cd ("porsche:/u/laser");

    }
/*******************************************************************************
*
* usrClock - user defined system clock interrupt routine
*
* This routine is called at interrupt level on each clock interrupt.
* It is installed by usrRoot with a sysClkConnect (2) call.
* It calls all the other packages that need to know about clock ticks,
* including the kernel itself.
*
* If the application needs anything to happen at the system clock interrupt
* level, it can be added to this routine.
*/

VOID usrClock ()

    {
    wdTick ();		/* check watchdog timers */
    tickAnnounce ();	/* announce system tick to kernel */
    }


#ifndef INCLUDE_SHELL

/********************************************************************************
* usrDemo - example application without shell
*
* This routine is spawned as a task at the end of usrRoot, if INCLUDE_SHELL
* is NOT defined in configAll.h or config.h.  It is intended to indicate
* how a shell-less application can be linked, loaded, and ROMed.
*/

LOCAL VOID usrDemo ()
    {
    char string [40];

    printf ("VxWorks (for %s) version %s.\n", sysModel (), vxWorksVersion);
    printf ("Kernel: %s.\n", kernelVersion ());
    printf ("Made on %s.\n", creationDate);

    FOREVER
        {
        printf ("\nThis is a test.  Type something: ");
        fioRdString (STD_IN, string, sizeof (string));
	printf ("\nYou typed \"%s\".\n", string);

	if (strcmp (string, "0") == 0)
	    memShow (0);

	if (strcmp (string, "1") == 0)
	    memShow (1);
        }
    }

#endif INCLUDE_SHELL



#if defined(INCLUDE_NETWORK)

/*******************************************************************************
*
* usrNetInit - system dependent network initialization
*
* This routine initializes the network.  
* The ethernet and backplane drivers and the TCP/IP software are configured.
* It also adds hosts (analogous to the /etc/hosts file in UNIX), 
* gateways (analogous to /etc/gateways),
* sets up our access rights on the host system (with iam (2)),
* optionally initializes telnet, rlogin, RPC, NFS, and dbxWorks support.
*
* The boot string parameter is normally left behind by the boot ROMs,
* at address BOOT_LINE_ADRS.
*
* Unless the STANDALONE option is selected in usrConfig(2), this routine
* will automatically be called by the root task usrRoot(1).
*
* RETURNS
*  OK,   or
*  ERROR if a problem in the boot string, or initializing network
*
* SEE ALSO: NETWORK chapter of the VxWorks Programmer's Guide
*/

STATUS usrNetInit (bootString)
    char *bootString;		/* boot parameter string */

    {
    char devName [MAX_FILENAME_LENGTH];	/* device name */
    char bootDev [BOOT_FIELD_LEN];	/* boot device code */
    char ead [BOOT_FIELD_LEN];		/* ethernet internet addr */
    char bad [BOOT_FIELD_LEN];		/* backplane internet addr */
    char had [BOOT_FIELD_LEN];		/* host internet addr */
    char gad [BOOT_FIELD_LEN];		/* gateway internet addr */
    char usr [BOOT_FIELD_LEN];		/* user id */
    char passwd [BOOT_FIELD_LEN];	/* password */
    int procNum;			/* processor number */
    char nad [BOOT_FIELD_LEN];		/* host's network internet addr */
    int protocol;
    char nfsDisk [MAX_FILENAME_LENGTH];
    char *p;
    FAST char *pS;
    char ifname [20];
    STATUS status;
    int eNetmask;
    int bNetmask;


#ifdef	TARGET_ISI_VME68K20
    /* for compatibility with ISI boot roms, turn single EOS into spaces;
     * boot line MUST be terminated with TWO EOS! */

    for (pS = bootString; (pS[0] != EOS) || (pS[1] != EOS); ++pS)
	{
	if (pS[0] == EOS)
	    pS[0] = ' ';
	}
#endif	TARGET_ISI_VME68K20

    /* interpret boot command */

    pS = bootStringToParams (bootString, bootDev, sysBootHost, sysBootFile,
			  ead, bad, had, gad, usr, passwd, &procNum, &sysFlags);
    if (*pS != EOS)
	{
	/* print error msg with '^' where parse failed */

	printf ("Error in boot command:\n%s\n%*c\n", bootString,
		pS - bootString + 1, '^');
	return (ERROR);
	}

    eNetmask = 0;
    if (bootNetmaskExtract (ead, &eNetmask) < 0)
	{
	printf ("invalid netmask specified: %s\n", ead);
	return (ERROR);
	}

    bNetmask = 0;
    if (bootNetmaskExtract (bad, &bNetmask) < 0)
	{
	printf ("invalid netmask specified: %s\n", bad);
	return (ERROR);
	}

    /* set processor number: may establish vme bus access, etc. */

    sysProcNumSet (procNum);

    hostTblInit ();		/* initialize remote command library */

    /* attach and configure the network interfaces */
    
    remLastResvPort = 1010;	/* pick an unused port number so we don't *
				 * have to wait for the one used by the *
				 * by the bootroms to time out */

    netTaskPriority = PRIORITY_NETD;    /* net daemon task priority */

    netLibInit ();


    /* if enet address specified, initialize enet boot device */

    if (ead[0] != NULL)
	{
	printf ("Attaching network interface %s0... ", bootDev);

	if (FALSE)	/* so INCLUDEs will work with 'else if's */
	    ;
#ifdef	INCLUDE_EX
	else if (strcmp (bootDev, "ex") == 0)
	    status = exattach (0, IO_ADRS_EX, INT_VEC_EX, INT_LVL_EX);
#endif	INCLUDE_EX
#ifdef	INCLUDE_ENP
	else if (strcmp (bootDev, "enp") == 0)
	    status = enpattach (0, IO_ADRS_ENP, INT_VEC_ENP, INT_LVL_ENP);
#endif	INCLUDE_ENP
#ifdef	INCLUDE_IE
	else if (strcmp (bootDev, "ie") == 0)
	    status = ieattach (0, IO_ADRS_IE, INT_VEC_IE, INT_LVL_IE);
#endif	INCLUDE_IE
#ifdef	INCLUDE_NW
	else if (strcmp (bootDev, "nw") == 0)
	    status = nwattach (0, IO_ADRS_NW, INT_VEC_NW, INT_LVL_NW);
#endif	INCLUDE_NW
#ifdef	INCLUDE_PN
	else if (strcmp (bootDev, "pn") == 0)
	    status = pnattach (0, IO_ADRS_PN, INT_VEC_PN, INT_LVL_PN);
#endif	INCLUDE_PN
#ifdef	INCLUDE_LN
	else if (strcmp (bootDev, "ln") == 0)
	    {
#if defined (TARGET_FRC_37) || defined (TARGET_FRC_30)
	    /* Force 30 & 37 are supposed to use the board serial number as the
	     * last two bytes of the ethernet address, but this is not currently
	     * available at run-time (i.e. in non-volitile RAM), so we use the
	     * bottom two bytes of the internet address instead.
	     */
	    IMPORT char lnEnetAddr [];      /* ethernet addr for lance */

	    u_long inet = inet_addr (ead);
	    lnEnetAddr [4] = (inet >> 8) & 0xff;
	    lnEnetAddr [5] = inet & 0xff;
#endif
	    status = lnattach (0, IO_ADRS_LN, INT_VEC_LN, INT_LVL_LN, 
			       LN_POOL_ADRS, LN_POOL_SIZE, LN_DATA_WIDTH);
	    }
#endif	INCLUDE_LN

	else
	    {
	    printf ("interface %s unknown.\n", bootDev);
	    return (ERROR);
	    }

	if (status != OK)
	    {
	    printf ("failed: status = 0x%x.\n", errnoGet ());
	    return (ERROR);
	    }
	else
	    printf ("done.\n");

 	/* configure ethernet interface with specified inet adrs and net mask */

	strcpy (ifname, bootDev);
	strcat (ifname, "0");

	if (eNetmask != 0)
	    ifMaskSet (ifname, eNetmask);

	ifAddrSet (ifname, ead);
	}


    /* if bp net address specified, initialize bp device */

    if (bad[0] != NULL)
	{
	char *bpDev = NULL;

	/* NOTE: INCLUDE_BP and INCLUDE_VB cannot BOTH be defined! */

#ifdef	INCLUDE_BP
	char *bpAnchor = BP_ANCHOR_ADRS;	/* default anchor */

	if (strncmp (bootDev, "bp=", 3) == 0)
	    {
	    if (bootBpAnchorExtract (bootDev, &bpAnchor) < 0)
		{
		printf ("invalid bp anchor address: %s\n", bootDev);
		return (ERROR);
		}
	    }

	bpDev = "bp";
	printf ("Attaching backplane interface %s0 at 0x%x... ",
		bpDev, bpAnchor);

	if (sysProcNumGet() == 0)
	    bpInit (bpAnchor, (char *)BP_MEM_ADRS, (int) BP_MEM_SIZE, BP_TAS);

	status = bpattach (0, bpAnchor, sysProcNumGet(),
			   BP_INT_TYPE, BP_INT_ARG1, BP_INT_ARG2, BP_INT_ARG3);
#endif	INCLUDE_BP

#ifdef INCLUDE_VB
	/* If the ISI cluster-compatible backplane driver is required
	 * (for use with ISI Unix-to-vxWorks backplane communications),
	 * use the "vb" driver instead of the "bp" driver. 
	 */

	bpDev = "vb";
	printf ("Attaching backplane interface %s0 at 0x%x... ",
		bpDev, VB_SHARED_MEM);

	status = vbattach (0, sysProcNumGet(), VB_SHMEM_SIZE);
#endif	INCLUDE_VB

	if (bpDev == NULL)
	    printf (
	      "\nError: backplane address specified but no driver included.\n");

	else if (status != OK)
	    printf ("failed: status = 0x%x.\n", errnoGet ());
	
	else
	    {
	    printf ("done.\n");

	    /* configure backplane interface with specified inet adrs */

	    strcpy (ifname, bpDev);
	    strcat (ifname, "0");

	    if (bNetmask != 0)
		ifMaskSet (ifname, bNetmask);

	    ifAddrSet (ifname, bad);
	    }
	}


    /* add loop-back interface */

    loattach ();
    ifAddrSet ("lo0", "127.0.0.1");
    hostAdd ("localhost", "127.0.0.1");

    /* if a gateway was specified, extract the network part of the host's
       address and add a route to this network */

    if (gad[0] != EOS)
        {
	inet_netof_string (had, nad);
	routeAdd (nad, gad);
        }


    /* associate host name with the specified host address */

    hostAdd (sysBootHost, had);		


    /* create transparent remote file access device;
     * device name is sysBootHost with ':' appended.
     * protocol is rcmd if no password, or ftp if password specified
     */

    netDrv ();					/* init remote file driver */
    strcpy (devName, sysBootHost);		/* create device name */
    strcat (devName, ":");
    protocol = (passwd[0] == EOS) ? 0 : 1;	/* pick protocol based on pw */
    netDevCreate (devName, sysBootHost, protocol); /* create remote file dev */


    /* set the user id, and current directory */

    iam (usr, passwd);
    ioDefPathSet (devName);

    taskDelay (sysClkRateGet () / 4);		/* 1/4 of a second */


    /* start the rlogin or telnet daemon,
     * again based on whether or not password was specified */

#ifdef	INCLUDE_RLOGIN
    rlogTaskPriority = PRIORITY_RLOGIND;/* rlogind task priority */
    if (passwd[0] == EOS)
	rlogInit ();
#endif	INCLUDE_RLOGIN

#ifdef	INCLUDE_TELNET
    if (passwd[0] != EOS)
	telnetInit ();
#endif	INCLUDE_TELNET

    /* initialize the vb backplane poll if specified */

#ifdef	INCLUDE_VB
    {
    IMPORT VOID vbPoll ();

    if (ifunit("vb0")) {
        taskSpawn("vbPoll", PRIORITY_VBPOLL, VX_SUPERVISOR_MODE, 0x2000, 
		vbPoll);
        isiBootInit ();
    }
    }
#endif	INCLUDE_VB

    /* initialize rpc and dbx daemon if specified */

#ifdef	INCLUDE_RPC
    portmapdPriority = PRIORITY_PORTMAPD;
    rpcInit ();
    clnt_tcpInit ();		/* pulls in tcp client module */
#endif	INCLUDE_RPC

#ifdef	INCLUDE_DBX
    dbxTaskPriority = PRIORITY_DBX;     /* DBX task priority */
    dbxInit ();
#endif	INCLUDE_DBX

#ifdef	INCLUDE_CDB
    cdbDaemonTaskPriority = PRIORITY_CDBDAEMON;
    cdbServerTaskPriority = PRIORITY_CDBSERVER;
    cdbInit ();
#endif	INCLUDE_CDB

    /* initialize NFS if specified */

#ifdef	INCLUDE_NFS
    /*
     * The following values are the default values used in NFS.
     * They can be reset here if necessary.
     *
     *     nfsMaxMsgLen   = 8192	message size (decrease only)
     *     nfsTimeoutSec  = 5		timeout seconds
     *     nfsTimeoutUSec = 0		timeout microseconds
     *     nfsSockOptval  = 10000	socket send and recv buffer size
     */

    nfsAuthUnixSet (sysBootHost, NFS_USER_ID, NFS_GROUP_ID, 0, (int *) 0);

    if (nfsDrv () == ERROR)	/* initialize nfs driver */
	printf ("NFS driver did not start up\n");
    else
	{
	/* strip the nfs disk name from the boot file's name */

	strcpy (nfsDisk, sysBootFile);
	if (*nfsDisk != '/')
	    printf ("No NFS disk specified.\n");
	else
	    {
	    /* boot file name begins with '/' */

	    if ((p = index (&nfsDisk [1], '/')) != NULL)
		{
		/* there's a second '/' in path,
		 * mount first directory in path name.
		 * device name of form "/<dir>" 
		 */

		*p = EOS;
		}
	    else
		{
		nfsDisk [1] = EOS;	/* mount '/' */
		}

	    /* mount the disk */

	    printf ("Mounting \"%s\" from host \"%s\"... ", nfsDisk,
		     sysBootHost);
	    if (nfsMount (sysBootHost, nfsDisk, nfsDisk) == ERROR)
		printf ("failed.\n");
	    else
		{
		printf ("done.\n");

		/* reset the current directory to be the nfs disk */

		ioDefPathSet (nfsDisk);
		}
	    }
	}
#else
    printf ("NFS not included.\n");
#endif	INCLUDE_NFS

    return (OK);
    }

#endif INCLUDE_NETWORK



#if defined(INCLUDE_NET_SYM_TBL)

/********************************************************************************
* netLoadSymTbl - load system symbol table from network
*
* Create system symbol table and load across the network.
* The name of the symbol table file is constructed as:
*      <host>:<bootFile>.sym
*/

LOCAL STATUS netLoadSymTbl ()
    {
    char symTblFile [BOOT_FIELD_LEN];   /* name of symbol table file */

    sprintf (symTblFile, "%s:%s.sym", sysBootHost, sysBootFile);
    printf ("Loading symbol table from %s ...\n", symTblFile);

    return (loadSymTbl (symTblFile));
    }
/*******************************************************************************
*
* loadSymTbl - load system symbol table
*
* This routine loads the system symbol table.
*/

LOCAL STATUS loadSymTbl (symTblName)
    char *symTblName;

    {
    int symfd;
    char *loadAddr;

    /* open symbol table file */

    symfd = open (symTblName, READ, 0);
    if (symfd == ERROR)
	{
	printf ("Error opening %s: status = 0x%x\n", symTblName, errnoGet());
	return (ERROR);
	}

    /* load system symbol table */

    loadAddr = 0;		/* to prevent symbols from being relocated */
    if (loadModuleAt (symfd, 
		      (sysFlags & SYSFLG_DEBUG) ? ALL_SYMBOLS : GLOBAL_SYMBOLS,
		      &loadAddr, (char **) NULL, (char **) NULL) == ERROR)
	{
	printf ("Error loading symbol table: status = 0x%x\n", errnoGet ());
	close (symfd);
	return (ERROR);
	}

    close (symfd);

    return (OK);
    }

#endif	INCLUDE_NET_SYM_TBL



#if defined(INCLUDE_STARTUP_SCRIPT)

/********************************************************************************
* netStartupScript - execute startup script from network
*
* This routine constructs a startup script filename of the form:
*      <host>:<bootDir>/startup.cmd
* where <bootDir> is the directory from which VxWorks was booted.
* This file is then executed as a shell script.
*/

LOCAL VOID netStartupScript ()
    {
    char bootDir [BOOT_FIELD_LEN];   /* name of startup script file */
    FAST char *pLastSlash;

    sprintf (bootDir, "%s:%s", sysBootHost, sysBootFile);
    pLastSlash = rindex (bootDir, '/');
    if (pLastSlash != NULL)
	*(pLastSlash + 1) = EOS;
    else
	sprintf (bootDir, "%s:", sysBootHost);
    strcat (bootDir, "startup.cmd");

    startupScript (bootDir);
    }

/******************************************************************************
*
* startupScript - make shell read initial startup script file
*
* This routine reads a startup script before the VxWorks shell comes up
* interactively
*
* WARNING
* This facility is subject to change; it will be better specified
* and integrated in future releases.
*/

LOCAL VOID startupScript (fileName)
    char *fileName;
 
    {
    int old;
    int new;
    
    if (fileName == NULL)
        return;

    new = open (fileName, READ);

    if (new != ERROR)
        {
        printf ("Executing startup script %s ...\n", fileName);
        taskDelay (sysClkRateGet () / 2);

        old = ioGlobalStdGet (STD_IN);  /* save original std in */
        ioGlobalStdSet (STD_IN, new);   /* set std in to script */
        shellInit (SHELL_STACK_SIZE, FALSE);    /* execute commands */

        /* wait for shell to finish */
        do
            taskDelay (sysClkRateGet ());
        while (taskNameToId ("shell") != ERROR);

        close (new);
        ioGlobalStdSet (STD_IN, old);   /* restore original std in */

        printf ("\nDone executing startup script %s\n", fileName);
        taskDelay (sysClkRateGet () / 2);
        }
    else 
        printf ("Unable to open startup script %s\n", fileName);
    }

#endif  INCLUDE_STARTUP_SCRIPT


/******************************************************************************
*
* usrNvRamSet - enter string into non-volitile ram
*
* This routine is temporary.
* The problem is that not all sysLib's have sysNvRamSet() yet.
* But we need a system independent routine that we can call.
*
* NO_MANUAL
*/  

STATUS usrNvRamSet (string)
    char *string;

    {
#ifdef	NV_RAM_SIZE
    sysNvRamSet (string, strlen (string) + 1, 0);
    return (OK);
#else
    return (ERROR);
#endif	NV_RAM_SIZE
    }
