/* configPsos.c - pSOS system configuration */

/*
modification history
--------------------
01k,01may89,dnw  added MAX_TASKS, previously in configAll.h.
01j,21apr89,jcf  ramEnd1 was one byte too many.
01i,02oct88,gae  increased WORK_SPACE size from 20000.
01h,24aug88,gae  got rid of kernelRoot -- now local.
01g,11jun88,jcf  changed into c file which just defines the config table.
01f,31may88,jcf  made psos not such a memory hog.
01e,30may88,dnw  changed to v4 names.
01d,17may88,ecs  removed copyright line.
01c,26apr88,ecs  removed IMPORT of idle task to taskLib.h.
01b,19apr88,llk  increased shell's stack size from 5000 to 10000.
01a,15feb88,jcf  written by extracting from usrConfig.c
*/

#include "vxWorks.h"
#include "config.h"
#include "psos.h"

IMPORT VOID psosTswitchHook ();	/* task switch extension */

#define MAX_TASKS	25	/* maximum # of tasks in system */
#define MAX_EXCH	25	/* maximum # of exchanges */
#define MAX_MSGB	50	/* maximum # of message buffers */
#define SYS_STACK_SIZE	1000	/* # of bytes for task system mode stacks */

/* workspace = 200 + SYS_STACK_SIZE + MAX_EXCH * 34 + MAX_MSGB * 24 +
		(MAX_TASKS+1) * 178 + 18) */

#define WORKSPACE_SIZE	21000	/* # of bytes for kernel workspace */

char psosWorkspace [WORKSPACE_SIZE];

/* pSOS configuration table */

PSOS_CONFIG_TABLE usrCftbl =
    {
    psosWorkspace,		/* pSOS workspace address */
    psosWorkspace + WORKSPACE_SIZE - 1,  /* pSOS workspace size */
    0,				/* minimum seg size = smallest */
    0,				/* region2 undelimited */
    0,				/* region2 undelimited */
    0,				/* region2 undelimited */
    MAX_TASKS,			/* user task count (max tasks) */
    MAX_EXCH,			/* number of active exchanges */
    MAX_MSGB,			/* number of active messages buffers */
    60,				/* clock frequency */
    5,				/* ticks per slice */
    0,				/* one I/O device (minimum) */
    0,				/* jump table address (set in kernelInit) */
    SYS_STACK_SIZE,		/* system stack size */
    0,				/* root start address (set in kernelInit) */
    100,			/* root sys stack size just enough for switch */
    ROOT_STACK_SIZE/2,		/* root user stack size */
    255,			/* root priority */
    (FUNCPTR) 0,		/* no activate routine */
    (FUNCPTR) 0,		/* no delete routine */
    psosTswitchHook, 		/* system task switch routine */
    0,				/* probeAddr address */
    0,				/* phileAddr address */
    0,				/* spare */
    0,				/* spare */
    0,				/* spare */
    0,				/* spare */
    0,				/* spare */
    0,				/* spare */
    };

PSOS_CONFIG_TABLE *pUsrCftbl = &usrCftbl; /* gets linked directly with pSOS */
