/* tickLib.c - VxWorks clock tick support library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01d,23sep88,gae  documentation touchup.
01c,23aug88,gae  documentation.
01b,12aug88,jcf  clean up.
01a,19jan87,jcf  written.
*/

/*
DESCRIPTION
This library provides a generic interface to VxWorks kernel time management.
This includes:

    - announce a clock tick to kernel,
    - get the current time in ticks,
    - set the current time in ticks.

SEE ALSO: "Architecture", taskLib (1), kernelLib (1)
*/

/* LINTLIBRARY */

#include "vxWorks.h"

IMPORT BOOL kernelState;	/* for use in kernel mutual exclusion */
IMPORT VOID windTickAnnounce ();

/* globals */

ULONG vxTicks;			/* current time in ticks */


/*******************************************************************************
*
* tickAnnounce - announce a clock tick to the kernel
*
* This routine is used to inform the kernel of the passing of time.
* It should be called from an interrupt service routine that is
* connected to the system clock.
*/

VOID tickAnnounce ()

    {
    if (kernelState)		/* we interrupted a critical section */
	windWorkAdd (windTickAnnounce);
    else
	{
	kernelState = TRUE;	/* KERNEL_ENT */
	windTickAnnounce ();
	windExit ();		/* KERNEL_EXIT */
	}
    }
/*******************************************************************************
*
* tickSet - set value of kernel's tick counter
*
* Sets the global variable `vxTicks'.
* This is will change the value returned by tickGet (2), but will not
* change any delay fields or timeouts selected for any tasks.
* For example, if a task is delayed for ten ticks, and
* this routine is called to advance time, the delayed task will
* still be delayed until ten tickAnnounce (2) calls have been made.
*
* SEE ALSO: tickGet (2)
*/
 
VOID tickSet (ticks)
    ULONG ticks;	/* new time in ticks */

    {
    vxTicks = ticks;
    }
/*******************************************************************************
*
* tickGet - get value of kernel's tick counter
*
* This routine returns the current value of the global variable `vxTicks'.
* This variable is set to zero at startup, and can be changed using tickSet (2).
*
* RETURNS: number of announced clock ticks
*
* SEE ALSO: tickSet (2)
*/

ULONG tickGet ()

    {
    return (vxTicks);
    }
