/* vrtxLib.c - internal VxWorks/VRTX kernel library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
02g,24aug88,gae  documentation.
02f,06jun88,dnw  changed vrtxFreeTaskIdGet() to scan up from 1 to 255.
03d,30may88,dnw  changed to v4 names.
03c,28may88,dnw  changed taskIdGet() to vrtxFreeTaskIdGet().
03b,24mar88,ecs  VRTX32 version.
		 added idle task.
03a,29feb88,jcf	 rewritten.  Most moved to taskLib, tickLib, kernelLib.
02k,20feb88,dnw  changed type of function vxMyTaskId() back to int.
02j,06jan88,rdc  modified vxMyTaskId to work without having to call VRTX.
02i,14dec87,gae  changed spawn() to not have multiple argument decl's for
		   parsing by the C interface generator.
02h,19nov87,jcf  took out delay in reboot.
		 added reboot hook facility.
		 added vxAddRebootRtn, which adds hooks to call in reboot.
02g,05nov87,jcf  added reboot which resets net devices and calls sysToMonitor
02f,04nov87,ecs  documentation.
02e,28oct87,jcf  fixed bug in vxTdelete so deleting non-existent tasks is ok
02d,22oct87,jcf  added create hook facility.
		 removed vxFppInstall() - floating-point done with task hooks.
02c,21oct87,jcf  added vxTdelete which reclaims the stacks correctly.
		 exit now does an excToDoAdd (vxTdelete).
		 the spbottom is now in the tcbx and called botOfStack.
		 deleted vxDeallocateStack
02b,06aug87,gae  relocated floating-point coprocessor routines to fppLib.
		 added vxDbgInstall() and vxFppInstall() as hooks for dbgLib
		   and fppLib.  Changed vxDeallocate() to use excToDoAdd()
		   instead of illegally free'ing.
02a,18may87,gae  added floating-point coprocessor support routines:
		   vxTaskFpSwitch(), vxFpProbe(), vxSetTaskFp(),
		   vxPrintFpRegs(), vxTaskFpRegs(), vxSetTaskFpRegs().
		 made spawnat() allocate storage for floating-point tasks.
		 removed incorrect call to setStatus() in spawnat().
01p,01apr87,ecs  hushed lint in vxSetTaskRegs & vxTaskRegs.
		 fixed an actual bug in vxSetTaskBreakable!
		 changed definition of BUS_ERROR_VEC to include coercion.
01o,21mar87,dnw  added sysMemProbe temporarily (now should use vxMemProbe).
01n,20mar87,jlf  added vxAddTaskCreateRtn and vxDelTaskCreateRtn
		 documentation
01m,22feb87,rdc  fixed bug in vxSetTaskRegs.  tcb_stack wasn't getting
		   updated if the sp was changed.
		 changed spawn and spawnat to force all tasks to supervisor
		   mode, until VxWorks can deal with the new VRTX
		   "user mode task" mechanism.
		 added vxMemProbe().
		 changed myTaskId() to vxMyTaskId().
		 changed vxSetTaskBreakable() remove/install breakpoints
		   immediately via vxBreak{Remove,Install} function pointers.
01l,21dec86,dnw  changed to not get include files from default directories.
01k,03nov86,llk  moved myTaskId here from usrLib.c.
01j,08nov86,dnw  changed vxGetFreeTaskId() to not return 250-255 which
		   are now reserved for vxWorks.
01i,04sep86,jlf  documentation.
01h,03sep86,llk  fixed bug in vxSetTaskRegs.  sp wasn't getting set properly
		 due to missing brackets.
01g,31jul86,llk  spawn2 is now called 'spawn'.  Deleted old spawn routine
		 New spawn returns task id, accepts NONE for a task id (chooses 
		 one for the caller), and expects an 'options' argument.
		 Deleted spawnSys, use options argument to spawn for spawning
		 supervisor mode tasks.
01f,17jul86,llk  added spawn2--the new main spawn routine.  
		 spawn, spawnSys, and restart call spawn2.
		 spawnat will accept NONE as a task id and then assign one
		 for the caller.  spawn2 and spawnat return task id of the 
		 new task.  spawn2 has an "options" parameter.
		 restart propagates a task's options.
		 Fixed bugs in restart, task was deleted and then variables 
		 in that task's TCBX were still referred to.
01e,10jul86,rdc  added task delete hook facilities.
		 added stack deallocation 
		 routine (for use with task delete hook).
		 modified restart to call spawn instead of vxTcreate because
		 stack now gets deleted by delete hook.
	    dnw  documentation.
01d,10jun86,rdc  changed memAllocates to mallocs.
		 added vxSetTaskRegs.
		 fixed vxTaskRegs to look at sr to determine if we're in system
		 mode (used to look at the mode the task was spawned in).
		 moved definition for TCB_STACK to vxWorks.h
01c,03apr86,dnw  added option word to tcbx.
		 changed spawnat() to take option word instead of mode flag.
		 added vxSetTaskOptions() and vxSetTaskBreakable().
01b,10mar86,jlf  added 68020 stuff
01a,08feb86,dnw  collected routines that used to be in usrLib and spnLib.
		 added task switch facilities.
		 added task variables facilities.
		 added tcbx stuff.
*/

/*
DESCRIPTION
This module contains internal support routines for the VxWorks/VRTX interface.

SEE ALSO: vrtxALib (1)
*/

#include "vxWorks.h"

#if (CPU == MC68020)
#include "vrtx32.h"
#else (CPU != MC68020)
#include "vrtx.h"
#endif (CPU)


/*******************************************************************************
*
* vrtxFreeTaskIdGet - get a free task id
*
* This routine finds a task id not currently used by any task.
* Note however that the returned task id is not "reserved" in any way
* and could conceivably be used by some other spawner before the caller
* gets around to using it.  For this reason, it is better to
* call taskSpawn (2) with a NULL task name so that one will be assigned.
*
* This routine looks forward from task id 1 to task id 255 for an unused id.
*
* RETURNS: unused task id, or ERROR if none available
*
* NOMANUAL
*/

int vrtxFreeTaskIdGet ()

    {
    int ix;		/* task number index */
    int dummy;		/* filled in, but not used */
    VRTX_TCB *pTcb;	/* filled in, but not used */

    for (ix = 1; ix <= 255; ++ix)
	{
	if (vrtxTinquiry (ix, &dummy, &dummy, &dummy, &pTcb) == ERROR &&
	    errnoGet () == S_vrtx_TASK_ID_ERROR)
	    {
	    return (ix);		/* found a free TID */
	    }
	}

    errnoSet (S_taskLib_NO_FREE_TASK_ID);
    return (ERROR);		/* couldn't find free task id !! */
    }
/*******************************************************************************
*
* idle - idle task
*
* This task is created at lowest priority.  We drop to here if
* nothing else to do.
*
* NOMANUAL
*/

VOID idle ()

    {
    FOREVER;
    }
