/* tickLib.c - VxWorks/VRTX clock tick support library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01c,24aug88,gae  documentation.
01b,22apr88,gae  changed VRTX functions to use vrtx prefix.
01a,19jan88,jcf  written
*/

/*
DESCRIPTION
This library provides a generic interface to VRTX kernel time management.
This includes:

    - announce a timer tick to VRTX,
    - get the current time in ticks,
    - set the current time in ticks.

SEE ALSO: "Architecture", taskLib (1), kernelLib (1)
*/

/* LINTLIBRARY */

#include "vxWorks.h"

IMPORT ULONG vrtxGTime ();


/*******************************************************************************
*
* tickAnnounce - annouce a clock tick to VRTX
*
* This routine is used to inform VRTX of the passing of time.
* It should be called from an interrupt service routine that is
* connected to the system clock.
*
* SEE ALSO: vrtxTimer (2)
*/

VOID tickAnnounce ()

    {
    vrtxTimer ();
    }
/*******************************************************************************
*
* tickSet - set value of VRTX's tick counter
*
* SEE ALSO: tickGet (2), vrtxStime (2)
*/

VOID tickSet (ticks)
    ULONG ticks;	/* new time in ticks */

    {
    vrtxStime (ticks);
    }
/*******************************************************************************
*
* tickGet - get value of VRTX's tick counter
*
* RETURNS: value of the VRTX clock
*
* SEE ALSO: tickSet (2), vrtxGtime (2)
*/

ULONG tickGet ()

    {
    return (vrtxGtime());
    }
