/* auth_none.c -  client authentication for remote systems */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (C) 1984, Sun Microsystems, Inc. 
 *
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
modification history
--------------------
01c,19apr89,gae   added auth_noneExit to do tidy cleanup of tasks.
		  changed auth_noneInit to return pointer to moduleStatics.
01b,11nov87,jlf   added wrs copyright, title, mod history, etc.
01a,01nov87,rdc   first VxWorks version
*/

/*
 * auth_none.c
 * Creates a client authentication handle for passing "null" 
 * credentials and verifiers to remote systems. 
 * 
 * Copyright (C) 1984, Sun Microsystems, Inc. 
 */

#include "rpctypes.h"
#include "xdr.h"
#include "auth.h"
#include "vxWorks.h"
#include "memLib.h"
#include "rpcGbl.h"

/* XXX #define NULL ((caddr_t)0) */
#define MAX_MARSHEL_SIZE 20

/*
 * Authenticator operations routines
 */
void	authnone_verf();
void	authnone_destroy();
bool_t	authnone_marshal();
bool_t	authnone_validate();
bool_t	authnone_refresh();

static struct auth_ops ops = {
	authnone_verf,
	authnone_marshal,
	authnone_validate,
	authnone_refresh,
	authnone_destroy
};

struct moduleStatics 
    {
    AUTH no_client;
    char marshalled_client[MAX_MARSHEL_SIZE];
    u_int mcnt;
    };

struct moduleStatics *auth_noneInit ()

    {
    struct moduleStatics *pAuth_none;

    pAuth_none = (struct moduleStatics *)
		    calloc (1, sizeof (struct moduleStatics)); 

    if (pAuth_none == NULL)
	printErr ("auth_noneInit: out of memory!\n");
    
    return (pAuth_none);
    }

VOID auth_noneExit (pAuth_none)
    struct moduleStatics *pAuth_none;

    {
    if (pAuth_none != NULL)
	{
	free ((char *)pAuth_none);
	}
    }

AUTH *
authnone_create()
{
	XDR xdr_stream;
	register XDR *xdrs;
	FAST struct moduleStatics *ms = taskModuleList->auth_none;

	if (! ms->mcnt) {
		ms->no_client.ah_cred = ms->no_client.ah_verf = _null_auth;
		ms->no_client.ah_ops = &ops;
		xdrs = &xdr_stream;
		xdrmem_create(xdrs, ms->marshalled_client, 
		    (u_int)MAX_MARSHEL_SIZE, XDR_ENCODE);
		(void)xdr_opaque_auth(xdrs, &ms->no_client.ah_cred);
		(void)xdr_opaque_auth(xdrs, &ms->no_client.ah_verf);
		ms->mcnt = XDR_GETPOS(xdrs);
		XDR_DESTROY(xdrs);
	}
	return (&ms->no_client);
}

/*ARGSUSED*/
bool_t
authnone_marshal(client, xdrs)
	AUTH *client;
	XDR *xdrs;
{
	FAST struct moduleStatics *ms = taskModuleList->auth_none;

	return ((*xdrs->x_ops->x_putbytes)(xdrs, ms->marshalled_client, 
					   ms->mcnt));
}

void 
authnone_verf()
{
}

bool_t
authnone_validate()
{

	return (TRUE);
}

bool_t
authnone_refresh()
{

	return (FALSE);
}

void
authnone_destroy()
{
}
