/* pic_ex.c - jumpering of EXOS 202 / 302 */

/*
modification history
--------------------
01d,22jul88,gae  lint.
01c,25jun88,gae  merged with old excelan and added EXOS 302.
   		 added bitflip to reverse bits in an int.
01b,04apr88,gae  removed calls to getBoard() and printPic().
01a,07nov87,jcf  written.
*/

/*
This module contains the jumpering of the EXOS 202, both old and new,
and the EXOS 302.
*/

#include <stdio.h>

#include "vxWorks.h"
#include "picture.h"


/*******************************************************************************
*
* drawEx - draw EXOS 202 / 302 jumper config
*/

VOID drawEx (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    char input [90];
    int n = NONE;

    if (interactive)
	{
	printf (
	 "Which Excelan board (0=old EXOS 202, 1=new EXOS 202, 2=EXOS 302)?");

	if (gets (input) == NULL)
	    return;

	sscanf (input, "%d", &n);

	switch (n)
	    {
	    case 0:
		drawEx202Old (pic);
		break;
	    case 1:
		drawEx202New (pic);
		break;
	    case 2:
		drawEx302 (pic);
		break;
	    }
	}
    else
	{
	/* XXX need to do them all but must return after each? */
	drawEx202New (pic);
	}

    if (!inc_ex)
	printf ("Warning: Excellan not included.\n");
    }
/*******************************************************************************
*
* drawEx302 - draw exos 302 jumper config
*/

LOCAL VOID drawEx302 (pic)
    char *pic;

    {
    int io_adrs = 0;
    int int_lvl = 0;

    printAt (pic, 35, 1, "EXOS 302");

    /* I/O address:
     * ignore bottom 16 bits, move bits flipped to top down,
     * 16 settable bits.
     * We use 24 bit addressing so 24-31 don't care.
     */

    io_adrs = (bitflip ((~ex_io) >> 16) >> 16) & 0xff00;

    jumperAt (pic, 41, 3, 16, HORIZONTAL, VERTICAL, io_adrs);
    printAt (pic, 41, 4, " IO ADRS");

    /* int level */
    int_lvl = (0x1 << (il_ex - 1));
    jumperAt (pic, 21, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 21, 4, "INT LVL");

    /* int ack */
    jumperAt (pic, 16, 3, 3, HORIZONTAL, VERTICAL, il_ex); 
    printAt (pic, 12, 4, "INT ACK");
    }
/*******************************************************************************
*
* drawEx202New - draw new exos 202 jumper config
*/

LOCAL VOID drawEx202New (pic)
    char *pic;

    {
    int io_adrs = 0;
    int int_lvl = 0;

    printAt (pic, 33, 1, "EXOS 202 NEW");

    /* I/O address:
     * ignore bottom 16 bits, move bits flipped to top down,
     * only 8 settable bits.
     */

    io_adrs = bitflip ((~ex_io) >> 16) >> 24;

    jumperAt (pic, 21, 3, 8, HORIZONTAL, VERTICAL, io_adrs);
    printAt (pic, 21, 4, " IO ADRS");

    /* int level */
    int_lvl = (0x1 << (il_ex - 1));
    jumperAt (pic, 31, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 31, 4, "INT LVL");

    /* int ack */
    jumperAt (pic, 4, 16, 3, HORIZONTAL, HORIZONTAL, ~il_ex); 
    printAt (pic, 4, 18, "INT ACK");

    /* MISC */
    jumperAt (pic, 3, 3, 6, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic,  3, 4, "BGIN");
    printAt (pic,  10, 3, "UUUD");
    printAt (pic,  10, 4, "BGOT");
    jumperAt (pic, 15, 3, 4, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic,  15, 4, "BREQ");
    }
/*******************************************************************************
*
* drawEx202Old - draw old exos 202 jumper config
*/

LOCAL VOID drawEx202Old (pic)
    char *pic;

    {
    int i;
    int io_adrs = 0;
    int int_lvl = 0;
    int tmp = 0;

    printAt (pic, 33, 1, "EXOS 202 OLD");
    printAt (pic, 46, 0, "                              ");
    printAt (pic, 46, 1, "            NO P2!            ");
    printAt (pic, 31, 2, "|___________________________________________");

    /* I/O address */

    tmp = ~(ex_io >> 16);
    for (i = 0; i < 8; i++)
	{
	io_adrs = io_adrs << 1;
	io_adrs |= (tmp >> i) & 0x1;
	}
    jumperAt (pic, 15, 3, 8, HORIZONTAL, VERTICAL, io_adrs);
    printAt (pic, 15, 4, " IO ADRS");

    /* int level */
    int_lvl = (0x1 << (il_ex - 1));
    jumperAt (pic, 23, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 24, 4, "INT LVL");

    /* int ack */
    jumperAt (pic, 38, 16, 2, VERTICAL, VERTICAL,
	      ((((~il_ex) & 1) << 1) | (((~il_ex) & 4)>>2)));
    jumperAt (pic, 37, 15, 1, HORIZONTAL, HORIZONTAL,
	      (((~il_ex) & 2) >> 1));
    printAt (pic, 40, 16, "INT ACK");

    /* MISC */
    jumperAt (pic, 3, 3, 4, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic,  3, 4, "BGIN");
    printAt (pic,  7, 3, "DDDU");
    printAt (pic,  7, 4, "BGOT");
    jumperAt (pic, 11, 3, 4, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic,  11, 4, "BREQ");
    }
/*******************************************************************************
*
* bitflip - reverse bit pattern
*/

LOCAL int bitflip (value)
    unsigned int value;

    {
    int ix;
    int tmp = 0;

    for (ix = 0; ix < 32; ix++)
	{
	tmp <<= 1;
	tmp |= value & 1;
	value >>= 1;
	}

    return (tmp);
    }
