/* pic_enp.c - jumpering of CMC ENP-10 board */

/*
modification history
--------------------
01h,03nov88,shl  clarified hkv2f jumpers.
01g,28oct88,gae  oops in 01f.
01f,28oct88,gae  added JP7 + JP13 for HK68/V2F problems.
01e,08aug88,gae  added PROMs; changed 'e' to 'l'.
01d,12jul88,gae  added ENP-10/e board.
		 added Ethernet 1.0 compliance but ifdef'd out.
01c,04apr88,gae  removed calls to getBoard() & printPic().
01b,20feb88,dnw  lint
01a,17feb88,jcf  created
*/

/*
This module contains the jumpering of the CMC ENP-10 and ENP-10/L.

The ENP-10 board must contain LINK10 PROMs (version 3.1 or so).
The PROMs are the same (according to CMC) for both boards.

The new ENP-10/L comes with LLD (Link Level Driver) PROMs but
are not backward compatible.
*/

#include <stdio.h>

#include "vxWorks.h"
#include "picture.h"


/*******************************************************************************
*
* drawEnp - draw ENP-10 or ENP-10/L jumper config
*/

VOID drawEnp (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    char input [90];
    int n = NONE;

    if (interactive)
	{
	printf ("Which ENP-10 board (0=ENP-10, 1=ENP-10/L)?");

	if (gets (input) == NULL)
	    return;

	sscanf (input, "%d", &n);

	switch (n)
	    {
	    case 0:
		drawEnp10 (pic);
		break;
	    case 1:
		drawEnp10L (pic);
		break;
	    }
	}
    else
	{
	/* XXX need to do them both but must return after each? */
	drawEnp10 (pic);
	}

    if (!inc_enp)
	printf ("Warning: ENP-10 not included.\n");
    }
/*******************************************************************************
*
* drawEnp10 - draw ENP-10 jumper config
*/

VOID drawEnp10 (pic)
    char *pic;

    {
    int io_adrs;
    int int_lvl;

    printAt (pic, 36, 1, "ENP-10");

    /* I/O address */

    io_adrs = ~(enp_io >> 17);
    jumperAt (pic, 6, 13, 7, VERTICAL, HORIZONTAL, io_adrs);
    printAt (pic, 8, 14, "IO ADRS");

    /* int level */
    int_lvl = (0x1 << (il_enp - 1));
    jumperAt (pic, 22, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 22, 4, "INT LVL");

    /* int ack */
    if (il_enp & 0x1)
	printAt (pic, 45, 3, "L");
    else
	printAt (pic, 45, 3, "R");
    if (il_enp & 0x2)
	printAt (pic, 45, 4, "L");
    else
	printAt (pic, 45, 4, "R");
    if (il_enp & 0x4)
	printAt (pic, 45, 5, "L");
    else
	printAt (pic, 45, 5, "R");

    printAt (pic,  47, 4, "INT ACK");

    printAt (pic, 50, 15, " -------  ------- ");
    printAt (pic, 50, 16, "|  ROM  ||  ROM  |");
    printAt (pic, 50, 17, "|LINK-10||LINK-10|");
    printAt (pic, 50, 18, "|       ||       |");
    printAt (pic, 50, 19, "| HIGH  ||  LOW  |");
    printAt (pic, 50, 20, "|  U4   ||  U3   |");
    printAt (pic, 50, 21, " ---^---  ---^--- ");
   
    /* miscellaneous */

#ifdef	ENET_1_0
    /* Ethernet type 1.0 */

    jumperAt (pic, 74, 7, 1, VERTICAL, HORIZONTAL, 0x1);
    printAt (pic,  65, 7, "ENET 1.0");
    printAt (pic,  65, 8, "(rev. d)");

    /* DIP-16 */

    jumperAt (pic, 74, 13, 8, VERTICAL, HORIZONTAL, 0xff);
    printAt (pic, 70, 14, "DIP");
#endif	ENET_1_0
    }
/*******************************************************************************
*
* drawEnp10L - draw ENP-10/L jumper config
*/

VOID drawEnp10L (pic)
    char *pic;

    {
    int io_adrs;
    int int_lvl;

    printAt (pic, 34, 1, "ENP-10/L");

    printAt (pic, 6, 2, "JP17");
    printAt (pic, 6, 3, "X:XX=_:");

    /* I/O address (JP16) */
    io_adrs = ~(enp_io >> 17);
    printAt (pic, 14, 2, "JP16");
    jumperAt (pic, 14, 3, 7, HORIZONTAL, VERTICAL, io_adrs);
    printAt (pic, 14, 4, "IO ADRS");

    /* int level (JP15) */
    int_lvl = (0x1 << (il_enp - 1));
    printAt (pic, 22, 2, "JP15");
    jumperAt (pic, 22, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 22, 4, "INT LVL");

    /* int ack (JP11) */
    /* OUT = 1 and IN = 0; also bits are upside down */
    jumperAt (pic, 5, 12, 3, VERTICAL, HORIZONTAL, bitflip (~il_enp) >> 29);
    printAt (pic, 7, 13, "INT ACK");
    printAt (pic, 7, 14, "JP11");

    /* VME SYSCLOCK (JP7) */
    /* 3-2 JOINED = NO VME SYSTEM CLOCK, 2-1 USE VME SYSTEM CLOCK */
    /* default is to use VME system clock */
    printAt (pic, 15, 16, "_. JP7 SYSCLOCK");
    
    printAt (pic, 15, 17, "._ JP7 SYSCLOCK*");
    
    /* INTERNAL VMEbus RESOURCE TIMEOUT DISABLE (JP13) */
    /* OUT = disable and IN = enable; default is disabled */
    printAt (pic, 45,  12, "_ JP13 TIMEOUT");

    printAt (pic, 45,  13, "\" JP13 TIMEOUT*");

    printAt (pic, 50, 21, "[*] HK68/V2F settings");

    /* XXX one day should be LLD */

    printAt (pic, 62,  2, " ---------- ");
    printAt (pic, 62,  3, "|  ROM     |");
    printAt (pic, 62,  4, "> LINK-10  |");
    printAt (pic, 62,  5, "|  LOW  U63|");
    printAt (pic, 62,  6, " ========== ");
    printAt (pic, 62,  7, "|  ROM     |");
    printAt (pic, 62,  8, "> LINK-10  |");
    printAt (pic, 62,  9, "|  HIGH U62|");
    printAt (pic, 62, 10, " ---------- ");
   
    /* miscellaneous */

#ifdef	ENET_1_0

    /* Ethernet type 1.0 */

    jumperAt (pic, 66, 18, 2, VERTICAL, HORIZONTAL, 0x2);
    printAt (pic,  68, 18, "ENET 1.0");

    /* DIP-16 */

    jumperAt (pic, 64, 14, 8, VERTICAL, HORIZONTAL, 0xff);
    printAt (pic,  59, 15, "DIP");
#endif	ENET_1_0
    }
/*******************************************************************************
*
* bitflip - reverse bit pattern
*/

LOCAL int bitflip (value)
    int value;

    {
    int ix;
    int tmp = 0;

    for (ix = 0; ix < 32; ix++)
	{
	tmp <<= 1;
	tmp |= value & 1;
	value >>= 1;
	}

    return (tmp);
    }
