/* pic_dram512.c - jumpering of the dram 512 shared memory board */

/*
modification history
--------------------
01b,04apr88,gae  removed calls to getBoard() & printPic().
01a,07nov87,jcf  written.
*/

/*
This module contains the jumpering of the dram 512 shared memory board.
*/

#include "vxWorks.h"
#include "picture.h"


/*******************************************************************************
*
* drawDram512 - draw shared memory board
*/

VOID drawDram512 (pic)
    char *pic;

    {
    static int block [] = {4, 5, 7, 9, 10, 8, 10, 12, 14, 15, 13, 11, 9};
    int io_adrs;
    int ix;

    printAt (pic, 33, 1, "DRAM-512 MEM");
    if (bp_io == NONE)
	{
	bp_io = 0x800000;
	printf ("Warning shared memory address not defined, using 0x800000.\n");
	}

    /* io address */
    jumperAt (pic, 10, 4, 7, VERTICAL, HORIZONTAL, 0x7f);
    jumperAt (pic, 50, 8, 8, VERTICAL, HORIZONTAL, 0xff);

    io_adrs = (bp_io & 0xffffff) >> 18;

    for (ix = 0; ix < 5; ix++)
	if ((io_adrs = io_adrs >> 1) & 1)
	    jumperAt (pic, 10, block[ix], 1, VERTICAL, HORIZONTAL, 0x0);

    for (; ix < 13; ix++)
	if ((io_adrs = io_adrs >> 1) & 1)
	    jumperAt (pic, 50, block[ix], 1, VERTICAL, HORIZONTAL, 0x0);
    }
