#define DB      {logMsg("%s: %d\n", __FILE__,__LINE__);}
#define	NVB	1

/*
 * Integrated Solutions VME bus interprocessor communications driver
 *  (an ethernet driver without the coax)
 */

#include "param.h"
#include "mbuf.h"
#include "protosw.h"
#include "ioctl.h"
#include "socket.h"
#include "errno.h"
#include "uio.h"
#include "if.h"
#include "route.h"
#include "in.h"
#include "in_systm.h"
#include "in_var.h"
#include "ip.h"
#include "ip_var.h"
#include "if_ether.h"
#include "vxWorks.h"
#include "sysLib.h"
#include "wdLib.h"
#include "etherLib.h"
#include "if_ring.h"

/*#define	VBDEBUG	1	/* */
/*#define	VBDEBUG1	1	/* */
/*#define	VBINTDEBUG	1	/* */

#define	BCBBUFSIZ	((8 * 1024) + 128 + 64)

int vbnum;

int     vbprobe(), vbattach(), vbintr(), vbslave();

int     vbinit(),vbioctl(),vboutput(),vbreset(), vbread (), ipintr ();
int     ringput ();

struct  mbuf *vbget();
extern  struct ifnet loif;

/* address space where the CPU board can be interrupted
 * this uses the upper two bits of ic_intrinfo 
 */
#define SPACE_SHORT		0x00000000	/* usual ISI boards */
#define SPACE_STANDARD		0x40000000	/* Eltec E5 */
#define SPACE_EXTENDED		0x80000000
#define SPACE_NONE		0xc0000000
#define SPACE_MASK		0xc0000000

#define	NCPU	9	/* number of input rings to initialize */
#define	MAXCPU	32	/* known elsewhere -- don't change! */

#define MAXTRIES	10000
#define VBSIZE0		0x40000
struct	icpu {
	unsigned char		ic_active[MAXCPU];
/*	unsigned char		ic_tickle; /**/
	short			ic_ncpu;
	u_char			ic_ethaddr[6];
	struct ring		*ic_freeringp;
	struct ring		*ic_inputringp[MAXCPU];
	unsigned short		*ic_intrinfo[MAXCPU];
};
#define	ICPUX(p) (((struct ether_header *)(p))->ether_dhost[5])

extern char vme_ext[];
extern char vme_std[];
extern char vme_short[];

#define INTR_SHORT(p) *((u_short *)&vme_short[(int)p & ~SPACE_MASK]) = zero;
#define INTR_STD(p) *((u_short *)&vme_std[(int)p & ~SPACE_MASK]) = zero;
#define INTR_EXT(p) *((u_short *)&vme_ext[(int)p & ~SPACE_MASK]) = zero;

/* since we can't interrupt ourself, we call vbintr directly */
#define	INTR_VB(x,p)	{ \
			short zero = 0; \
			if (x == vbnum) \
			    vbintr (); \
			else \
			    if (p) { \
				switch ((int)p & SPACE_MASK) { \
				case SPACE_SHORT: \
				    INTR_SHORT(p); \
				    break; \
				case SPACE_STANDARD: \
				    INTR_STD(p); \
				    break; \
				case SPACE_EXTENDED: \
				    INTR_EXT(p); \
				    break; \
				case SPACE_NONE: \
				    break; \
				} \
			    } \
			}

#define	ItoKval(p,type,base)	((type)((unsigned)(p) + (unsigned)(base)))
#define	KtoIval(p,type,base)	((type)((unsigned)(p) - (unsigned)(base)))
#define	ItoK(p,type,base)	((p) = ItoKval(p,type,base))
#define	KtoI(p,type,base)	((p) = KtoIval(p,type,base))

u_short *VBstd[] = {
	(u_short *) &vme_std[0xf00000],
	0};

u_short *vb_std[] = {
	(u_short *) &vme_std[0],
	0};

/*
 * The following structure is initialized by cluster 0
 * for host resident shared memory.
 * It resides at LOC 0 & 4 of the cluster 0 memory.
 */
struct hmmagic {
	u_int   hm_base;                /* pointer to hm communication area */
	u_int   hm_magic;               /* magic number */
};
#define HMMAGIC 0xDEADBEEF

/* what target type are we
 */
int targetType;

/*
 * Net software status per interface.
 *
 * Each interface is referenced by a network interface structure,
 * vs_if, which the routing code uses to locate the interface.
 * This structure contains the output queue for the interface, its address, ...
 */
struct  vb_softc {
	struct		arpcom vs_ac;	/* common ethernet structures */
	int		vs_size;
	unsigned char	vs_state;
	struct icpu	*vs_icpup;
	struct ring	*vs_freeringp;
	struct ring	*vs_inputringp;
} vb_softc[NVB];
#define vs_if           vs_ac.ac_if     /* network-visible interface */
#define vs_enaddr       vs_ac.ac_enaddr /* hardware ethernet address */

#define	MINPKTSIZE	60

/*
 * Probe for device.
 */

vbprobe(reg, unit, memsize)
  caddr_t reg;
  int unit;
  int memsize;
  {
	register int i;
	struct vb_softc *vs = &vb_softc[unit];

#ifdef VBDEBUG1
	logMsg ("vbprobe(0x%x, %d, 0x%x)\n",reg,unit,memsize);
#endif VBDEBUG1
	vs->vs_icpup = (struct icpu *)reg;

	for (i = 0;  i < memsize;  i += 4096, reg += 4096) {
		int dummy1, dummy2;

		/* readable ? 
		 */
		if (vxMemProbe (reg, READ, sizeof(int), &dummy1) == -1) break;

		/* writeable ? 
		 */
		if (vxMemProbe (reg, WRITE, sizeof(int), &dummy1) == -1) break;

		/* same value ? 
		 */
		dummy2 = *(int *)reg;
		if (dummy2 != dummy1) break;
	}
	/*
	 * Return the amount of memory we found.
	 */
#ifdef	VBDEBUG1
	logMsg("vbprobe, size=0x%x\n",i);
#endif	VBDEBUG1
	return vs->vs_size = i;
  }

vbslave()
  {
#ifdef	VBDEBUG
	logMsg ("vbslave\n");
#endif	VBDEBUG
	return 1;
  }

/*
 * Interface exists: make available by filling in network interface
 * record.  System will initialize the interface when it is ready
 * to accept packets. 
 */
STATUS vbattach (unit, procNum, memsize)
    int unit;
    int procNum;
  {
    	caddr_t mem;
	struct vb_softc *vs = &vb_softc[unit];
	register struct ifnet *ifp = &vs->vs_if;
	int icpux, i;
	struct hmmagic *hmp;
	extern int sysCpu;

	vbnum = procNum;	/* set our proc num */
	vbSetTargetType();

#ifdef	VBDEBUG
	logMsg("vbattach unit = %d, procNum = %d\n", unit, procNum);
#endif	VBDEBUG

	/* check for existence of shared memory */

	mem = (char *) VBstd[unit];
	if (vbprobe (mem, unit, memsize) == 0) {

	    /* if this is cpu 0, then if it is a 68030,
	     * initialize local memory as shared memory,
	     * using extended addressing to emulate shared 
	     * memory.  if it is not a 68030, return error
	     * because we cannot communicate.
	     */

	    if (!vbnum) {
		if ((targetType == TARGET_68K30) || (targetType == TARGET_E5)) {
		    logMsg ("vb: initializing local message area\n");
		    mem = (char *) malloc (VBSIZE0);
		    if (mem == (char *)0) {
			logMsg ("vb: could not allocate local message area\n");
			free (mem);
			return (ERROR);
		    }
		    if (targetType == TARGET_68K30 && ((int)mem < 0x400000)) {
			logMsg ("vb: message area too low, 0x%x\n", mem);
			free (mem);
			return (ERROR);
		    }
		    if (targetType == TARGET_E5 && ((int)mem > 0x400000)) {
			logMsg ("vb: message area too high, 0x%x\n", mem);
			free (mem);
			return (ERROR);
		    }
		    vb_softc[unit].vs_icpup = (struct icpu *)mem;
		    vb_softc[unit].vs_size = VBSIZE0;
		    hmp = (struct hmmagic *)0;
		    hmp->hm_base = (u_int) vb_softc[unit].vs_icpup;
		    hmp->hm_magic = HMMAGIC;
		}
		else 
		    return (ERROR);
	    }

	    /* if this is not cpu 0, then probe standard 
	     * address 4 for the magic number, since the
	     * message area may be located in 68030 or Eagle-5 
	     * local memory
	     */

	    else {
		hmp = (struct hmmagic *)vb_std[unit];
		/* return if server cannot be accessed */
		if (vxMemProbe (&hmp->hm_magic, READ, sizeof (u_int), &i)
		    != OK) {
			logMsg ("vb: no server\n");
			return (ERROR);
		}

		/* check magic number repeatedly 
		 */
		for (i = 0; i < MAXTRIES; i++) {
		    if (hmp->hm_magic == HMMAGIC)
			break;
		    taskDelay (1);
		}
		if (i == MAXTRIES) {
		    logMsg ("vb: server at 0x%x not ready\n", &hmp->hm_magic);
		    return (ERROR);
		}

		/* if not an eagle board, use extended addressing
		 */
		if (targetType != TARGET_E5)
		    vs->vs_icpup = (struct icpu *)
			((u_long)(&vme_ext[0])+(u_long)(hmp->hm_base));

		/* if an eagle board, use extended addressing if the
		 * offset > 4 Mb, otherwise use standard addressing
		 */
		else {
		    if ((u_long)hmp->hm_base < (u_long)sysMemTop())
			vs->vs_icpup = (struct icpu *)
			    ((u_long)(&vme_std[0])+(u_long)(hmp->hm_base));
		    else
			vs->vs_icpup = (struct icpu *)
			    ((u_long)(&vme_ext[0])+(u_long)(hmp->hm_base));
		}
	    }
	}
	else
	    logMsg ("vb: using shared memory board\n");

	/* zero out the interface structure */

	bzero ((char *) ifp, sizeof (*ifp));

	if ((icpux = vbconnect(unit)) < 0)
		return (ERROR);
	sysIpiConnect (vbintr, 0);
	i = intLock ();
	vs->vs_freeringp = vs->vs_icpup->ic_freeringp;
	ItoK(vs->vs_freeringp, struct ring *, vs->vs_icpup);
	vs->vs_inputringp = vs->vs_icpup->ic_inputringp[icpux];
	ItoK(vs->vs_inputringp, struct ring *, vs->vs_icpup);
	intUnlock (i);
	vbgetaddr(unit, icpux);
	ifp->if_unit = unit;
	ifp->if_name = "vb";
	ifp->if_mtu = BCBBUFSIZ;		/* was ETHERMTU */
	ifp->if_init = vbinit;
	ifp->if_ioctl = vbioctl;
	ifp->if_output = vboutput;
	ifp->if_reset = vbreset;
	if_attach(ifp);
    	return (OK);
}

vbreboot()	/* mark a vb inactive; called from reboot and panic */

    {
    register struct vb_softc *vs = vb_softc;
    register struct bcb *bcbp;

#ifdef VBDEBUG
	logMsg ("vbreboot\n");
#endif VBDEBUG
    if (vbnum)
	{
	if ( vs->vs_icpup )
	    {
	    vs->vs_icpup->ic_active[vbnum] = 0;
	    if (vs->vs_inputringp)
		while(bcbp = (struct bcb *)ringget(vs->vs_inputringp))
		    ringput(vs->vs_freeringp, (int) bcbp);
	    }
	}
    }

/*
 * Reset of interface after completion of initialization or bus reset.
 *
 * ARGSUSED
 */

vbreset(unit)
    int unit;

    {
#ifdef VBDEBUG
	logMsg ("vbreset\n");
#endif VBDEBUG
    vbreboot ();
    }

/*
 * Initialization of interface: clear pending operations.
 */
vbinit(unit)
  int unit;
  {
	struct vb_softc *vs = &vb_softc[unit];

#ifdef VBDEBUG
	logMsg ("vbinit\n");
#endif VBDEBUG
	if ((vs->vs_if.if_flags & IFF_RUNNING) == 0)
		vs->vs_if.if_flags |= IFF_UP | IFF_RUNNING;

	sysIpiConnect (vbintr, 0);
	return 0;
}

#ifdef VBINTDEBUG
int vbintrflag = 1;
#endif VBINTDEBUG
/*
 * Interface interrupt.
 */
vbintr()
  {
	register int unit;
	register struct vb_softc *vs = vb_softc;
	
#ifdef VBINTDEBUG
	if (vbintrflag && intContext())
	    logMsg ("vbintr!!\n");
#endif VBINTDEBUG
	for (unit = 0;  unit < NVB;  unit += 1, vs += 1) {
		register struct bcb *bcbp;

		if (vs->vs_inputringp == NULL)
			continue;
/*		if ((vs->vs_if.if_flags & IFF_UP) == 0)	/* */
/*			continue;			/* */
		if (!vbnum)
		    sysDataCacheFlush ();
		while(bcbp = (struct bcb *)ringget(vs->vs_inputringp)) {
			ItoK(bcbp, struct bcb *, vs->vs_icpup);
			netJobAdd (vbread, vs, bcbp);
			KtoI(bcbp, struct bcb *, vs->vs_icpup);
			netJobAdd (ringput, vs->vs_freeringp, (int) bcbp);
		}
	}
}

vbread(vs, bcbp)
  struct vb_softc *vs;
  register struct bcb *bcbp;
  {
	register struct ether_header *eh;
	struct mbuf *m;
	int len, off, resid;
	register struct ifqueue *inq;
	unsigned char *bp;

#ifdef VBDEBUG
	logMsg ("vbread\n");
#endif VBDEBUG
	vs->vs_if.if_ipackets++;

	/* Get ptr to ethernet header, ptr to data, and input data length */

	eh  = ItoKval (bcbp->b_addr, struct ether_header *, vs->vs_icpup);
	bp  = ((unsigned char *) eh) + sizeof (struct ether_header);
	len = bcbp->b_len - sizeof (struct ether_header);


	/* call input hook if any */

	if ((etherInputHookRtn != NULL) &&
	    (* etherInputHookRtn) (&vs->vs_if, (char *) eh, bcbp->b_len))
		return (0);	/* input hook has already processed packet */


	/* Deal with trailer protocol: if type is PUP trailer
	 * get true type from first 16-bit word past data.
	 * Remember that type was trailer by setting off.
	 */

#define vbdataaddr(vb, off, type)       ((type)(((caddr_t)((vb)+1)+(off))))

	if (eh->ether_type >= ETHERTYPE_TRAIL  &&
	    eh->ether_type < ETHERTYPE_TRAIL+ETHERTYPE_NTRAILER) {
		off = (eh->ether_type - ETHERTYPE_TRAIL) * 512;
		if (off >= BCBBUFSIZ)
			return 0;	/* sanity */
		eh->ether_type = *vbdataaddr(eh, off, u_short *);
		resid          = *(vbdataaddr(eh, off+2, u_short *));

		if (off + resid > len)
			return 0;	/* sanity */
		len = off + resid;
	} else
		off = 0;

	if (len == 0)
		return 0;




	/*
	 * Pull packet off interface.  Off is nonzero if packet
	 * has trailing header; vbget will then force this header
	 * information to be at the front, but we still have to drop
	 * the type and length which are at the front of any trailer data.
	 */

	m = vbget (bp, len, off, &vs->vs_if);
	if (m == 0)
		return 0;

	if (off) {
		struct ifnet *ifp;

		ifp = *(mtod(m, struct ifnet **));
		m->m_off += 2 * sizeof (u_short);
		m->m_len -= 2 * sizeof (u_short);
		*(mtod(m, struct ifnet **)) = ifp;
	}

	switch (eh->ether_type) {
#ifdef INET
	  case ETHERTYPE_IP:
		netJobAdd (ipintr);
		inq = &ipintrq;
		break;
	  case ETHERTYPE_ARP:
		arpinput(&vs->vs_ac, m);
		return 0;
#endif
	  default:
		m_freem(m);
		return 0;
	}

	{
	int s = splnet ();

	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
		splx (s);
		return 0;
	}
	IF_ENQUEUE(inq, m);
	splx (s);
	}

	return 0;
}

/*
 * Net output routine.
 * Encapsulate a packet of type family for the local net.
 * Use trailer local net encapsulation if enough data in first
 * packet leaves a multiple of 512 bytes of data in remainder.
 */
vboutput(ifp, m0, dst)
  struct ifnet *ifp;
  struct mbuf *m0;
  struct sockaddr *dst;
  {
	register struct vb_softc *vs = &vb_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *vb;
	register int off;
	int type, error;
	u_char edst[6];
	int usetrailers;
	struct in_addr idst;

#ifdef VBDEBUG
	logMsg ("vboutput\n");
#endif VBDEBUG
/*	if ((vs->vs_if.if_flags & IFF_UP) == 0) {	/* not ready yet */
/*		m_freem(m0);				/* */
/*		return 0;				/* */
/*	}						/* */
	switch( dst->sa_family ) {
#ifdef INET
	  case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&vs->vs_ac, m, &idst, edst, &usetrailers))
			return ( 0 );     /* if not yet resolved */

		off = ((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		if (usetrailers && off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof(u_short)) {
			type = ETHERTYPE_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof(u_short);
			m->m_len += 2 * sizeof(u_short);
			*mtod(m, u_short *) = ETHERTYPE_IP;
			*(mtod(m, u_short *) + 1) = m->m_len;
			goto gottrailertype;
		}
		type = ETHERTYPE_IP;
		off = 0;
		goto gottype;
#endif
	  case AF_IMPLINK:
		/* should do some ARP here? */
		vb = mtod(m, struct ether_header *);
		goto gotheader;
	  case AF_UNSPEC:
		vb = (struct ether_header *)dst->sa_data;
		bcopy ((char *) vb->ether_dhost,(char *) edst, 6);
		type = vb->ether_type;
		goto gottype;
	  default:
		error = EAFNOSUPPORT;
		goto bad;
	}
  gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet
	 * (control information) to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;
  gottype:
	/*
         * Add local net header.  If no space in first mbuf,
         * allocate another.
         */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof(struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_DATA);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof(struct ether_header);
	} else {
		m->m_off -= sizeof(struct ether_header);
		m->m_len += sizeof(struct ether_header);
	}
	vb = mtod(m, struct ether_header *);
	bcopy ((char *) edst, (char *) vb->ether_dhost, 6);
	vb->ether_type = type;
  gotheader:
	bcopy ((char *) vs->vs_enaddr, (char *) vb->ether_shost, 6);

	/*
	 * Queue message on interface if possible 
	 */
	if (vbput(ifp->if_unit, m)) {
		error = ENOBUFS;
		m0 = m;
		goto bad;
	}
	vs->vs_if.if_opackets++;
	return 0;

  bad:
	m_freem(m0);
	return error;
}

/*
 * Routine to copy from mbuf chain to shared memory buffer.
 */
vbput(unit, m)
  int unit;
  struct mbuf *m;
  {
	register struct bcb *bcbp;
	register struct icpu *addr = vb_softc[unit].vs_icpup;
	register struct mbuf *mp;
	register u_char *bp;
	register unsigned len;
	register struct vb_softc *vs = &vb_softc[unit];
	register struct ether_header *eh;

#ifdef VBDEBUG
	logMsg ("vbput\n");
#endif VBDEBUG
	if ((bcbp = (struct bcb *)ringget(vb_softc[unit].vs_freeringp)) == NULL)
		return 1;
	ItoK(bcbp, struct bcb *, addr);
	bcbp->b_len = 0;
	bp = (u_char *)bcbp->b_addr;
	ItoK(bp, u_char *,  addr);
	for (mp = m; mp; mp = mp->m_next) {
		if((len = mp->m_len) == 0)
			continue;
		bcopy((caddr_t) mtod(mp, u_char *),(caddr_t) bp, len);
		bp += len;
		bcbp->b_len += len;
	}
	m_freem(m);
	bcbp->b_len = max(MINPKTSIZE, bcbp->b_len);
	bp = (u_char *)bcbp->b_addr;
	ItoK(bp, u_char *,  (int) addr);
	eh  = ItoKval (bcbp->b_addr, struct ether_header *, vs->vs_icpup);
	if (etherOutputHookRtn != NULL)
		(* etherOutputHookRtn)(&vs->vs_if, (char *) eh, bcbp->b_len);
	vbxmit(addr, bcbp, (int) ICPUX(bp));
	return 0;
}

vbxmit(addr, bcbp, x)
  register struct icpu *addr;
  register struct bcb *bcbp;
  register int x;
  {
	register struct ring *freeringp, *inputringp;

#ifdef VBDEBUG
	logMsg ("vbxmit: addr = 0x%x, bcbp = 0x%x, x = %d\n", addr, bcbp, x);
#endif VBDEBUG
	freeringp = addr->ic_freeringp;
	ItoK(freeringp, struct ring *, addr);
	if (x < 0  ||  x >= MAXCPU) {
		register u_char *bp;

		bp = (u_char *)bcbp->b_addr;
		ItoK(bp, u_char *,  addr);
		for (x = MAXCPU - 1;  x > 0;  x -= 1) {
			register struct bcb *bcbp0;
			register u_char *bp0;

			if (addr->ic_active[x] == 0  ||
			    addr->ic_inputringp[x] == NULL)
				continue;
			if ((bcbp0 = (struct bcb *)ringget(freeringp)) == NULL)
				break;
			ItoK(bcbp0, struct bcb *, addr);
			bp0 = (u_char *)bcbp0->b_addr;
			ItoK(bp0, u_char *,  addr);
			bcbp0->b_len = bcbp->b_len;
 			bcopy((caddr_t) bp, (caddr_t) bp0,
			      (unsigned) bcbp->b_len);
			KtoI(bcbp0, struct bcb *, addr);
			inputringp = addr->ic_inputringp[x];
			ItoK(inputringp, struct ring *, addr);
			if (ringput(inputringp, (int) bcbp0) == 1)
				INTR_VB(x, addr->ic_intrinfo[x]);
		}
	}
	KtoI(bcbp, struct bcb *, addr);
	inputringp = addr->ic_inputringp[x];
	ItoK(inputringp, struct ring *, addr);
	if (x > 0  &&  addr->ic_active[x] == 0)
		inputringp = freeringp;
	if (ringput(inputringp, (int) bcbp) == 1)
		{
		INTR_VB(x, addr->ic_intrinfo[x]);
		}
}

/*
 * Routine to copy from shared memory into mbufs.
 */
struct mbuf *
vbget(bp, totlen, off0, ifp)
  register unsigned char *bp;
  int totlen, off0;
  struct ifnet *ifp;
  {
	register struct mbuf *m;
	register int off = off0;
	register unsigned char *cp = bp;
	struct mbuf *top = 0;
	struct mbuf **mp = &top;
	int len;

#ifdef VBDEBUG
	logMsg ("vbget\n");
#endif VBDEBUG
	while (totlen > 0) {
		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0)
			goto bad;
		if (off) {
			len = totlen - off;
			cp = bp + off;
		} else
			len = totlen;
		m->m_off = MMINOFF;
		if (ifp) {
		    /*
		     * Leave room for ifp.
		     */
		    m->m_len = MIN(MLEN - sizeof(ifp), len);
		    m->m_off += sizeof(ifp);
		} else 
		    m->m_len = MIN(MLEN, len);

 		bcopy((caddr_t) cp, (caddr_t) mtod(m, u_char *),
		      (unsigned)m->m_len);
		cp += m->m_len;
		*mp = m;
		mp = &m->m_next;
	    if (off) {
		    /* sort of an ALGOL-W style for statement... */
		    off += m->m_len;
		    if (off == totlen) {
			    cp = bp;
			    off = 0;
			    totlen = off0;
		    }
	    } else
		    totlen -= m->m_len;
	    if (ifp) {
		    /*
		     * Prepend interface pointer to first mbuf.
		     */
		    m->m_len += sizeof(ifp);
		    m->m_off -= sizeof(ifp);
		    *(mtod(m, struct ifnet **)) = ifp;
		    ifp = (struct ifnet *)0;
	    }
	}
	return top;
bad:
	m_freem(top);
	return (struct mbuf *)0;
}

/*
 * Process an ioctl request.
 *    this can be called via the "socket" route for SIOCSIFADDR or
 *	by the cdev/inode route for SIOCSIFCCFWR/RD
 *
 */
vbioctl(ifp, cmd, data)
  register struct ifnet *ifp;
  int cmd;
  caddr_t data;
  {
	register struct ifaddr *ifa = (struct ifaddr *)data;
	int s = splimp(), error = 0;

#ifdef VBDEBUG
	logMsg ("vbioctl\n");
#endif VBDEBUG
	switch (cmd) {
	  case SIOCSIFADDR:
                ifp->if_flags |= IFF_UP;

                switch (ifa->ifa_addr.sa_family) {
#ifdef INET
		case AF_INET:
			((struct arpcom *)ifp)->ac_ipaddr =
				IA_SIN(ifa)->sin_addr;
			arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
			break;
#endif
		}
		vbinit(ifp->if_unit);
		break;
	  default:
		error = EINVAL;
	}
	splx(s);
	return error;
}


/*
 * Get the ethernet addr & put it in vb_softc.
 */
vbgetaddr(unit, x)
  int unit, x;
  {
	register struct vb_softc *vs = &vb_softc[unit];

#ifdef VBDEBUG
	logMsg ("vbgetaddr: unit = %d, x = %d\n", unit, x);
#endif VBDEBUG
	bcopy ((char *) vs->vs_icpup->ic_ethaddr, (char *) vs->vs_enaddr, 6);

	ICPUX(vs->vs_enaddr) = x;
}

#define	VB_DELAY	200000

struct bcb *
bcbinit(bcbp, addr, bufsiz)
  register struct bcb *bcbp;
  caddr_t addr;
  int bufsiz;
  {
	bcbp->b_link = (struct bcb *)0;
	bcbp->b_stat = 0;
	bcbp->b_len = bufsiz;
	bcbp->b_addr = addr;
	bcbp->b_msglen = 0;
	bcbp->b_reserved = 0;
	return bcbp;
}

int
vbconnect(unit)
  int unit;
  {
	register struct icpu *icpup = vb_softc[unit].vs_icpup;

#ifdef VBDEBUG
	logMsg ("vbconnect\n");
#endif VBDEBUG
	if (vbnum == 0)
	    return vbinitialize(unit, icpup, vb_softc[unit].vs_size);
	else
	    return vbjoin(icpup);
}

int
vbinitialize(unit, icpup, vbsize)
  int unit;
  register struct icpu *icpup;
  int vbsize;
  {
	register unsigned char *p = &icpup->ic_active[0];
	register caddr_t q;
	register struct ring *freeringp;
	register int i;
	static u_char proto_addr[6] = { 0x70, 0x01, 0x00, 0x7f, 0xff, 0x00 };

#ifdef VBDEBUG
	logMsg ("vbinitialize: unit = %d, icpup = 0x%x, vbsize = %d\n",
	    unit, icpup, vbsize);
#endif VBDEBUG
	for (i = 1;  i < MAXCPU;  i += 1) {
		p[i] = 0xFF;
		icpup->ic_inputringp[i] = (struct ring *)0;
		icpup->ic_intrinfo[i] = 0;
	}
	icpup->ic_ncpu = NCPU;
	bcopy ((char *) proto_addr, (char *) icpup->ic_ethaddr, 6);

	q = (caddr_t)&icpup[1];
#ifdef VBDEBUG
	logMsg ("end of icpup = 0x%x\n", q);
#endif VBDEBUG
	ringinit((freeringp = (struct ring *)q), 256);
	icpup->ic_freeringp = freeringp;
	KtoI(icpup->ic_freeringp, struct ring *, icpup);
	q += sizeof(struct ring256);
	for (i = 0;  i < NCPU;  i += 1) {
		ringinit((icpup->ic_inputringp[i] = (struct ring *)q), 32);
		KtoI(icpup->ic_inputringp[i], struct ring *, icpup);
		q += sizeof(struct ring32);
	}
	while (q + sizeof(struct bcb) + BCBBUFSIZ <= (caddr_t)icpup + vbsize) {
		struct bcb *bcbp = bcbinit((struct bcb *) q,
					    q + sizeof *bcbp, BCBBUFSIZ);
		KtoI(bcbp->b_addr, char *, icpup);
		KtoI(bcbp, struct bcb *, icpup);
		ringput(freeringp, (int) bcbp);
		q += sizeof(struct bcb) + BCBBUFSIZ;
	}

	for (i = 1;  i < NCPU;  i += 1)
		p[i] = 0;
	vb_softc[unit].vs_state = 0xFF;
	vbtictoc (sysClkRateGet()/60);
	icpup->ic_intrinfo[0] = (unsigned short *)intaddr(0);
#ifdef VBDEBUG
	logMsg ("ic_intrinfo[0] set to 0x%x\n", icpup->ic_intrinfo[0]);
#endif VBDEBUG
	vbnum = 0;
	return 0;
}

/*
 * Some other processor just changed vbaddr->ic_active[0] to a nonzero value.
 *  This indicates that the icpu region is either initialized or about to
 *  become initialized.  Wait for vbaddr->ic_active[0] to be 0xFF, indicating
 *  that initialization is complete.  Then find and claim an available ring.
 *  Returns processor ring index, or -1.
 */
int
vbjoin(icpup)
  register struct icpu *icpup;
  {
	register unsigned char *p = &icpup->ic_active[0];
	register int i;


#ifdef VBDEBUG
	logMsg ("joining at 0x%x\n", icpup);
#endif VBDEBUG
	for (i = VB_DELAY;  i >= 0;  i -= 1) {
		if (*p == 0xFF) {
			if ((i = vbnum) > 0) {
				if (icpup->ic_inputringp[i]) {
					sysBusTas ((char *)&p[i]);
			    icpup->ic_intrinfo[i] = (unsigned short *)intaddr(i);
					return i;
				}
				return -1;
			}
			for (i = 1;  i < MAXCPU;  i++)
				if (icpup->ic_inputringp[i] &&
				    sysBusTas ((char *)&p[i])) {
			    icpup->ic_intrinfo[i] = (unsigned short *)intaddr(i);
					return i;
				}
			return -1;	/* no ring available */
		}
	}
	return -1;	/* didn't get initialized */
}

/*
 * vbtictoc -- called every tic-th clock interrupt.
 *  For each active icpu, sets ic_active[0] to vs_state.
 *  This routine is executed by the major processor only,
 *  and is used to allow other processors to detect that the
 *  corresponding icpu region has been initialized.
 */
vbtictoc(tic)
  register int tic;
  {
	register struct vb_softc *vs;
	static WDOG_ID myWatchDog;

	if (myWatchDog == (WDOG_ID) NULL)
	    myWatchDog = wdCreate ();

	for (vs = vb_softc;  vs < &vb_softc[NVB];  vs += 1)
		if (vs->vs_icpup)
			vs->vs_icpup->ic_active[0] = vs->vs_state;
	wdStart (myWatchDog, tic, vbtictoc, tic);
}

#ifdef	VBDEBUG
int	vbpolldelay=0;
#endif	VBDEBUG

vbPoll ()
    {
    while(1) {
	vbintr ();
	taskDelay (1);
#ifdef	VBDEBUG
	if(vbpolldelay)
	    taskDelay(vbpolldelay);
#endif	VBDEBUG
        }
    }

/* get the interprocessor mailbox interrupt location of
 * cpu 
 */
intaddr (cpu)
int cpu;
{
    extern int sysCommType;
    int addr, space;

    switch (sysCommType) {
    case USE_IPI:
    case USE_BOTH:
	switch (targetType) {
	case TARGET_68K30:
	case TARGET_68K20:
	case TARGET_68225:
	    addr = 0xC000 + 0x20 +(2 * cpu);
	    addr |= SPACE_SHORT;
	    break;
	case TARGET_E5:
	    addr = 0x400 + (cpu * 0x00400000);
	    addr |= SPACE_STANDARD;
	    break;
	default:
	    addr = 0;
	    break;
	}
	break;
    case USE_POLL:
    default:
	addr = 0;
	break;
    }
#ifdef VBDEBUG
    logMsg ("intaddr %d returning 0x%x\n", cpu, addr);
#endif VBDEBUG
    return addr;
}

#define match(a,b) (!strcmp(a,b))
/* figure out what target type we are
 */
vbSetTargetType()
{
    char *type;

    type = (char *)sysModel();

    if (match(type, "ISI 68020"))
	targetType = TARGET_68K20;
    else if (match(type, "ISI 68225"))
	targetType = TARGET_68225;
    else if (match(type, "ISI 68030"))
	targetType = TARGET_68K30;
    else if (match(type, "ISI Eagle-5"))
	targetType = TARGET_E5;
    else targetType = 0;
}

/*#define VB_BOZO /**/
#ifdef VB_BOZO
/* for reference only... 
struct	icpu {
	unsigned char		ic_active[MAXCPU];
	short			ic_ncpu;
	u_char			ic_ethaddr[6];
	struct ring		*ic_freeringp;
	struct ring		*ic_inputringp[MAXCPU];
	unsigned short		*ic_intrinfo[MAXCPU];
};
struct  vb_softc {
	struct		arpcom vs_ac;
	int		vs_size;
	unsigned char	vs_state;
	struct icpu	*vs_icpup;
	struct ring	*vs_freeringp;
	struct ring	*vs_inputringp;
} vb_softc[NVB];
... */


#define v	vb_softc[0]
vbshow()
{
	int i;

	printf("vb_softc:\n");
	printf("	vs_size=%d\n", v.vs_size);
	printf("	vs_state=%d\n", v.vs_state);
	printf("	vs_icpup=0x%08x\n", v.vs_icpup);
	printf("		ic_ncpu=%d\n", v.vs_icpup->ic_ncpu);
	printf("		ic_freeringp=0x%08x\n",
	    v.vs_icpup->ic_freeringp);
	printf("		ic_ethaddr=%x:%x:%x:%x:%x:%x\n",
				    v.vs_icpup->ic_ethaddr[0],
				    v.vs_icpup->ic_ethaddr[1],
				    v.vs_icpup->ic_ethaddr[2],
				    v.vs_icpup->ic_ethaddr[3],
				    v.vs_icpup->ic_ethaddr[4],
				    v.vs_icpup->ic_ethaddr[5]);
	for(i=0;i<2;++i) {
		printf("		ic_active[%d]=%d\n",
		    i, v.vs_icpup->ic_active[i]);
		printf("		ic_inputringp[%d]=0x%08x\n",
		    i, v.vs_icpup->ic_inputringp[i]);
		printf("		ic_intrinfo[%d]=0x%08x\n",
		    i, v.vs_icpup->ic_intrinfo[i]);
	}
	printf("	vs_freeringp=0x%08x\n", v.vs_freeringp);
	printf("	vs_inputringp=0x%08x\n", v.vs_inputringp);
}
#endif	VB_BOZO
