/* strLib.c - string subroutine library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/* 
modification history
--------------------
01h,01aug88,gae  documentation.
01g,30may88,dnw  changed to v4 names.
01f,03nov87,ecs  documentation.
01e,31mar87,jlf  documentation
01d,24mar87,jlf  documentation
01c,23mar87,llk  added documentation for manual.
01b,09jan87,llk	 improved performance.
01a,23dec86,llk  written
*/

/*
DESCRIPTION
This library contains routines which duplicate the UNIX string
processing package.  The functions operate on null-terminated strings.
They do not check for overflow of any resulting string.

INCLUDE FILE: strLib.h

SEE ALSO: UNIX string documentation, bLib (1), bALib (1)
*/

#include "vxWorks.h"
#include "strLib.h"

/*******************************************************************************
*
* strlen - determine string length
*
* This routine returns the number of characters in `s' not including EOS.
*
* RETURNS: number of non-null characters in the string
*/

int strlen (s)
    FAST char *s;	/* string */

    {
    FAST char *p = s;

    while (*(p++) != EOS)
	;
    return (p - s - 1);
    }
/*******************************************************************************
*
* strcpy - string copy
*
* Copies string `s2' (including EOS) to string `s1'.
* 
* RETURNS: pointer to `s1'
*/

char *strcpy (s1, s2)
    char *s1;	/* string to be copied to */
    char *s2;	/* string to copy from    */

    {
    FAST char *p1 = s1;
    FAST char *p2 = s2;

    while ((*(p1++) = *(p2++)) != EOS)
	;
    return (s1);
    }
/*******************************************************************************
*
* strncpy - copy `n' characters from one string to another
*
* Copies exactly `n' characters from string `s2' to string `s1'.
* If `n' is greater than the length of `s2', nulls are added to `s1'.
* If `n' is less than or equal to the length of `s2', the target
* string may not be null-terminated.
*
* RETURNS: pointer to `s1'
*/

char *strncpy (s1, s2, n)
    char *s1;	/* string to be copied to       */
    char *s2;	/* string to copy from          */
    int  n;	/* number of characters to copy */

    {
    FAST int s2len;		/* length of s2 */

    s2len = strlen (s2);

    if (n <= s2len)
	bcopy (s2, s1, n);
    else
	{
	/* copy s2 to s1 and pad with nulls */

	bcopy (s2, s1, s2len);
	bfill (&s1 [s2len], n - s2len, EOS);
	}

    return (s1);
    }
/*******************************************************************************
*
* strcat - concatenate one string to another
*
* Appends a copy of string `s2' to end of string `s1'.
* Resulting string `s1' is null terminated.
*
* RETURNS: pointer to `s1'
*/

char *strcat (s1, s2)
    FAST char *s1;	/* string to be appended to */
    FAST char *s2;	/* string to append to s1   */

    {
    /* append all of s2 to s1, including EOS */

    strcpy (&s1 [strlen (s1)], s2);
    return (s1);
    }
/*******************************************************************************
*
* strncat - concatenate `n' characters from one string to another
*
* Appends, at most, `n' characters from string `s2' to end of string `s1'.
*
* RETURNS: pointer to null-terminated `s1'
*/

char *strncat (s1, s2, n)
    FAST char *s1;	/* string to be appended to           */
    FAST char *s2;	/* string to append to s1             */
    int  n;		/* max number of characters to append */

    {
    FAST char *p1;
    FAST char *p2 = s2;

    p1 = index (s1, EOS);

    while ((n-- > 0) && ((*(p1++) = *(p2++)) != EOS))
	;
    if (n <= 0)
	*p1 = EOS;
    return (s1);
    }
/*******************************************************************************
*
* strcmp - compare strings
*
* Compares string `s1' to string `s2'.  Returns an integer greater than,
* equal to, or less than 0 according to whether `s1' is lexicographically
* greater than, equal to, or less than `s2'.
*
* RETURNS: an integer greater than, equal to, or less than 0
*/

int strcmp (s1, s2)
    char *s1;	/* string to compare         */
    char *s2;	/* string to compare `s1' to */

    {
    FAST char *p1 = s1;
    FAST char *p2 = s2;

    while (*p1 == *p2)
	{
	if (*p1 == EOS)
	    return (0);		/* both reached EOS then they're equal */

	p1++;
	p2++;
	}

    return (*p1 - *p2);
    }
/*******************************************************************************
*
* strncmp - compares up to `n' characters from one string to another
*
* Compares, at most, `n' characters of string `s1' to string `s2'.
* Returns an integer greater than, equal to, or less than 0 according to
* whether `s1' is lexicographically greater than, equal to, or less than `s2'.
*
* RETURNS: an integer greater than, equal to, or less than 0
*/

int strncmp (s1, s2, n)
    char *s1;		/* string to compare                   */
    char *s2;		/* string to compare `s1' to           */
    int  n;		/* max number of characters to compare */

    {
    FAST char *p1 = s1;
    FAST char *p2 = s2;

    while ((*p1 == *p2) && (n > 0))
	{
	if (*p1 == EOS)
	    return (0);		/* both reached EOS then they're equal */

	p1++;
	p2++;
	n--;
	}

    if (n == 0)
	return (0);
    else
    	return (*p1 - *p2);
    }
/*******************************************************************************
*
* index - find a character in a string
*
* This routine returns a pointer to the first occurrence of character `c'
* in string `s'.
* 
* RETURNS:
*  pointer to the first occurrence of character `c' in string `s', or
*  NULL if not found
*/

char *index (s, c)
    FAST char *s;	/* string in which to find character */
    FAST char c;	/* character to find in string       */

    {
    FAST char ch;

    while (((ch = *(s++)) != c) && (ch != EOS))
	;

    return (((ch == EOS) && c != EOS) ? NULL : --s);
    }
/*******************************************************************************
*
* rindex - find the last occurrence of a character in a string
*
* This routine returns a pointer to the last occurrence of character `c'
* in string `s'.
* 
* RETURNS:
*  pointer to the last occurrence of character `c' in string `s', or
*  NULL if not found
*/

char *rindex (s, c)
    FAST char *s;	/* string in which to find character */
    char c;		/* character to find in string       */

    {
    int i;	/* index into s */

    i = strlen (s);	/* point to null terminator of s */

    while (i >= 0)
	{
	if (s [i] == c)
	    return (&s [i]);
	i--;
	}
    return (NULL);
    }
