/* netLib.c - network interface library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
02i,28nov88,gae  moved netHelp to usrLib.c to shrink bootroms.
02h,04nov88,dnw  changed JOB_RING_SIZE from 2000 to (85*sizeof(TODO_NODE))
		   so that ring overflow won't cause ring to be permanently
		   out of sync.
02g,18aug88,gae  documentation.  removed obsolete header includes.
02f,22jun88,dnw  name tweaks.
02e,06jun88,dnw  changed taskSpawn/taskCreate args.
02d,30may88,dnw  changed to v4 names.
02c,28may88,dnw  removed if{config,broadcast,netmask} to ifLib.
		 deleted obsolete netGetInetAddr.
		 removed mbufStat to uipc_mbuf.
		 moved setNetStatus here from sockLib.
		 changed call to fioStdIn to STD_IN.
02b,05mar88,jcf  changed semaphore calls for new semLib.
02a,22feb88,jcf  made kernel independent.
01v,16feb88,rdc  added ifnetmask.
01u,05jan88,rdc  added include of systm.h
01t,23nov87,ecs  lint.
01s,20nov87,jcf  added vxAddRebootRtn call in netStart.
	   +gae  spawned netd with 0 args to look nice.
01r,18nov87,ecs  documentation.
01q,17nov87,ecs  lint: added include of inetLib.h.
01p,11nov87,jlf  documentation
01o,08nov87,dnw  updated and expanded nethelp.
01n,01nov87,llk  removed addRoute(), addNetRoute(), deleteRoute().
		 moved inet_lnaof() to inetLib.c.
		 changed remInetAddr() calls to UNIX compatible inet_addr().
		 changed filbuf(0) calls to bzero().
		 added netGetInetAddr().
		 moved nethelp() here from remLib.c.
01m,02may87,dnw  removed unnecessary includes.
		 removed initialization of obsolete "hz".
		 moved call to ifinit() to netStart() from usrConfig.c.
01l,04apr87,jlf  documentation fix.
01k,03apr87,llk  documentation.
01j,02apr87,jlf  more delinting. grrrrrr.
01i,01apr87,jlf  more documentation.
		 delinted.
	    ecs  added include of strLib.h.
01h,26mar87,rdc  added addNetRoute().
01g,23mar87,jlf  documentation.
01f,27feb87,dnw  changed to spawn netd UNBREAKABLE.
01e,10dec86,dnw  reduced TO_DO_RING_SIZE from 10000 to 2000.
01d,19nov86,llk  made netd unbreakable.
01c,08nov86,dnw  changed netd to perform all actions at splnet().
		 changed to spawn netd at "netPriority" level,
		   and let spawn choose task id (saved in netdId).
		 fixed bug of trying to report error with interrupts
		   disabled.
01b,06nov86,rdc  ifconfig and the routing stuff had some unclosed sockets.
01a,28jul86,rdc  written.
*/

/*
The netLib module contains the network task which runs low-level network
interface routines in a task context.  The network task simply removes
and executes routines from a job queue which were added to with netJobAdd.
Network interfaces use this facility to have their interrupt
level processing done at task level.

The routine netHelp gives a synopsis of the various network facilities
available from the VxWorks Shell.

SEE ALSO: routeLib (1), hostLib (1), netDrv (3), "Network"
*/

#include "vxWorks.h"
#include "rngLib.h"
#include "semLib.h"
#include "taskLib.h"

IMPORT SEM_ID splSemId;
IMPORT VOID ifreset ();

typedef struct
    {
    FUNCPTR routine;	/* routine to be called */
    int param1;		/* arg to routine */
    int param2;
    int param3;
    int param4;
    int param5;
    } TODO_NODE;

#define JOB_RING_SIZE (85 * sizeof (TODO_NODE))

/* netTask parameters */

int netTaskId;
int netTaskPriority	= 50;	/* task priority at which network stuff runs */
int netTaskOptions	= VX_SUPERVISOR_MODE | VX_UNBREAKABLE;
int netTaskStackSize	= 4000;

/* local variables */

LOCAL SEM_ID netTaskSemId;	/* netTask work-to-do semaphore */
LOCAL RING_ID netJobRing;	/* ring buffer of net jobs to do */

/*******************************************************************************
*
* netTask - the network task
*
* netTask is the VxWorks network support task.
* Most of the VxWorks network runs in the context of this task.
* Its priority can be changed to adjust the effective priority of the
* network relative to the application.
*
* This task is spawned by netLibInit (2).
*
* INTERNAL
* netTask reads messages from a ring buffer which is filled by calling
* netJobAdd.
*/

VOID netTask ()

    {
    TODO_NODE jobNode;
    int s;

    FOREVER
	{
	/* wait for somebody to wake us up */

	semTake (netTaskSemId);

	/* process requests in the toDo list */

	while (rngIsEmpty (netJobRing) == FALSE)
	    {
	    if (rngBufGet (netJobRing, (char *) &jobNode, 
			   sizeof (jobNode)) != sizeof (jobNode))
		panic ("netTask: netJobRing overflow!!!\n");

	    s = splnet ();

	    (*(jobNode.routine)) (jobNode.param1, jobNode.param2,
				  jobNode.param3, jobNode.param4,
				  jobNode.param5);
	    splx (s);
	    }
	}
    }
/*******************************************************************************
*
* netJobAdd - add a routine to the network task job queue
*
* This function allows a routine and up to 5 parameters,
* to be added to the network job queue.
* Only network interfaces should use this function, usually
* to have their interrupt level processing done at task level.
*
* RETURNS: OK
*
* VARARGS1
* NO_MANUAL
*/

STATUS netJobAdd (routine, param1, param2, param3, param4, param5)
    FUNCPTR routine;
    int param1;
    int param2;
    int param3;
    int param4;
    int param5;

    {
    FAST int oldlevel;
    TODO_NODE newNode;
    BOOL ok;

    newNode.routine = routine;
    newNode.param1 = param1;
    newNode.param2 = param2;
    newNode.param3 = param3;
    newNode.param4 = param4;
    newNode.param5 = param5;

    oldlevel = intLock ();
    ok = rngBufPut (netJobRing, (char *) &newNode, sizeof (newNode)) == 
							sizeof (newNode);
    intUnlock (oldlevel);

    if (!ok)
	panic ("netJobAdd: ring buffer overflow\n");

    /* wake up the network daemon to process the request */

    semGive (netTaskSemId);

    return (OK);
    }
/*******************************************************************************
*
* netLibInit - initialize the network package
*
* netLibInit should be called once to initialize the network normally in
* usrRoot (2), in usrConfig (1).  It installs the socket driver,
* creates the network task job queue, and spawns the network task.
*
* RETURNS: OK or ERROR if unable initialize network support
*/

STATUS netLibInit ()

    {
    static BOOL done = FALSE;

    if (done)
	return (netTaskId == ERROR ? ERROR : OK);

    done = TRUE;

    /* install socket driver */

    if (sockInit () == ERROR)
	panic ("netLibInit: couldn't install socket driver\n");;

    if ((netJobRing = rngCreate (JOB_RING_SIZE)) == (RING_ID) NULL)
	panic ("netLibInit: couldn't create job ring\n");

    if (rebootHookAdd (ifreset) == ERROR)
	logMsg ("netLibInit: unable to add reset hook\n");

    netTaskSemId = semCreate ();
    splSemId = semCreate ();
    semGive (splSemId);

    mbinit ();

    ifinit ();
    domaininit ();

    netTaskId = taskSpawn ("netTask", netTaskPriority,
		           netTaskOptions, netTaskStackSize,
			   netTask, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	
    return (netTaskId == ERROR ? ERROR : OK);
    }
/*******************************************************************************
*
* netErrnoSet - set network error status
*
* netErrnoSet calls errnoSet (2) with the given `status' or'd with the
* network status prefix.
*
* NO_MANUAL
*/

VOID netErrnoSet (status)
    int status;

    {
    errnoSet (M_errno | status);
    }
