/* dbgALib.s - debugging aids assembly language interface */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history
--------------------
06g,21nov88,jcf  added dbgCacheEntryClear to address cache coherency problem.
06f,13feb88,dnw  added .data before .asciz above, for Intermetrics assembler.
06e,23mar87,jlf  documentation.
06d,26feb87,rdc  modifications for VRTX 3.2.
06c,21dec86,dnw  changed to not get include files from default directories.
06b,01nov86,dnw  Changed "moveml" instructions to use Motorola style register
		   lists, which are now handled by "aspp".
		 Changed "mov[bwl]" to "move[bwl]" for compatiblity w/Sun as.
06a,03apr86,dnw  Extracted all but breakpoint and trace stubs to excALib.s.
05b,17mar86,jlf  Added a generic 68010/20 exceptions handler.
		 Changed names from ...Int to ...Stub.
		 Added several 68000 exceptions.
		 Made all exceptions call dbgExceptions, which now
		   handles them all.
		 Made the trace exception change the format of the
		   stack frame if 68020, since vrtx68010 isn't able to handle
		   the 6-word frame format.
05a,08feb86,dnw  removed dbgTskSwap routine; now use vxAddTaskSwitchRtn
		 removed dbgVInit routine; now in dbgLib.c
		 renamed all interrupt drivers to _dbg...Int and made them
		   known externally so that vector init now in dbgLib.c can
		   reference them.
04e,20jul85,jlf  documentation.
04d,24jun85,rdc  added SYSTEM V conditional assembly (truncated symbols)
04c,19jun85,rdc  changed .globls for 4.2 as.
04b,12jun85,rdc  added c style comments and 68010 conditional assembly.
04a,23may85,jlf  translated from asm to as.  Added copyright.
                 changed UI_ENTER and EXIT traps to intEnt and intExit.     
03a,05apr85,rdc  installed modifications for vrtx version 3.
02f,23jan85,ecs  added vectors for 1010 & 1111 instructions.
02e,13sep84,ecs  changed trace to use UI_EXIT instead of rte.
02d,11sep84,jlf&ecs  changed dbgInit to dbgVInit.  Added NOMANUAL's.
		 fixed error in error2.
02c,24aug84,ecs  changed calling sequence of dbgBreakpoint, dbgABerror.
02b,20aug84,ecs  added _dbgTswap, trace.
02a,16aug84,ecs  changed name (regretfully) from cbugasm.s to dbgALib.s.
		 changed initCbug to dbgInit.
	         added illegal instruction/breakpoint trap handler.
01c,25jun84,ecs  changed buserror/adderror to exit via vrtx rather than
		 ubug.
01b,17jun84,dnw  changed to use top of memory as stack adrs instead
		 of start of task, which won't work anymore.
		 NOTE: This is temporary and should be changed to
		 be allocated from the pool or something.
01a,06feb84,ecs  written
*/

/*
DESCRIPTION
This module contains assembly language routines needed for the debug
package and the 680x0 exception vectors.  There are no user-callable
routines here.
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "asm.h"

	/* internal */

	.globl	_dbgBpStub		/* breakpoint exceptions handler */
	.globl	_dbgTraceStub		/* trace exceptions handler */
	.globl	_dbgCacheEntryClear	/* 680{20,30} cache coherency routine */

	/* external */

	.globl	_dbgBreakpoint	/* breakpoint processing routine */
	.globl	_dbgTrace	/* trace processing routine */
	.globl	_intEnt		/* interrupt entry routine */
        .globl  _intExit	/* interrupt exit routine */

	.text
	.even

/****************************************************************************
*
* trap2 - breakpoint handling
*
* NOMANUAL
*/

_dbgBpStub:		/* breakpoint interrupt driver */
	moveml	d0-d7/a0-a7,a7@-	/* save regs */
	movel	a7,a5			/* a7 points to saved regs */
	link	a6,#0
	subql	#0x2,a6@(0x46)		/* adjust saved program counter */
	movel	a5,a7@-			/* push pointer to saved regs */
	pea	a6@(0x44)		/* push pointer to saved info */
	jsr	_dbgBreakpoint		/* do breakpoint handling */

/* we only return if the breakpoint was hit at interrupt level */

	addl	#8,a7			/* pop the params to dbgBreakpoint */
	unlk	a6
	moveml	a7@+,d0-d7/a0-a7	/* restore regs */
	rte

/**************************************************************************
*
* trace - trace exception processing
*
* NOMANUAL
*/

_dbgTraceStub:		/* trace interrupt driver */
	andw	#0x7fff,a7@		/* clear trace bit in saved status */
	moveml	d0-d7/a0-a7,a7@-	/* save regs */
	movel	a7,a5			/* a7 points to saved regs */
	link	a6,#0
	movel	a5,a7@-			/* push pointer to saved regs */
	pea	a6@(0x44)		/* push pointer to saved info */
	jsr	_dbgTrace

/* we returned from dbgTrace if this was a CONTINUE or the break was hit 
 * at interrupt level */

	addl	#8,a7			/* pop params to dbgTrace */
	unlk	a6
	moveml	a7@+,d0-d7/a0-a7	/* restore regs */
	rte

/*******************************************************************************
*
* dbgCacheEntryClear - clear address from the 68k instuction cache
*
* This c callable routine is used to clear the specified instruction address
* from the 68020/68030 instruction cache.
*
* NOMANUAL
*    This routine belongs in a library cacheLib? of cache routines.
*
* VOID dbgCacheEntryClear (address)
*     int address;         /* new value for cache address register *

*/

_dbgCacheEntryClear:

#if (CPU==MC68020)			/* 68030's are considered 68020's */
	movel	a7@(0x4),d0		/* address to clear */

	/* Since the assemblers differ on the syntax for this one
	   (if they even have it), it's done with two .word's.  Yucko. */

	.word	0x4e7b, 0x0802		/* movec d0,caar */
	.word	0x4e7a, 0x0002		/* movec cacr,d0 */
	orl	#0x4,d0			/* set the clear entry bit */
	.word	0x4e7b, 0x0002		/* movec d0,cacr */ 

#endif (CPU==MC68020)

	rts
