/* ctypeLib.c - character classification and conversion macros */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01f,17apr89,dab  added C_CONTROL to ht, nl, vt, np, cr. added
		   C_HEX_NUMBER TO `0' - `9'. changed C_PUNCT to
		   C_B for `space'.
01e,20aug88,gae  documentation.
01d,05nov87,jlf  documentation.
01c,01apr87,jlf  documentation.
01b,23mar87,jlf  documentation.
01a,12feb87,llk  created.
*/

/*
DESCRIPTION
This UNIX compatible library consists of macros which classify or
convert ASCII-coded characters by table lookup.
The macros are defined in ctype.h.

Each macro takes a character parameter, and return non-zero for TRUE, 
or zero for FALSE.

.CS
    isalpha  (c) - c is a letter
    isupper  (c) - c is an upper case letter
    islower  (c) - c is a lower case letter
    isdigit  (c) - c is a digit
    isxdigit (c) - c is a hexadecimal digit
    isspace  (c) - c is an space, tab, carriage return, newline,
		     or formfeed
    ispunct  (c) - c is a punctuation character (neither control
		     nor alphanumeric)
    isalnum  (c) - c is an alphanumeric character
    isprint  (c) - c is a printable character, code 040 (space)
		     through 0176 (tilde)
    isgraph  (c) - c is a visible graphics character, code 041
		     (exclamation mark) through 0176 (tilde)
    iscntrl  (c) - c is a delete character (0177) or ordinary
		     control character (less than 040)
    isascii  (c) - c is an ASCII character, code less than 0200
.CE

The following macros perform simple conversions on single characters.

.CS
    toupper  (c) - converts c to its upper case equivalent
    tolower  (c) - converts c to its lower case equivalent
    toascii  (c) - forces c to be ASCII (strips highest eighth
		   bit of character)
.CE

INCLUDE FILE: ctype.h
*/

/* LINTLIBRARY */

#include "ctype.h"

/*
 * This table contains character attributes for all ASCII-coded characters.
 * A character's integer value is used as an index into the
 * table where the character's attributes are or'd together.
 */

char _ctype_ [] =
    {
    /* 0 */ 	0,				/* dummy */
    /* 20 */	C_CONTROL,			/* nul */
    /* 20 */	C_CONTROL,			/* soh */
    /* 20 */	C_CONTROL,			/* stx */
    /* 20 */	C_CONTROL,			/* etx */
    /* 20 */	C_CONTROL,			/* eot */
    /* 20 */	C_CONTROL,			/* enq */
    /* 20 */	C_CONTROL,			/* ack */
    /* 20 */	C_CONTROL,			/* bel */
    /* 20 */	C_CONTROL,			/* bs */
    /* 28 */	C_CONTROL | C_WHITE_SPACE,	/* ht */
    /* 28 */	C_CONTROL | C_WHITE_SPACE,	/* nl */
    /* 28 */	C_CONTROL | C_WHITE_SPACE,	/* vt */
    /* 28 */	C_CONTROL | C_WHITE_SPACE,	/* np */
    /* 28 */	C_CONTROL | C_WHITE_SPACE,	/* cr */
    /* 20 */	C_CONTROL,			/* so */
    /* 20 */	C_CONTROL,			/* si */
    /* 20 */	C_CONTROL,			/* dle */
    /* 20 */	C_CONTROL,			/* dc1 */
    /* 20 */	C_CONTROL,			/* dc2 */
    /* 20 */	C_CONTROL,			/* dc3 */
    /* 20 */	C_CONTROL,			/* dc4 */
    /* 20 */	C_CONTROL,			/* nak */
    /* 20 */	C_CONTROL,			/* syn */
    /* 20 */	C_CONTROL,			/* etb */
    /* 20 */	C_CONTROL,			/* can */
    /* 20 */	C_CONTROL,			/* em */
    /* 20 */	C_CONTROL,			/* sub */
    /* 20 */	C_CONTROL,			/* esc */
    /* 20 */	C_CONTROL,			/* fs */
    /* 20 */	C_CONTROL,			/* gs */
    /* 20 */	C_CONTROL,			/* rs */
    /* 20 */	C_CONTROL,			/* us */
    /* 18 */	C_WHITE_SPACE | C_B,		/* space */
    /* 10 */	C_PUNCT,			/* ! */
    /* 10 */	C_PUNCT,			/* " */
    /* 10 */	C_PUNCT,			/* # */
    /* 10 */	C_PUNCT,			/* $ */
    /* 10 */	C_PUNCT,			/* % */
    /* 10 */	C_PUNCT,			/* & */
    /* 10 */	C_PUNCT,			/* ' */
    /* 10 */	C_PUNCT,			/* ( */
    /* 10 */	C_PUNCT,			/* ) */
    /* 10 */	C_PUNCT,			/* * */
    /* 10 */	C_PUNCT,			/* + */
    /* 10 */	C_PUNCT,			/* , */
    /* 10 */	C_PUNCT,			/* - */
    /* 10 */	C_PUNCT,			/* . */
    /* 10 */	C_PUNCT,			/* / */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 0 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 1 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 2 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 3 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 4 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 5 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 6 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 7 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 8 */
    /* 44 */	C_NUMBER | C_HEX_NUMBER,	/* 9 */
    /* 10 */	C_PUNCT,			/* : */
    /* 10 */	C_PUNCT,			/* ; */
    /* 10 */	C_PUNCT,			/* < */
    /* 10 */	C_PUNCT,			/* = */
    /* 10 */	C_PUNCT,			/* > */
    /* 10 */	C_PUNCT,			/* ? */
    /* 10 */	C_PUNCT,			/* @ */
    /* 41 */	C_UPPER | C_HEX_NUMBER,		/* A */
    /* 41 */	C_UPPER | C_HEX_NUMBER,		/* B */
    /* 41 */	C_UPPER | C_HEX_NUMBER,		/* C */
    /* 41 */	C_UPPER | C_HEX_NUMBER,		/* D */
    /* 41 */	C_UPPER | C_HEX_NUMBER,		/* E */
    /* 41 */	C_UPPER | C_HEX_NUMBER,		/* F */
    /* 01 */	C_UPPER,			/* G */
    /* 01 */	C_UPPER,			/* H */
    /* 01 */	C_UPPER,			/* I */
    /* 01 */	C_UPPER,			/* J */
    /* 01 */	C_UPPER,			/* K */
    /* 01 */	C_UPPER,			/* L */
    /* 01 */	C_UPPER,			/* M */
    /* 01 */	C_UPPER,			/* N */
    /* 01 */	C_UPPER,			/* O */
    /* 01 */	C_UPPER,			/* P */
    /* 01 */	C_UPPER,			/* Q */
    /* 01 */	C_UPPER,			/* R */
    /* 01 */	C_UPPER,			/* S */
    /* 01 */	C_UPPER,			/* T */
    /* 01 */	C_UPPER,			/* U */
    /* 01 */	C_UPPER,			/* V */
    /* 01 */	C_UPPER,			/* W */
    /* 01 */	C_UPPER,			/* X */
    /* 01 */	C_UPPER,			/* Y */
    /* 01 */	C_UPPER,			/* Z */
    /* 10 */	C_PUNCT,			/* [ */
    /* 10 */	C_PUNCT,			/* \ */
    /* 10 */	C_PUNCT,			/* ] */
    /* 10 */	C_PUNCT,			/* ^ */
    /* 10 */	C_PUNCT,			/* _ */
    /* 10 */	C_PUNCT,			/* ` */
    /* 42 */	C_LOWER | C_HEX_NUMBER,		/* a */
    /* 42 */	C_LOWER | C_HEX_NUMBER,		/* b */
    /* 42 */	C_LOWER | C_HEX_NUMBER,		/* c */
    /* 42 */	C_LOWER | C_HEX_NUMBER,		/* d */
    /* 42 */	C_LOWER | C_HEX_NUMBER,		/* e */
    /* 42 */	C_LOWER | C_HEX_NUMBER,		/* f */
    /* 02 */	C_LOWER,			/* g */
    /* 02 */	C_LOWER,			/* h */
    /* 02 */	C_LOWER,			/* i */
    /* 02 */	C_LOWER,			/* j */
    /* 02 */	C_LOWER,			/* k */
    /* 02 */	C_LOWER,			/* l */
    /* 02 */	C_LOWER,			/* m */
    /* 02 */	C_LOWER,			/* n */
    /* 02 */	C_LOWER,			/* o */
    /* 02 */	C_LOWER,			/* p */
    /* 02 */	C_LOWER,			/* q */
    /* 02 */	C_LOWER,			/* r */
    /* 02 */	C_LOWER,			/* s */
    /* 02 */	C_LOWER,			/* t */
    /* 02 */	C_LOWER,			/* u */
    /* 02 */	C_LOWER,			/* v */
    /* 02 */	C_LOWER,			/* w */
    /* 02 */	C_LOWER,			/* x */
    /* 02 */	C_LOWER,			/* y */
    /* 02 */	C_LOWER,			/* z */
    /* 10 */	C_PUNCT,			/* { */
    /* 10 */	C_PUNCT,			/* | */
    /* 10 */	C_PUNCT,			/* } */
    /* 10 */	C_PUNCT,			/* ~ */
    /* 20 */	C_CONTROL			/* del */
    };	
