.TH sysPageSet 2 "Sun 3E" "VxWorks Reference Manual"
.ad b
.SH NAME
sysPageSet - change the mmu map
.SH SYNOPSIS
.CS
.nf
VOID sysPageSet (virtual, physical, type)
    UINT virtual;  /* virtual address to be translated */
    UINT physical; /* physical address to be translated into */
    char type;     /* see h/sun3e.h for space types */
.fi
.CE
.SH DESCRIPTION
This changes the map so that a virtual address will map to the physical
address specified.  The change is only made for the context in which it is
called which should be 0.  THIS ROUTINE MUST BE CALLED AFTER sysSegSet BECAUSE
the VIRTUAL ADDRESS UNDERGOES THE SEGMENT TABLE TRANSLATION BEFORE ACCESSING
the PAGE TABLE.  If you haven't got a valid PMEG then you are in trouble.
The type bits are necessary because they are sent out of the page table entry
to inform the CPU of what type of space we are accessing.
Type 0 = Main Memory, Type 1 = I/O space, Type 2 = 16 bit data VME bus
access, type 3 = 32 bit data VME bus access. (Note that the 68020 uses
dynamic bus sizing capability to determine the bus width for a particular
access.  If one had a 16 bit device, however, 32 bit accesses would cause
trouble.  Sun uses a special space that breaks 32 bit accesses into two 16 bit
accesses.  This space is not currently given any area in the virtual map.
There are no protection rings supported here, for now; currently all entries
are set up so task and supervisor level can read and write the space.

.SH ERROR CHECKING
All that is done is a check to see if one is accessing a
virtual address which the segment translation produces a pmeg 0xff
which is reserved for invalid virtual address accesses.
.SH SEE ALSO
sysLib(1)
