.TH sysDualPortMap 2 "Sun 3E" "VxWorks Reference Manual"
.ad b
.SH NAME
sysDualPortMap - dual port local ram
.SH SYNOPSIS
.CS
.nf
STATUS sysDualPortMap (localAddress, vmeAddress, size)
    UINT localAddress;
    UINT vmeAddress;
    UINT size;
.fi
.CE
.SH DESCRIPTION
This routine dual ports the a piece of local memory starting at the specified
address.  The size of the piece is specified in bytes by the size parameter.
The size is rounded up to the nearest page boundary.
The DVMA responds to the lowest megabyte of the VME extended (32 bit address)
and the the VME standard (24 bit address) spaces.  The parameter vmeAdrs
specifies the vmeAdrs that will translate to the specified local address.

.SH NOTE
If one dual ports two local addresses that translate to the same vme
address.  The translation for the most recent sysDualPortMap () is used.

.SH CAVEATS
The Sun 3/e can only dual port 1MB of its memory, so a size greater than
this is not allowed.

The last page (8k) of the vmeAddress megabyte is reserved by sun,
(MON_SHORT_PG) and should not be changed.  So don't specify a region that
will occupy the vme address 0xfe000 thru 0x100000.
.SH SEE ALSO
sysLib(1)
