.TH Target 5 "MZ7122/4" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
Mizar MZ7122, Mizar MZ7124
.SH BOOTING
.PP
The MZ7122, and MZ7124, use the same standard VxWorks two ROM set.
The odd ROM (labeled LB) goes in socket U16,
and the even ROM (labeled HB) goes in U15 (with SmartWatch).
The file bootrom.hex contains the S-record of the bootrom.
Follow the instructions in the ``Getting Started'' chapter to load VxWorks.
.SH "JUMPERING"
.PP
The following jumpers must be changed from the factory defaults.
Consult the MZ7122 manual for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.

.CS
.nf
K3  - ROM configuration - configure for 64K * 8 devices (3-5,4-6).
K4  - bus timeout       - remove to disable.
K5  - system controller - install if board is to be system
                          controller (factory default).
                          NOTE that there must be only one
                          system controller on the back plane
                          and it must be in the first slot.
.fi
.CE

.SH "DEVICES"
.PP
VxWorks supplies a driver for the two on-board serial ports.
The device is created in usrConfig.c, named "/tyCo/0".
A second device is created called "/tyCo/1".
.PP
The MZ7122 also supports several daughter cards.
Contact Mizar for availability of drivers such as those for
the MZ7810 Dual Serial/Single Parallel card,
the MZ7820 VSB card, and the MZ7830 SCSI card.
 

.SH "NETWORK BOARD JUMPERING"
.PP
This CPU works with all VxWorks network drivers.
HOWEVER, OWING TO RESTRICTED ACCESS TO THE VMEbus,
MANY BOARDS REQUIRE DIFFERENT I/O ADDRESS CONFIGURATION.
.CS
.nf
  BOARD           IO-ADRS
 -------         ---------
 Excelan 202      0xff7f0000
 CMC ENP-10       0xffde0000
 ISI nw           0xff780000
.fi
.CE

See the network board jumpering section for
each board's interrupt level and configuration details.

.SH "SPECIAL CONSIDERATIONS"
.PP
The RS232 ports on the MZ7122 are brought out on two RJ-11 connectors.
The console device ("/tyCo/0") comes out the front of the board as "SP1",
as does the auxiliary device ("/tyCo/1").  The pinout of this connector
is listed in Appendix A of the MZ7122 User's Manual (Mizar part number
MZ-7122-M).  A set of cables to connect each connector to a DB25-type connector
is also available from Mizar, as part number MZ-7122-CB.
.PP
The CPU's base VMEbus address is set in software.
The constant LOCAL_MEM_BUS_ADRS, in config.h, is set to 0x400000.
Use of multiple MZ7122s and/or MZ7124s on a backplane will require
all but the first to change this address.
.SH "INTERRUPT STRUCTURE"
.PP
VMEbus interrupts IRQ1 through IRQ7 are connected directly to the CPU.
They are enabled by bits in control register 1, and interrupt the CPU at their
respective actual interrupt levels.  These interrupts are vectored by the
vector number put on the bus by the interrupting device, and are automatically
acknowledged by the MZ7122 hardware.  In addition, BCLR may be enabled at
level 7, auto-vectored; however, in VxWorks the default mode for this board
is release-on-request, so the BCLR interrupt is not used.  In fact, in the
current VxWorks code, if a BCLR interrupt is executed, the board is forced
back to release-on-request (see sysALib.s).  SYSFAIL and/or ACFAIL may also
be enabled at level 7, auto-vectored; they share this interrupt with BCLR
and the ABORT switch, as below.

MZ7122 INTERRUPT STRUCTURE: ON-BOARD INTERRUPTS
.CS
.nf
ABORT switch         level 7         vector 31
m68562 - serial      level 6         vector 30
mailbox              level 5         vector 29
daughter board       level 4         vector 28
heartbeat timer      level 3         vector 27
software SIRQ 2      level 2         vector 26
software SIRQ 1      level 1         vector 25
.fi
.CE
.PP
The on-board interrupts are autovectored as above; they are automatically
acknowledged by the hardware.

MZ7122 MEMORY MAP -- as seen from the CPU
.CS
.nf
0000 0000   000F FFFF       DPRAM - 1 Mbyte
0100 0000   7FFF FFFF       VMEbus A32 space
8000 0000   FDFF FFFF       VMEbus A32 space (DCEN = 0)
8000 0000   FDFF FFFF       daughter card space (if DCEN = 1)
FE40 0000                   generate interrupt to VMEbus
FE50 0000                   control register two (D32)
FE60 0000                   status register (D32)
FE60 0000                   control register one (D32)
FE70 0000   FE70 007E       m68562 serial chip select (even bytes only)
FE80 0000   FEFF FFFF       EPROM (D16)
FF00 0000   FFEF FFFF       VMEbus A24 space
FFFF 0000   FFFF FFFF       VMEbus A16 space
FFFF 8000   FFFF 80FF       Mailbox in VMEbus A16 space
			    (if CPU number is 0)
FFFF 8100   FFFF 81FF       Mailbox in VMEbus A16 space
			    (if CPU number is 1)
    .
    .
    .
FFFF BE00   FFFF BEFF       Mailbox in VMEbus A16 space
			    (if CPU number is 0x3f)
.fi
.CE

All unlisted addresses are reserved.

MZ7122 MEMORY MAP -- as seen from the VMEbus
.CS
.nf

0040 0000   004F FFFF       DPRAM - 1 Mbyte
FFFF 8000   FFFF 80FF       Mailbox in VMEbus A16 space
			    (if CPU number is 0)
FFFF 8100   FFFF 81FF       Mailbox in VMEbus A16 space
			    (if CPU number is 1)
    .
    .
    .
FFFF BE00   FFFF BEFF       Mailbox in VMEbus A16 space
			    (if CPU number is 0x3f)
.fi
.CE
.SH "TECHNICAL SUPPORT"
.PP
Contact Mizar Digital Systems Technical Support Center at (214) 446-2664.
