.TH tyP2Drv 3 "Motorola MVME 133" "VxWorks Reference Manual"
.ad b
.SH NAME
tyP2Drv.c - The MVME-133 P2 tty handler 
.SH DESCRIPTION
This is the driver for the Z8530 Serial Communications Controller chip.
Only the ASYNC modes are supported on the are 2 channels on the P2 bus.
Channel B is the RS-232C port, channel A is an RS-485 port which is untested.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, tyP2Drv to
initialize the driver, and tyP2DevCreate to create devices.

.SH TYP2DRV
Before using the driver, it must be initialized by calling the routine:
.CS
    tyP2Drv ()
.CE
This routine should be called exactly once, before any reads, writes, or
tyP2DevCreates.  Normally, it is called from usrRoot.

.SH CREATING TERMINAL DEVICES
Before a terminal can be used, it must be created.
This is done with the tyP2DevCreate call.
Each port to be used should have exactly one device associated with it,
by calling this routine.

.CS
    STATUS tyP2DevCreate (name, channel, rdBufSize, wrtBufSize)
        char *name;     /* Name to use for this device
        int channel;    /* Physical channel for this device, always 0
        int rdBufSize;  /* Read buffer size, in bytes
        int wrtBufSize; /* Write buffer size, in bytes
.CE

For instance, to create the device "/tyP2/0", with buffer sizes of 512 bytes,
the proper call would be:
.CS
   tyP2DevCreate ("/tyP2/0", 0, 512, 512);
.CE
Port B, or channel 1, is the RS-232C port.  Port A, or channel 0, is RS-485
and untested.

.SH IOCTL
This driver responds to all the same ioctl codes as a normal ty driver.
The baud rates available are 110 through 19.2 baud.
The default baud rate is 9600.
