.TH Target 5 "Integrated Solutions VME-68k20" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: Integrated Solutions VME-68k20
.SH BOOTING
.PP
The VME-68k20 board only contains one ROM socket, which only allows
up to 64K bytes of ROM.  This is not enough space for the VxWorks
system boot.  However, this target board may be booted from an ISI host,
using the ISI standard boot ROMs.
.SH Booting From an ISI Host
.PP
When booting the ISI target over ethernet from an ISI host, the standard ISI
boot ROMs may be used.  The boot line typed to these ROMs may be
exactly the same as that used by the VxWorks boot.  However, the other
boot commands (p, c, etc.) will not work.
.PP
In order to allow remote booting, the ISI host must be set up
properly.  Aside from the normal network setup (/etc/hosts and
/etc/host.equiv) the kernel must be built with the ENET option, and
the boot daemon (bootd) must be running.  The ENET option is added by
adding it to the Makefile in /usr/sys/DISTRIBUTION, and then making a
new kernel.  The boot daemon is normally started in the UNIX
initialization file, /etc/rc.local.
.SH Booting Over a Backplane
.PP
VxWorks systems may be booted over a backplane, either from an ISI Unix
host on the same backplane (cluster configuration), or via a VxWorks gateway.
For the Unix-VxWorks cluster configuration, use standard ISI booting
procedures.  For details on the gateway configuration, see the documentation
for isiBootLib (1).
.SH Booting From a Non-ISI Host
.PP
Booting an ISI target from a non-ISI host is somewhat more
complicated.  In this case, the VxWorks boot ROMs must be used.  The
only way to do this is to put them on a separate VME-bus ROM board,
and then put a ROM in the ISI CPU itself which just jumps to the code
in the external ROMs.
.PP
Note that, in a system where there are multiple CPU boards on a
backplane, it is only necessary to use one external ROM board for all
of them.  The same code can be executed by all the different CPU's.
.SH DEVICES
.PP
VxWorks supplies a driver for the on-board serial ports on the CPU
board.  Only one device, on serial channel 0, is created in usrConfig.c.
It is named "/tyCo/0".  If a second device is required, it may be
added to usrConfig.c, or created at a later time.
.SH CLUSTERS
.PP
The Integrated Solutions Unix system is able to work in a "cluster"
configuration, where there are multiple Unix systems on a VME backplane.
VxWorks supplies a compatible backplane network driver that allows VxWorks
systems to share a backplane with ISI Unix systems, as well.
.PP
As supplied, VxWorks uses a backplane network driver called if_vb.
This driver is compatible with ISI's Unix system.
