.TH sysBCLSet 2 "Heurikon HK68-V2F" "VxWorks Reference Manual"
.ad b
.SH NAME
sysBCLSet - set the bus control latch
.SH SYNOPSIS
.CS
.nf
ULONG sysBCLSet (mask, value)
    ULONG mask;         /* which bits to change */
    ULONG value;        /* what to change bits to */
.fi
.CE
.SH DESCRIPTION
This routine sets or clears bits in the bus control latch.
The parameter "mask" determines which bits will be changed, and "value"
determines the value to which those bits will be set.
In  other words, newBCL = (oldBCL & ~mask) | (value & mask).

.SH NOTE
Bus arbitration on the HK68/V20 is enabled or disabled by a bit in the
bus control latch.  Once a value has been chosen for this bit, it must
not be changed.  If the arbitration bit is changed, bus errors may result.
In order to maintain this bit, from execution in bootConfig(1) through
execution in usrConfig(1), an image of the bus control latch is stored
on the HK68/V20 in low RAM at RAM base plus 0x500 bytes.

.SH RETURNS
previous value of bus control latch

.SH SEE ALSO
sysLib(1),
sysBCLGet(2),
Heurikon HK68/V20 User's Manual
