.TH tyCoDrv 3 "Force SYS68K/CPU-30" "VxWorks Reference Manual"
.ad b
.SH NAME
tyCoDrv.c - The Force-30 DUSCC serial driver 
.SH DESCRIPTION
This is the driver for the Force-30 DUSCC chips.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, tyCoDrv to
initialize the driver, and tyCoDevCreate to create devices.

.SH TYCODRV
Before using the driver, it must be initialized by calling the routine:
.CS
    STATUS tyCoDrv ()
.CE
The status returned is OK.

This routine should be called exactly once, before any reads, writes, or
tyCoDevCreates.  Normally, it is called from usrRoot.

.SH CREATING TERMINAL DEVICES
Before a terminal can be used, it must be created.  This is done
with the tyCoDevCreate call.
Each port to be used should have exactly one device associated with it,
by calling this routine.

.CS
    STATUS tyCoDevCreate (name, channel, rdBufSize, wrtBufSize)
        char *name;     /* Name to use for this device
        int channel;    /* Physical channel for this device, always 0
        int rdBufSize;  /* Read buffer size, in bytes
        int wrtBufSize; /* Write buffer size, in bytes
.CE

For instance, to create the device "/tyCo/0", with buffer sizes of 512 bytes,
the proper call would be:
.CS
   tyCoDevCreate ("/tyCo/0", 0, 512, 512);
.CE
.SH IOCTL
This driver responds to all the same ioctl codes as a normal ty driver.

