.TH Target 5 "Force SYS68K/CPU-21/29/32" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
Force SYS68K/CPU-21, Force SYS68K/CPU-29, Force SYS68K/CPU-32
.SH INSTALLING VxWORKS BOOT EPROMS
.PP
CPU-21
.PP
Install the VxWorks boot EPROMs in "EPROM Area 1" by inserting
them in the upper positions of the stacked DIP sockets.
This requires considerable care to ensure that all the pins are in their
sockets and that none of the pins touch the chips underneath in the lower
positions.
Do not seat the EPROMs all the way down into the sockets.
There should be 1/8 inch gap between the upper and lower chips to avoid
having the upper pins touch the lower pins.
Alternatively, you can trim the upper pins.
.PP
CPU-29 / CPU-32
.PP
Install the VxWorks boot EPROMs LL, L, U, UU in sockets J21, J23, J25, J27,
respectively.  With 27512's pin 1 should begin 2 pinholes down from the
top of the socket.

.SH JUMPERING
.PP
CPU-21
.PP
The following jumpers must be changed from the factory defaults.
Consult the Force CPU-21 documentation for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.
.CS
.nf
  B7  - EPROM area 1 size:
            set for 27512 EPROMs
  B11 - interrupt enables:
            set for level 3 for ENP-10 board, or level 2 for Excelan
            board, and any other interrupt levels required by the
            application
  B21 - system controller:
	    install if board is to be system controller.
            NOTE that there must be only one system controller on the
            backplane and it must be in the first slot.
  B31 - sysclk:
	    install if board is to provide sysclk on the backplane.
            Again, only the first board in the backplane should provide
            sysclk.
.fi
.CE

.PP
CPU-29 / CPU-32
.PP
The following jumpers must be changed from the factory defaults.
Consult the Force CPU-29 / CPU-32 documentation for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.
.CS
.nf
  B7  - EPROM area 1 size:
            set for 27512 EPROMs
  B12 - interrupt enables:
            set for level 3 for ENP-10 board, or level 2 for Excelan
            board, and any other interrupt levels required by the
            application
  B16 - system controller:
	    install if board is to be system controller.
            NOTE that there must be only one system controller on the
            backplane and it must be in the first slot
.fi
.CE

.SH FRONT PANEL SWITCH / ROTARY
.PP
The front panel DIP switch, rotary pair on CPU-29 / CPU-32,
should be set as follows:
.CS
.nf
    1-7 - N/A
    8   -  ON: set for CPU-21, or
        - OFF: set for CPU-29 (rotary #2 < 8)

.CE
.fi
.SH CONSOLE
.PP
VxWorks supplies a driver for the on-board serial port on the CPU board.
The console device, called "/tyCo/0", is created in usrConfig.c.
.PP
On the CPU-21, attach a standard ASCII terminal to the console port
(labeled P4 on the CPU-21, or simply 1 on the CPU-29 / CPU-32).
The USART requires the presence of CTS (voltage low) in order to transmit.
If the USART cannot transmit, the VxWorks internal buffers will eventually
overflow and hang up the shell.
Thus a full 8-wire RS-232 connection to the terminal should be used.
Alternatively, if a 3-wire connection is used, or no console at all
is connected (using only rlogin to access the system) then the problem
can be solved by connecting CTS to RTS.  This is done by connecting
block B9A pin 1 to B9A pin 8 and connecting B9B pin 1 to B9A pin 1.
.SH NETWORK BOARD JUMPERING
.PP
As noted in Special Considerations below, the board's local memory
is not available from the VME bus.
This impacts the Excelan Ethernet controller which does DMA to read and
write network packets.
The VxWorks driver for the Excelan controller requires a few modifications
to run in a special configuration using off-board memory to buffer packets.
Contact Wind River Systems for more information.
.PP
Other Ethernet controllers supported by VxWorks are fully functional
without modification.
.PP
See the network documentation or use the program \fIjump\fP (4) to
configure the network boards.
.SH SPECIAL CONSIDERATIONS
.PP
The Force's on-board memory is not dual ported.
This means that other boards on the VME bus cannot access the board's memory.
In particular, controllers that use DMA will not be able to write directly
to the Force memory, but instead must use additional off-card memory.
The backplane driver must use shared memory if the Force board is in slot 0.
.PP
The board has no mailbox interrupt capability nor any VME interrupt
generation capability.
This means that in multi-processor configurations the backplane network
driver for the board must be confgured either to poll or to use a
user supplied interrupt mechanism.
Force does supply an special system controller, the ASCU-2, that
provides some of these services.
A VxWorks module for the ASCU-2 is a available on an "as is" basis.
.PP
The CPU-21 has only 1/2 M of onboard memory.  Booting full-blown
VxWorks with NFS, RPC, etc. requires slightly more than the memory
available.  The config.h file contains a HALF_MEG variable that should
be set to TRUE for the CPU-21.  After changing the file re-make VxWorks.
.SH BOOTING
.PP
The EPROMs supplied with VxWorks for the CPU-21,
CPU-29 and CPU-32 are identical.
On the CPU-21 at power-on or hardware reset,
the front panel switch 4 must be set to ON.
On the CPU-29 / CPU-32 at power-on or hardware reset,
the front panel rotary #2 must be set to less than 8.
.SH AUTHOR
.PP
Original port of both Force SYS68K/CPU-21 and SYS68K/CPU-29 by
Terry Arden of MacMillan-Bloedel Research, B.C. Canada.
