.TH Target 5 "DY-4 DVME-134" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: DY-4 DVME-134
.SH BOOTING
.PP
The DY-4 DVME-134 board uses the 27011 VxWorks boot ROMs.  Simply program the
ROMs (from the file bootrom.hex), insert them into the CPU board, and
follow the instructions in the ``Getting Started'' chapter.
.PP
Make sure to jumper the DY-4 DVME-134 to use a 27011 EPROM instead of the usual
27512.  The older Intel mask of the 27011 does not reset properly.  It
powers up correctly but subsequent resets do not guarantee that page zero of
the EPROM is loaded.  VxBoot resolves this problem by reseting the EPROM to
page zero when it is done with it.  However, if one were to reset the board
in the first few seconds of life, the board would crash and only turning the
power off would bring it back.  Using the newer 27011 EPROMs would resolve this
problem.
.SH JUMPERING
.PP
This is a table of the jumpers on the DY-4 DVME-134.  It should be used in
conjunction with the DY-4 DVME-134 manual.  All jumpers not mentioned should
be left at factory setting.
  
.IP JB1*
This jumper in conjunction with JB10 determine the interrupt acknowledge
scheme.  JB1 determines how a CPU interrupt level (1 - 7) will be
acknowledged.  The choices are VIACK, 901IACK, AVEC.  If JB10 is set up
to hook the VME interrupt level 2 to CPU level 2, then JB1 should be
configured by jumpering level 2 to VIACK.  Likewise, if JB10 is set up
to hook the MFP chip to level 5, then JB1 should set level 5 to 901IACK.
(see the block diagram of the interrupt structure)
.IP JB3* 
Install jumper for ROR arbitration.
.IP  JB7*
Set for 1M bit.
.IP  JB8*
Remove jumper allowing software to enable the cache.
.IP  JB9*
Remove jumpers because we use timer A on the MFP chip as the system clock
instead of a watchdog timeout which resets the board.
.IP  JB10*
This jumper determines which interrupt source will be hooked up to which
interrupt level.  This jumper is used in conjunction with JB1.  See also
the block diagram of the interrupt structure.
.IP  JB13*
Install jumper so that the front panel button will reset this board.
.IP  JB16
Jumper in (factory setting).  This is the system controller jumper.  Only
one board should be the system controler.
.IP  JB18*
This gives the DY-4 a code which it uses to determine where it should port
its memory in the VME space.  See the DY-4 DVME-134 manual for the translation
table.  VxWorks reads the status register and configures itself according
to this jumper.  In other words if you change this jumper the network
driver will still work.  Note that odd id-codes are not allowed because
the Excellan board resides in standard VME space and needs the DY-4's
memory to be ported there.
.SH "DEVICES"
.PP
VxWorks supplies a driver for the on-board serial port.  A device is created
in usrConfig.c.  It is named "/tyCo/0".  There is no driver provided for the
serial channels on the backplane.
.SH "NETWORK BOARD JUMPERING"
.PP
This CPU currently works with all network drivers and takes the standard
network board configurations.  The CPU must be jumpered to acknowledge
network interrupt levels by configuring jumper blocks JB1 and JB10.  See
the network board jumpering section for each board's interrupt level and
standard VxWorks configuration.
.SH "SPECIAL CONSIDERATIONS"
.PP
The DY-4 DVME-134 powers up in Bus Isolation mode which isolates
the CPU from the VME space.  To take the board out of this mode,
one must make a write to an odd word address
in the upper 1k of on board memory, i.e. 0x000ffc02,0x000ffc06 etc..
VxWorks does this in sysHwInit (2) which is in sysLib (1).
.PP
The DY-4 DVME-134 VxWorks bootroms do not implement the CPU sanity
check like the DY-4 ROMs.  This is why JB9 must be empty.
Otherwise, VxWorks sysClock would reset the CPU!
.PP
The onboard RAM occupies a section of standard (24 bit) space and a section
of extended (32 bit) space as defined by the id-code jumpered on JB18.
Odd id-codes do not dual-port memory into standard space, which is inadequate
for VxWorks.  If one attempts to use an odd id-code the board will halt and
flash the panel LED.  VxWorks figures out how the board has been jumpered and
configures itself accordingly.  This means that multiple DY-4 DVME-134's can be
jumpered to reside in separate VME spaces without having to recompile
each version.
.PP
The interrupt structure is open ended.  Often it is possible to change the
priorities of the interrupt sources without recompiling the code.  As long
as the device provides a vector and JB1 and JB10 are setup to acknowledge
the interrupt correctly.  Remember that an autovector is generated using
the interrupt level and should not be shuffled around.
.PP
To get back to VxWorks bootroms one issues a control-x, which resets all network
drivers and then goes back to the rom monitor.  Memory is not cleared
during a reboot, so application debugging is still possible.
.PP
The DY-4 uses a number of lines on the P2(a,c) bus which may conflict with
other CPU's.  A number of vendors use these buses as high speed memory
buses to their own memory boards.  It is desirable to work in a chasis
that does not bus P2(a,c), so it can be bussed at the discretion of the user.
.PP
The terminal connection requires a null modem cable. (pins 2 and 3 reversed)
.bp
.SH "INTERRUPT STRUCTURE"
.CS
                                           (acknowledge  
                                               type)    cpu
                  jumper vme ints              A         6
                   as net boards               U V M     8
                      require                  T M F     0
                        |                      O E P     2
 (source)             __^__                   _|_|_|_    0
 VME IRQ1 ------------|+?+|------LVL 1-----------+  |--LVL 1 ->
 VME IRQ2 ------------|+?+|------LVL 2-----------+  |--LVL 2 ->
 VME IRQ3 ------------|+?+|------LVL 3-----------+  |--LVL 3 ->
 VME IRQ4 ------------|+?+|------LVL 4-----------+  |--LVL 4 ->
 VME IRQ5 ------------|+ +|  /---LVL 6-----------+  |--LVL 6 ->
 VME IRQ6 ------------|+?+|--/ /-LVL 7-----------+  |--LVL 7 ->
 VME IRQ7 ------------|+?+|----/       /-----------+|--LVL 5 ->
 LM INT --------------|+ +|            |      ^^^^^^^
 AC FAIL -------------|+ +-------LVL 5-/       (JB1)
 SYS FAIL ------------|+ ||            
 RES BUT -------------|+ ||                 
                 -----|+-/|  
                 |    ^^^^^
                 |    (JB10)
                 |
                 ------------------|
                                   |
                                   |
                     _________     |
 RTS ----------------|d0     |     |
 CTS ----------------|d1     |     |
 LM INT -------------|d2     |     |
 BITEL --------------|d3     |     |
 ABORT --------------|d4     |     |
 PARITY -------------|d5     |-----|
 SYSFAIL ------------|d6     |
 AC FAIL ------------|d7     |
                     ^^^^^^^^^
                       MFP
.CE
